/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.debugging;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.teavm.debugging.Debugger;
import org.teavm.debugging.Value;
import org.teavm.debugging.Variable;
import org.teavm.debugging.javascript.JavaScriptLocation;
import org.teavm.debugging.javascript.JavaScriptVariable;

class VariableMap
extends AbstractMap<String, Variable> {
    private AtomicReference<Map<String, Variable>> backingMap = new AtomicReference();
    private Map<String, JavaScriptVariable> jsVariables;
    private Debugger debugger;
    private JavaScriptLocation location;

    public VariableMap(Map<String, JavaScriptVariable> jsVariables, Debugger debugger, JavaScriptLocation location) {
        this.jsVariables = jsVariables;
        this.debugger = debugger;
        this.location = location;
    }

    @Override
    public Set<Map.Entry<String, Variable>> entrySet() {
        this.updateBackingMap();
        return this.backingMap.get().entrySet();
    }

    @Override
    public Variable get(Object key) {
        this.updateBackingMap();
        return this.backingMap.get().get(key);
    }

    @Override
    public int size() {
        this.updateBackingMap();
        return this.backingMap.get().size();
    }

    private void updateBackingMap() {
        if (this.backingMap.get() != null) {
            return;
        }
        HashMap<String, Variable> vars = new HashMap<String, Variable>();
        for (Map.Entry<String, JavaScriptVariable> entry : this.jsVariables.entrySet()) {
            JavaScriptVariable jsVar = entry.getValue();
            String[] names = this.debugger.mapVariable(entry.getKey(), this.location);
            Value value = new Value(this.debugger, jsVar.getValue());
            for (String name : names) {
                if (name == null) {
                    name = "js:" + jsVar.getName();
                }
                vars.put(name, new Variable(name, value));
            }
        }
        this.backingMap.compareAndSet(null, vars);
    }
}

