/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.common;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;

public class RangeTree {
    private NodeImpl root = new NodeImpl();

    public RangeTree(int sz, Iterable<Range> ranges) {
        this.root.start = 0;
        this.root.end = sz;
        ArrayList<Range> rangeList = new ArrayList<Range>();
        for (Range range : ranges) {
            rangeList.add(range);
        }
        Collections.sort(rangeList, (o1, o2) -> {
            if (o1.right != o2.right) {
                return o2.right - o1.right;
            }
            return o1.left - o2.left;
        });
        ArrayDeque<NodeImpl> stack = new ArrayDeque<NodeImpl>();
        stack.push(this.root);
        for (Range range : rangeList) {
            NodeImpl current = new NodeImpl();
            current.start = range.left;
            current.end = range.right;
            while (range.right <= ((NodeImpl)stack.peek()).start) {
                stack.pop();
            }
            NodeImpl parent = (NodeImpl)stack.peek();
            current.next = parent.firstChild;
            parent.firstChild = current;
            current.parent = parent;
            for (NodeImpl ancestor : stack) {
                if (ancestor.start <= current.start) break;
                ancestor.start = current.start;
            }
            stack.push(current);
        }
    }

    public Node getRoot() {
        return this.root;
    }

    private static class NodeImpl
    implements Node {
        public NodeImpl parent;
        public int start;
        public int end;
        public NodeImpl firstChild;
        public NodeImpl next;

        private NodeImpl() {
        }

        @Override
        public Node getParent() {
            return this.parent;
        }

        @Override
        public int getStart() {
            return this.start;
        }

        @Override
        public int getEnd() {
            return this.end;
        }

        @Override
        public Node getNext() {
            return this.next;
        }

        @Override
        public Node getFirstChild() {
            return this.firstChild;
        }
    }

    public static interface Node {
        public Node getParent();

        public int getStart();

        public int getEnd();

        public Node getNext();

        public Node getFirstChild();
    }

    public static class Range {
        public final int left;
        public final int right;

        public Range(int left, int right) {
            this.left = left;
            this.right = right;
        }

        public String toString() {
            return "[" + this.left + "; " + this.right + ")";
        }
    }
}

