/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.common;

import java.util.Arrays;

public class DisjointSet {
    private int[] parent = new int[16];
    private int[] rank = new int[16];
    private int[] setSize = new int[16];
    private int maxRank;
    private int size;

    public int find(int node) {
        int initial = node;
        int depth = 0;
        while (this.parent[node] != node) {
            node = this.parent[node];
            ++depth;
        }
        if (depth > 1) {
            this.parent[initial] = node;
        }
        return node;
    }

    public int[] pack(int count) {
        int[] packed = new int[count];
        int[] packedIndexes = new int[this.size];
        Arrays.fill(packedIndexes, -1);
        int lastIndex = 0;
        for (int i = 0; i < count; ++i) {
            int cls = this.find(i);
            int packedIndex = packedIndexes[cls];
            if (packedIndex < 0) {
                packedIndexes[cls] = packedIndex = lastIndex++;
            }
            packed[i] = packedIndex;
        }
        return packed;
    }

    private void ensureCapacity(int size) {
        if (this.parent.length >= size) {
            return;
        }
        int newCap = size * 3 / 2 + 1;
        this.parent = Arrays.copyOf(this.parent, newCap);
        this.rank = Arrays.copyOf(this.rank, newCap);
        this.setSize = Arrays.copyOf(this.setSize, newCap);
    }

    public int create() {
        int node = this.size++;
        this.ensureCapacity(this.size);
        this.parent[node] = node;
        this.rank[node] = 1;
        this.setSize[node] = 1;
        return node;
    }

    public int union(int a, int b) {
        if ((a = this.find(a)) == (b = this.find(b))) {
            return a;
        }
        if (this.rank[a] > this.rank[b]) {
            this.parent[b] = a;
            int n = a;
            this.setSize[n] = this.setSize[n] + this.setSize[b];
            return a;
        }
        if (this.rank[b] < this.rank[a]) {
            this.parent[a] = b;
            int n = b;
            this.setSize[n] = this.setSize[n] + this.setSize[a];
            return b;
        }
        this.parent[b] = a;
        int n = a;
        this.setSize[n] = this.setSize[n] + this.setSize[b];
        int n2 = a;
        this.rank[n2] = this.rank[n2] + 1;
        this.maxRank = Math.max(this.maxRank, this.rank[a]);
        return a;
    }

    public int sizeOf(int node) {
        return this.setSize[node];
    }

    public int size() {
        return this.size;
    }
}

