/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.callgraph;

import com.carrotsearch.hppc.ObjectIntMap;
import com.carrotsearch.hppc.ObjectIntOpenHashMap;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teavm.callgraph.CallGraph;
import org.teavm.callgraph.DefaultCallGraphNode;
import org.teavm.callgraph.DefaultCallSite;
import org.teavm.callgraph.DefaultClassAccessSite;
import org.teavm.callgraph.DefaultFieldAccessSite;
import org.teavm.callgraph.SerializableCallGraph;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodReference;

public class DefaultCallGraph
implements CallGraph,
Serializable {
    Map<MethodReference, DefaultCallGraphNode> nodes = new LinkedHashMap<MethodReference, DefaultCallGraphNode>();
    Map<FieldReference, Set<DefaultFieldAccessSite>> fieldAccessSites = new LinkedHashMap<FieldReference, Set<DefaultFieldAccessSite>>();
    Map<String, Set<DefaultClassAccessSite>> classAccessSites = new LinkedHashMap<String, Set<DefaultClassAccessSite>>();

    @Override
    public DefaultCallGraphNode getNode(MethodReference method) {
        return this.nodes.computeIfAbsent(method, k -> new DefaultCallGraphNode(this, method));
    }

    public Collection<DefaultFieldAccessSite> getFieldAccess(FieldReference reference) {
        Set<DefaultFieldAccessSite> resultSet = this.fieldAccessSites.get(reference);
        return resultSet != null ? Collections.unmodifiableSet(resultSet) : Collections.emptySet();
    }

    void addFieldAccess(DefaultFieldAccessSite accessSite) {
        this.fieldAccessSites.computeIfAbsent(accessSite.getField(), k -> new HashSet()).add(accessSite);
    }

    public Collection<DefaultClassAccessSite> getClassAccess(String className) {
        Set<DefaultClassAccessSite> resultSet = this.classAccessSites.get(className);
        return resultSet != null ? Collections.unmodifiableSet(resultSet) : Collections.emptySet();
    }

    void addClassAccess(DefaultClassAccessSite accessSite) {
        this.classAccessSites.computeIfAbsent(accessSite.getClassName(), k -> new HashSet()).add(accessSite);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        SerializableCallGraphBuilder builder = new SerializableCallGraphBuilder();
        out.writeObject(builder.build(this));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        SerializableCallGraph scg = (SerializableCallGraph)in.readObject();
        this.nodes = new LinkedHashMap<MethodReference, DefaultCallGraphNode>();
        this.fieldAccessSites = new LinkedHashMap<FieldReference, Set<DefaultFieldAccessSite>>();
        this.classAccessSites = new LinkedHashMap<String, Set<DefaultClassAccessSite>>();
        new CallGraphBuilder().build(scg, this);
    }

    static class CallGraphBuilder {
        List<DefaultCallGraphNode> nodes = new ArrayList<DefaultCallGraphNode>();
        List<DefaultCallSite> callSites = new ArrayList<DefaultCallSite>();
        List<DefaultFieldAccessSite> fieldAccessList = new ArrayList<DefaultFieldAccessSite>();
        List<DefaultClassAccessSite> classAccessList = new ArrayList<DefaultClassAccessSite>();

        CallGraphBuilder() {
        }

        void build(SerializableCallGraph scg, DefaultCallGraph cg) {
            for (SerializableCallGraph.Node node : scg.nodes) {
                this.nodes.add(new DefaultCallGraphNode(cg, node.method));
            }
            for (SerializableCallGraph.CallSite callSite : scg.callSites) {
                this.callSites.add(new DefaultCallSite(callSite.location, this.nodes.get(callSite.callee), this.nodes.get(callSite.caller)));
            }
            for (SerializableCallGraph.FieldAccess fieldAccess : scg.fieldAccessList) {
                this.fieldAccessList.add(new DefaultFieldAccessSite(fieldAccess.location, this.nodes.get(fieldAccess.callee), fieldAccess.field));
            }
            for (SerializableCallGraph.ClassAccess classAccess : scg.classAccessList) {
                this.classAccessList.add(new DefaultClassAccessSite(classAccess.location, this.nodes.get(classAccess.callee), classAccess.className));
            }
            for (int n : scg.nodeIndexes) {
                DefaultCallGraphNode node = this.nodes.get(n);
                cg.nodes.put(node.getMethod(), node);
            }
            for (int n : scg.fieldAccessIndexes) {
                cg.addFieldAccess(this.fieldAccessList.get(n));
            }
            for (int n : scg.classAccessIndexes) {
                cg.addClassAccess(this.classAccessList.get(n));
            }
        }
    }

    static class SerializableCallGraphBuilder {
        List<SerializableCallGraph.Node> nodes = new ArrayList<SerializableCallGraph.Node>();
        ObjectIntMap<DefaultCallGraphNode> nodeToIndex = new ObjectIntOpenHashMap();
        List<SerializableCallGraph.CallSite> callSites = new ArrayList<SerializableCallGraph.CallSite>();
        List<DefaultCallSite> originalCallSites = new ArrayList<DefaultCallSite>();
        ObjectIntMap<DefaultCallSite> callSiteToIndex = new ObjectIntOpenHashMap();
        List<SerializableCallGraph.FieldAccess> fieldAccessList = new ArrayList<SerializableCallGraph.FieldAccess>();
        ObjectIntMap<DefaultFieldAccessSite> fieldAccessToIndex = new ObjectIntOpenHashMap();
        List<SerializableCallGraph.ClassAccess> classAccessList = new ArrayList<SerializableCallGraph.ClassAccess>();
        ObjectIntMap<DefaultClassAccessSite> classAccessToIndex = new ObjectIntOpenHashMap();
        List<DefaultCallGraphNode> nodesToProcess = new ArrayList<DefaultCallGraphNode>();
        List<DefaultCallSite> callSitesToProcess = new ArrayList<DefaultCallSite>();
        List<DefaultFieldAccessSite> fieldAccessToProcess = new ArrayList<DefaultFieldAccessSite>();
        List<DefaultClassAccessSite> classAccessToProcess = new ArrayList<DefaultClassAccessSite>();

        SerializableCallGraphBuilder() {
        }

        SerializableCallGraph build(DefaultCallGraph cg) {
            SerializableCallGraph scg = new SerializableCallGraph();
            scg.nodeIndexes = cg.nodes.values().stream().mapToInt(this::getNode).toArray();
            scg.fieldAccessIndexes = cg.fieldAccessSites.values().stream().flatMapToInt(accessSites -> accessSites.stream().mapToInt(this::getFieldAccess)).toArray();
            scg.classAccessIndexes = cg.classAccessSites.values().stream().flatMapToInt(accessSites -> accessSites.stream().mapToInt(this::getClassAccess)).toArray();
            while (this.step()) {
            }
            scg.nodes = this.nodes.toArray(new SerializableCallGraph.Node[0]);
            scg.callSites = this.callSites.toArray(new SerializableCallGraph.CallSite[0]);
            scg.fieldAccessList = this.fieldAccessList.toArray(new SerializableCallGraph.FieldAccess[0]);
            scg.classAccessList = this.classAccessList.toArray(new SerializableCallGraph.ClassAccess[0]);
            return scg;
        }

        boolean step() {
            return this.processNodes() | this.processCallSites() | this.processFieldAccess() | this.processClassAccess();
        }

        boolean processNodes() {
            boolean hasAny = false;
            for (DefaultCallGraphNode node : this.nodesToProcess.toArray(new DefaultCallGraphNode[0])) {
                int index = this.nodeToIndex.get((Object)node);
                SerializableCallGraph.Node serializableNode = this.nodes.get(index);
                serializableNode.method = node.getMethod();
                serializableNode.callSites = node.getCallSites().stream().mapToInt(this::getCallSite).toArray();
                serializableNode.callerCallSites = node.getCallerCallSites().stream().mapToInt(this::getCallSite).toArray();
                serializableNode.fieldAccessSites = node.getFieldAccessSites().stream().mapToInt(this::getFieldAccess).toArray();
                serializableNode.classAccessSites = node.getClassAccessSites().stream().mapToInt(this::getClassAccess).toArray();
                hasAny = true;
            }
            this.nodesToProcess.clear();
            return hasAny;
        }

        boolean processCallSites() {
            boolean hasAny = false;
            for (DefaultCallSite callSite : this.callSitesToProcess.toArray(new DefaultCallSite[0])) {
                int index = this.callSiteToIndex.get((Object)callSite);
                SerializableCallGraph.CallSite scs = this.callSites.get(index);
                scs.location = callSite.getLocation();
                scs.caller = this.getNode(callSite.getCaller());
                scs.callee = this.getNode(callSite.getCallee());
                hasAny = true;
            }
            this.callSitesToProcess.clear();
            return hasAny;
        }

        boolean processFieldAccess() {
            boolean hasAny = false;
            for (DefaultFieldAccessSite accessSite : this.fieldAccessToProcess.toArray(new DefaultFieldAccessSite[0])) {
                int index = this.fieldAccessToIndex.get((Object)accessSite);
                SerializableCallGraph.FieldAccess sfa = this.fieldAccessList.get(index);
                sfa.location = accessSite.getLocation();
                sfa.field = accessSite.getField();
                sfa.callee = this.getNode(accessSite.getCallee());
                hasAny = true;
            }
            this.fieldAccessToProcess.clear();
            return hasAny;
        }

        boolean processClassAccess() {
            boolean hasAny = false;
            for (DefaultClassAccessSite accessSite : this.classAccessToProcess.toArray(new DefaultClassAccessSite[0])) {
                int index = this.classAccessToIndex.get((Object)accessSite);
                SerializableCallGraph.ClassAccess sca = this.classAccessList.get(index);
                sca.location = accessSite.getLocation();
                sca.className = accessSite.getClassName();
                sca.callee = this.getNode(accessSite.getCallee());
                hasAny = true;
            }
            this.classAccessToProcess.clear();
            return hasAny;
        }

        private int getNode(DefaultCallGraphNode node) {
            int index = this.nodeToIndex.getOrDefault((Object)node, -1);
            if (index < 0) {
                index = this.nodeToIndex.size();
                this.nodeToIndex.put((Object)node, index);
                this.nodes.add(new SerializableCallGraph.Node());
                this.nodesToProcess.add(node);
            }
            return index;
        }

        private int getCallSite(DefaultCallSite callSite) {
            int index = this.callSiteToIndex.getOrDefault((Object)callSite, -1);
            if (index < 0) {
                index = this.callSiteToIndex.size();
                this.callSiteToIndex.put((Object)callSite, index);
                this.callSites.add(new SerializableCallGraph.CallSite());
                this.callSitesToProcess.add(callSite);
            }
            return index;
        }

        private int getFieldAccess(DefaultFieldAccessSite fieldAccessSite) {
            int index = this.fieldAccessToIndex.getOrDefault((Object)fieldAccessSite, -1);
            if (index < 0) {
                index = this.fieldAccessToIndex.size();
                this.fieldAccessToIndex.put((Object)fieldAccessSite, index);
                this.fieldAccessList.add(new SerializableCallGraph.FieldAccess());
                this.fieldAccessToProcess.add(fieldAccessSite);
            }
            return index;
        }

        private int getClassAccess(DefaultClassAccessSite classAccessSite) {
            int index = this.classAccessToIndex.getOrDefault((Object)classAccessSite, -1);
            if (index < 0) {
                index = this.classAccessToIndex.size();
                this.classAccessToIndex.put((Object)classAccessSite, index);
                this.classAccessList.add(new SerializableCallGraph.ClassAccess());
                this.classAccessToProcess.add(classAccessSite);
            }
            return index;
        }
    }
}

