/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.patches;

import org.teavm.diagnostics.Diagnostics;
import org.teavm.model.BasicBlock;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderTransformer;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.FieldReference;
import org.teavm.model.Instruction;
import org.teavm.model.MethodHolder;
import org.teavm.model.Program;
import org.teavm.model.instructions.AssignInstruction;
import org.teavm.model.instructions.EmptyInstruction;
import org.teavm.model.instructions.GetFieldInstruction;
import org.teavm.model.instructions.PutFieldInstruction;

public class ClassPatch
implements ClassHolderTransformer {
    private FieldReference platformClassField = new FieldReference("java.lang.Class", "platformClass");

    @Override
    public void transformClass(ClassHolder cls, ClassReaderSource innerSource, Diagnostics diagnostics) {
        if (!cls.getName().equals("java.lang.Class")) {
            return;
        }
        for (MethodHolder method : cls.getMethods()) {
            this.patchProgram(method.getProgram());
        }
    }

    private void patchProgram(Program program) {
        for (int i = 0; i < program.basicBlockCount(); ++i) {
            BasicBlock block = program.basicBlockAt(i);
            for (Instruction instruction : block) {
                PutFieldInstruction putField;
                Instruction replacement;
                if (instruction instanceof GetFieldInstruction) {
                    GetFieldInstruction getField = (GetFieldInstruction)instruction;
                    if (!getField.getField().equals(this.platformClassField)) continue;
                    replacement = new AssignInstruction();
                    ((AssignInstruction)replacement).setReceiver(getField.getReceiver());
                    ((AssignInstruction)replacement).setAssignee(getField.getInstance());
                    replacement.setLocation(instruction.getLocation());
                    instruction.replace(replacement);
                    continue;
                }
                if (!(instruction instanceof PutFieldInstruction) || !(putField = (PutFieldInstruction)instruction).getField().equals(this.platformClassField)) continue;
                replacement = new EmptyInstruction();
                replacement.setLocation(instruction.getLocation());
                instruction.replace(replacement);
            }
        }
    }
}

