/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.intrinsics;

import org.teavm.ast.InvocationExpr;
import org.teavm.backend.wasm.intrinsics.WasmIntrinsic;
import org.teavm.backend.wasm.intrinsics.WasmIntrinsicManager;
import org.teavm.backend.wasm.model.expression.WasmBlock;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.model.MethodReference;

public class PlatformClassIntrinsic
implements WasmIntrinsic {
    private static final String PLATFORM_CLASS_NAME = "org.teavm.platform.PlatformClass";

    @Override
    public boolean isApplicable(MethodReference methodReference) {
        return methodReference.getClassName().equals(PLATFORM_CLASS_NAME);
    }

    @Override
    public WasmExpression apply(InvocationExpr invocation, WasmIntrinsicManager manager) {
        switch (invocation.getMethod().getName()) {
            case "getMetadata": 
            case "getJavaClass": {
                return manager.generate(invocation.getArguments().get(0));
            }
            case "setJavaClass": {
                return new WasmBlock(false);
            }
        }
        throw new IllegalArgumentException(invocation.getMethod().toString());
    }
}

