/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.generate;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.teavm.backend.wasm.generate.WasmStringPool;
import org.teavm.backend.wasm.intrinsics.WasmIntrinsic;
import org.teavm.backend.wasm.model.WasmFunction;
import org.teavm.backend.wasm.model.WasmModule;
import org.teavm.diagnostics.Diagnostics;
import org.teavm.interop.Import;
import org.teavm.model.AnnotationReader;
import org.teavm.model.AnnotationValue;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.FieldReader;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;
import org.teavm.model.classes.TagRegistry;
import org.teavm.model.classes.VirtualTableProvider;

public class WasmGenerationContext {
    private ClassReaderSource classSource;
    private WasmModule module;
    private Diagnostics diagnostics;
    private VirtualTableProvider vtableProvider;
    private TagRegistry tagRegistry;
    private WasmStringPool stringPool;
    private Map<MethodReference, ImportedMethod> importedMethods = new HashMap<MethodReference, ImportedMethod>();
    private List<WasmIntrinsic> intrinsics = new ArrayList<WasmIntrinsic>();
    private Map<MethodReference, WasmIntrinsicHolder> intrinsicCache = new HashMap<MethodReference, WasmIntrinsicHolder>();

    public WasmGenerationContext(ClassReaderSource classSource, WasmModule module, Diagnostics diagnostics, VirtualTableProvider vtableProvider, TagRegistry tagRegistry, WasmStringPool stringPool) {
        this.classSource = classSource;
        this.module = module;
        this.diagnostics = diagnostics;
        this.vtableProvider = vtableProvider;
        this.tagRegistry = tagRegistry;
        this.stringPool = stringPool;
    }

    public void addIntrinsic(WasmIntrinsic intrinsic) {
        this.intrinsics.add(intrinsic);
    }

    public WasmIntrinsic getIntrinsic(MethodReference method) {
        return this.intrinsicCache.computeIfAbsent((MethodReference)method, (Function<MethodReference, WasmIntrinsicHolder>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getIntrinsic$1(org.teavm.model.MethodReference ), (Lorg/teavm/model/MethodReference;)Lorg/teavm/backend/wasm/generate/WasmGenerationContext$WasmIntrinsicHolder;)((WasmGenerationContext)this)).value;
    }

    public ImportedMethod getImportedMethod(MethodReference reference) {
        return this.importedMethods.computeIfAbsent(reference, ref -> {
            String module;
            ClassReader cls = this.classSource.get(ref.getClassName());
            if (cls == null) {
                return null;
            }
            MethodReader method = cls.getMethod(ref.getDescriptor());
            if (method == null) {
                return null;
            }
            AnnotationReader annotation = method.getAnnotations().get(Import.class.getName());
            if (annotation == null) {
                return null;
            }
            String name = annotation.getValue("name").getString();
            AnnotationValue moduleValue = annotation.getValue("module");
            String string = module = moduleValue != null ? moduleValue.getString() : null;
            if (module != null && module.isEmpty()) {
                module = null;
            }
            return new ImportedMethod(name, module);
        });
    }

    public WasmFunction getFunction(String name) {
        return this.module.getFunctions().get(name);
    }

    public ClassReaderSource getClassSource() {
        return this.classSource;
    }

    public ValueType getFieldType(FieldReference fieldReference) {
        ClassReader cls = this.classSource.get(fieldReference.getClassName());
        FieldReader field = cls.getField(fieldReference.getFieldName());
        return field.getType();
    }

    public VirtualTableProvider getVirtualTableProvider() {
        return this.vtableProvider;
    }

    public TagRegistry getTagRegistry() {
        return this.tagRegistry;
    }

    public WasmStringPool getStringPool() {
        return this.stringPool;
    }

    public Diagnostics getDiagnostics() {
        return this.diagnostics;
    }

    private /* synthetic */ WasmIntrinsicHolder lambda$getIntrinsic$1(MethodReference key) {
        return new WasmIntrinsicHolder(this.intrinsics.stream().filter(intrinsic -> intrinsic.isApplicable(key)).findFirst().orElse(null));
    }

    public class ImportedMethod {
        public final String name;
        public final String module;

        ImportedMethod(String name, String module) {
            this.name = name;
            this.module = module;
        }
    }

    private static class WasmIntrinsicHolder {
        WasmIntrinsic value;

        public WasmIntrinsicHolder(WasmIntrinsic value) {
            this.value = value;
        }
    }
}

