/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.javascript.rendering;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class RenderingUtil {
    public static final Set<String> KEYWORDS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("break", "case", "catch", "class", "const", "continue", "debugger", "default", "delete", "do", "else", "export", "extends", "finally", "for", "function", "if", "import", "in", "instanceof", "new", "return", "super", "switch", "this", "throw", "try", "typeof", "var", "void", "while", "with", "yield")));
    public static final String VARIABLE_START_CHARS = "abcdefghijklmnopqrstuvwxyz";
    public static final String VARIABLE_PART_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";

    private RenderingUtil() {
    }

    public static String escapeName(String name) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            sb.append(Character.isJavaIdentifierPart(c) ? c : (char)'_');
        }
        return sb.toString();
    }

    public static String escapeString(String str) {
        StringBuilder sb = new StringBuilder();
        block8: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\r': {
                    sb.append("\\r");
                    continue block8;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block8;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block8;
                }
                case '\'': {
                    sb.append("\\'");
                    continue block8;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block8;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block8;
                }
                default: {
                    if (c < ' ') {
                        sb.append("\\u00").append(Character.forDigit(c / 16, 16)).append(Character.forDigit(c % 16, 16));
                        continue block8;
                    }
                    if (Character.isLowSurrogate(c) || Character.isHighSurrogate(c) || !Character.isDefined(c)) {
                        sb.append("\\u").append(Character.forDigit(c / 4096, 16)).append(Character.forDigit(c / 256 % 16, 16)).append(Character.forDigit(c / 16 % 16, 16)).append(Character.forDigit(c % 16, 16));
                        continue block8;
                    }
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String indexToId(int index, String startChars) {
        StringBuilder sb = new StringBuilder();
        sb.append(startChars.charAt(index % startChars.length()));
        index /= startChars.length();
        while (index > 0) {
            sb.append(VARIABLE_PART_CHARS.charAt(index % VARIABLE_PART_CHARS.length()));
            index /= VARIABLE_PART_CHARS.length();
        }
        return sb.toString();
    }

    public static String indexToId(int index) {
        return RenderingUtil.indexToId(index, VARIABLE_START_CHARS);
    }
}

