/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.javascript.rendering;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.teavm.ast.AsyncMethodNode;
import org.teavm.ast.AsyncMethodPart;
import org.teavm.ast.ClassNode;
import org.teavm.ast.FieldNode;
import org.teavm.ast.MethodNode;
import org.teavm.ast.MethodNodeVisitor;
import org.teavm.ast.NativeMethodNode;
import org.teavm.ast.RegularMethodNode;
import org.teavm.ast.VariableNode;
import org.teavm.backend.javascript.codegen.NamingException;
import org.teavm.backend.javascript.codegen.NamingOrderer;
import org.teavm.backend.javascript.codegen.NamingStrategy;
import org.teavm.backend.javascript.codegen.SourceWriter;
import org.teavm.backend.javascript.rendering.NameFrequencyEstimator;
import org.teavm.backend.javascript.rendering.RenderingContext;
import org.teavm.backend.javascript.rendering.RenderingManager;
import org.teavm.backend.javascript.rendering.RenderingUtil;
import org.teavm.backend.javascript.rendering.StatementRenderer;
import org.teavm.backend.javascript.rendering.TryCatchFinder;
import org.teavm.backend.javascript.spi.GeneratorContext;
import org.teavm.common.ServiceRepository;
import org.teavm.debugging.information.DebugInformationEmitter;
import org.teavm.debugging.information.DummyDebugInformationEmitter;
import org.teavm.diagnostics.Diagnostics;
import org.teavm.model.ClassReader;
import org.teavm.model.ElementModifier;
import org.teavm.model.FieldReference;
import org.teavm.model.ListableClassReaderSource;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;
import org.teavm.vm.RenderingException;

public class Renderer
implements RenderingManager {
    private final NamingStrategy naming;
    private final SourceWriter writer;
    private final ListableClassReaderSource classSource;
    private final ClassLoader classLoader;
    private boolean minifying;
    private final Properties properties = new Properties();
    private final ServiceRepository services;
    private DebugInformationEmitter debugEmitter = new DummyDebugInformationEmitter();
    private final Set<MethodReference> asyncMethods;
    private final Set<MethodReference> asyncFamilyMethods;
    private final Diagnostics diagnostics;
    private RenderingContext context;
    private List<PostponedFieldInitializer> postponedFieldInitializers = new ArrayList<PostponedFieldInitializer>();

    public Renderer(SourceWriter writer, Set<MethodReference> asyncMethods, Set<MethodReference> asyncFamilyMethods, Diagnostics diagnostics, RenderingContext context) {
        this.naming = context.getNaming();
        this.writer = writer;
        this.classSource = context.getClassSource();
        this.classLoader = context.getClassLoader();
        this.services = context.getServices();
        this.asyncMethods = new HashSet<MethodReference>(asyncMethods);
        this.asyncFamilyMethods = new HashSet<MethodReference>(asyncFamilyMethods);
        this.diagnostics = diagnostics;
        this.context = context;
    }

    @Override
    public SourceWriter getWriter() {
        return this.writer;
    }

    @Override
    public NamingStrategy getNaming() {
        return this.naming;
    }

    @Override
    public boolean isMinifying() {
        return this.minifying;
    }

    public void setMinifying(boolean minifying) {
        this.minifying = minifying;
    }

    @Override
    public ListableClassReaderSource getClassSource() {
        return this.classSource;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public Properties getProperties() {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.properties);
        return properties;
    }

    public DebugInformationEmitter getDebugEmitter() {
        return this.debugEmitter;
    }

    public void setDebugEmitter(DebugInformationEmitter debugEmitter) {
        this.debugEmitter = debugEmitter;
    }

    public void setProperties(Properties properties) {
        this.properties.clear();
        this.properties.putAll((Map<?, ?>)properties);
    }

    public void renderStringPool() throws RenderingException {
        if (this.context.getStringPool().isEmpty()) {
            return;
        }
        try {
            this.writer.append("$rt_stringPool([");
            for (int i = 0; i < this.context.getStringPool().size(); ++i) {
                if (i > 0) {
                    this.writer.append(',').ws();
                }
                this.writer.append('\"').append(RenderingUtil.escapeString(this.context.getStringPool().get(i))).append('\"');
            }
            this.writer.append("]);").newLine();
        }
        catch (IOException e) {
            throw new RenderingException("IO error", e);
        }
    }

    public void renderStringConstants() throws RenderingException {
        try {
            for (PostponedFieldInitializer initializer : this.postponedFieldInitializers) {
                this.writer.appendStaticField(initializer.field).ws().append("=").ws().append(this.context.constantToString(initializer.value)).append(";").softNewLine();
            }
        }
        catch (IOException e) {
            throw new RenderingException("IO error", e);
        }
    }

    public void renderRuntime() throws RenderingException {
        try {
            this.renderRuntimeCls();
            this.renderRuntimeString();
            this.renderRuntimeUnwrapString();
            this.renderRuntimeObjcls();
            this.renderRuntimeNullCheck();
            this.renderRuntimeIntern();
            this.renderRuntimeThreads();
        }
        catch (NamingException e) {
            throw new RenderingException("Error rendering runtime methods. See a cause for details", e);
        }
        catch (IOException e) {
            throw new RenderingException("IO error", e);
        }
    }

    private void renderRuntimeCls() throws IOException {
        this.writer.append("function $rt_cls(cls)").ws().append("{").softNewLine().indent();
        this.writer.append("return ").appendMethodBody("java.lang.Class", "getClass", ValueType.object("org.teavm.platform.PlatformClass"), ValueType.object("java.lang.Class")).append("(cls);").softNewLine();
        this.writer.outdent().append("}").newLine();
    }

    private void renderRuntimeString() throws IOException {
        MethodReference stringCons = new MethodReference(String.class, "<init>", char[].class, Void.TYPE);
        this.writer.append("function $rt_str(str) {").indent().softNewLine();
        this.writer.append("if (str === null) {").indent().softNewLine();
        this.writer.append("return null;").softNewLine();
        this.writer.outdent().append("}").softNewLine();
        this.writer.append("var characters = $rt_createCharArray(str.length);").softNewLine();
        this.writer.append("var charsBuffer = characters.data;").softNewLine();
        this.writer.append("for (var i = 0; i < str.length; i = (i + 1) | 0) {").indent().softNewLine();
        this.writer.append("charsBuffer[i] = str.charCodeAt(i) & 0xFFFF;").softNewLine();
        this.writer.outdent().append("}").softNewLine();
        this.writer.append("return ").append(this.naming.getNameForInit(stringCons)).append("(characters);").softNewLine();
        this.writer.outdent().append("}").newLine();
    }

    private void renderRuntimeUnwrapString() throws IOException {
        MethodReference stringLen = new MethodReference(String.class, "length", Integer.TYPE);
        MethodReference getChars = new MethodReference(String.class, "getChars", Integer.TYPE, Integer.TYPE, char[].class, Integer.TYPE, Void.TYPE);
        this.writer.append("function $rt_ustr(str) {").indent().softNewLine();
        this.writer.append("if (str === null) {").indent().softNewLine();
        this.writer.append("return null;").softNewLine();
        this.writer.outdent().append("}").softNewLine();
        this.writer.append("var result = \"\";").softNewLine();
        this.writer.append("var sz = ").appendMethodBody(stringLen).append("(str);").softNewLine();
        this.writer.append("var array = $rt_createCharArray(sz);").softNewLine();
        this.writer.appendMethodBody(getChars).append("(str, 0, sz, array, 0);").softNewLine();
        this.writer.append("for (var i = 0; i < sz; i = (i + 1) | 0) {").indent().softNewLine();
        this.writer.append("result += String.fromCharCode(array.data[i]);").softNewLine();
        this.writer.outdent().append("}").softNewLine();
        this.writer.append("return result;").softNewLine();
        this.writer.outdent().append("}").newLine();
    }

    private void renderRuntimeNullCheck() throws IOException {
        this.writer.append("function $rt_nullCheck(val) {").indent().softNewLine();
        this.writer.append("if (val === null) {").indent().softNewLine();
        this.writer.append("$rt_throw(").append(this.naming.getNameForInit(new MethodReference(NullPointerException.class, "<init>", Void.TYPE))).append("());").softNewLine();
        this.writer.outdent().append("}").softNewLine();
        this.writer.append("return val;").softNewLine();
        this.writer.outdent().append("}").newLine();
    }

    private void renderRuntimeIntern() throws IOException {
        this.writer.append("function $rt_intern(str) {").indent().softNewLine();
        this.writer.append("return ").appendMethodBody(new MethodReference(String.class, "intern", String.class)).append("(str);").softNewLine();
        this.writer.outdent().append("}").newLine();
    }

    private void renderRuntimeObjcls() throws IOException {
        this.writer.append("function $rt_objcls() { return ").appendClass("java.lang.Object").append("; }").newLine();
    }

    private void renderRuntimeThreads() throws IOException {
        this.writer.append("function $rt_getThread()").ws().append("{").indent().softNewLine();
        this.writer.append("return ").appendMethodBody(Thread.class, "currentThread", Thread.class).append("();").softNewLine();
        this.writer.outdent().append("}").newLine();
        this.writer.append("function $rt_setThread(t)").ws().append("{").indent().softNewLine();
        this.writer.append("return ").appendMethodBody(Thread.class, "setCurrentThread", Thread.class, Void.TYPE).append("(t);").softNewLine();
        this.writer.outdent().append("}").newLine();
    }

    private void renderRuntimeAliases() throws IOException {
        String[] names = new String[]{"$rt_throw", "$rt_compare", "$rt_nullCheck", "$rt_cls", "$rt_createArray", "$rt_isInstance", "$rt_nativeThread", "$rt_suspending", "$rt_resuming", "$rt_invalidPointer", "$rt_s"};
        boolean first = true;
        for (String name : names) {
            if (!first) {
                this.writer.softNewLine();
            }
            first = false;
            this.writer.append("var ").appendFunction(name).ws().append('=').ws().append(name).append(";").softNewLine();
        }
        this.writer.newLine();
    }

    public void render(List<ClassNode> classes) throws RenderingException {
        if (this.minifying) {
            NamingOrderer orderer = new NamingOrderer();
            NameFrequencyEstimator estimator = new NameFrequencyEstimator(orderer, this.classSource, this.asyncMethods, this.asyncFamilyMethods);
            for (ClassNode cls : classes) {
                estimator.estimate(cls);
            }
            orderer.apply(this.naming);
        }
        if (this.minifying) {
            try {
                this.renderRuntimeAliases();
            }
            catch (IOException e) {
                throw new RenderingException(e);
            }
        }
        for (ClassNode cls : classes) {
            this.renderDeclaration(cls);
            this.renderMethodBodies(cls);
        }
        this.renderClassMetadata(classes);
    }

    private void renderDeclaration(ClassNode cls) throws RenderingException {
        this.debugEmitter.addClass(cls.getName(), cls.getParentName());
        try {
            FieldReference fieldRef;
            Object value;
            this.writer.append("function ").appendClass(cls.getName()).append("()").ws().append("{").indent().softNewLine();
            boolean thisAliased = false;
            ArrayList<FieldNode> nonStaticFields = new ArrayList<FieldNode>();
            ArrayList<FieldNode> staticFields = new ArrayList<FieldNode>();
            for (FieldNode field : cls.getFields()) {
                if (field.getModifiers().contains((Object)ElementModifier.STATIC)) {
                    staticFields.add(field);
                    continue;
                }
                nonStaticFields.add(field);
            }
            if (nonStaticFields.size() > 1) {
                thisAliased = true;
                this.writer.append("var a").ws().append("=").ws().append("this;").ws();
            }
            if (cls.getParentName() != null) {
                this.writer.appendClass(cls.getParentName()).append(".call(").append(thisAliased ? "a" : "this").append(");").softNewLine();
            }
            for (FieldNode field : nonStaticFields) {
                value = field.getInitialValue();
                if (value == null) {
                    value = Renderer.getDefaultValue(field.getType());
                }
                fieldRef = new FieldReference(cls.getName(), field.getName());
                this.writer.append(thisAliased ? "a" : "this").append(".").appendField(fieldRef).ws().append("=").ws().append(this.context.constantToString(value)).append(";").softNewLine();
                this.debugEmitter.addField(field.getName(), this.naming.getNameFor(fieldRef));
            }
            if (cls.getName().equals("java.lang.Object")) {
                this.writer.append("this.$id$").ws().append('=').ws().append("0;").softNewLine();
            }
            this.writer.outdent().append("}").newLine();
            for (FieldNode field : staticFields) {
                value = field.getInitialValue();
                if (value == null) {
                    value = Renderer.getDefaultValue(field.getType());
                }
                fieldRef = new FieldReference(cls.getName(), field.getName());
                if (value instanceof String) {
                    this.context.constantToString(value);
                    this.postponedFieldInitializers.add(new PostponedFieldInitializer(fieldRef, (String)value));
                    value = null;
                }
                this.writer.append("var ").appendStaticField(fieldRef).ws().append("=").ws().append(this.context.constantToString(value)).append(";").softNewLine();
            }
        }
        catch (NamingException e) {
            throw new RenderingException("Error rendering class " + cls.getName() + ". See cause for details", e);
        }
        catch (IOException e) {
            throw new RenderingException("IO error occurred", e);
        }
    }

    private void renderMethodBodies(ClassNode cls) throws RenderingException {
        this.debugEmitter.emitClass(cls.getName());
        try {
            MethodReader clinit = this.classSource.get(cls.getName()).getMethod(new MethodDescriptor("<clinit>", ValueType.VOID));
            if (clinit != null) {
                this.renderCallClinit(clinit, cls);
            }
            if (!cls.getModifiers().contains((Object)ElementModifier.INTERFACE)) {
                for (MethodNode method : cls.getMethods()) {
                    if (method.getModifiers().contains((Object)ElementModifier.STATIC) || !method.getReference().getName().equals("<init>")) continue;
                    this.renderInitializer(method);
                }
            }
            for (MethodNode method : cls.getMethods()) {
                this.renderBody(method);
            }
        }
        catch (NamingException e) {
            throw new RenderingException("Error rendering class " + cls.getName() + ". See a cause for details", e);
        }
        catch (IOException e) {
            throw new RenderingException("IO error occurred", e);
        }
        this.debugEmitter.emitClass(null);
    }

    private void renderCallClinit(MethodReader clinit, ClassNode cls) throws IOException {
        boolean isAsync = this.asyncMethods.contains(clinit.getReference());
        if (isAsync) {
            this.writer.append("var ").appendClass(cls.getName()).append("_$clinitCalled").ws().append("=").ws().append("false;").softNewLine();
        }
        this.writer.append("function ").appendClass(cls.getName()).append("_$callClinit()").ws().append("{").softNewLine().indent();
        if (isAsync) {
            this.writer.append("var ").append(this.context.pointerName()).ws().append("=").ws().append("0").append(";").softNewLine();
            this.writer.append("if").ws().append("(").appendFunction("$rt_resuming").append("())").ws().append("{").indent().softNewLine();
            this.writer.append(this.context.pointerName()).ws().append("=").ws().appendFunction("$rt_nativeThread").append("().pop();").softNewLine();
            this.writer.outdent().append("}").ws();
            this.writer.append("else if").ws().append("(").appendClass(cls.getName()).append("_$clinitCalled)").ws().append("{").indent().softNewLine();
            this.writer.append("return;").softNewLine();
            this.writer.outdent().append("}").softNewLine();
            this.renderAsyncPrologue();
            this.writer.append("case 0:").indent().softNewLine();
            this.writer.appendClass(cls.getName()).append("_$clinitCalled").ws().append('=').ws().append("true;").softNewLine();
        } else {
            this.renderEraseClinit(cls);
        }
        if (isAsync) {
            this.writer.append(this.context.pointerName()).ws().append("=").ws().append("1;").softNewLine();
            this.writer.outdent().append("case 1:").indent().softNewLine();
        }
        this.writer.appendMethodBody(new MethodReference(cls.getName(), clinit.getDescriptor())).append("();").softNewLine();
        if (isAsync) {
            this.writer.append("if").ws().append("(").appendFunction("$rt_suspending").append("())").ws().append("{").indent().softNewLine();
            this.writer.append("break " + this.context.mainLoopName() + ";").softNewLine();
            this.writer.outdent().append("}").softNewLine();
            this.renderEraseClinit(cls);
            this.writer.append("return;").softNewLine().outdent();
            this.renderAsyncEpilogue();
            this.writer.appendFunction("$rt_nativeThread").append("().push(" + this.context.pointerName() + ");").softNewLine();
        }
        this.writer.outdent().append("}").newLine();
    }

    private void renderEraseClinit(ClassNode cls) throws IOException {
        this.writer.appendClass(cls.getName()).append("_$callClinit").ws().append("=").ws().append("function(){};").newLine();
    }

    private void renderClassMetadata(List<ClassNode> classes) {
        try {
            this.writer.append("$rt_metadata([");
            boolean first = true;
            for (ClassNode cls : classes) {
                if (!first) {
                    this.writer.append(',').softNewLine();
                }
                first = false;
                this.writer.appendClass(cls.getName()).append(",").ws();
                this.writer.append("\"").append(RenderingUtil.escapeString(cls.getName())).append("\",").ws();
                if (cls.getParentName() != null) {
                    this.writer.appendClass(cls.getParentName());
                } else {
                    this.writer.append("0");
                }
                this.writer.append(',').ws();
                this.writer.append("[");
                for (int i = 0; i < cls.getInterfaces().size(); ++i) {
                    String iface = cls.getInterfaces().get(i);
                    if (i > 0) {
                        this.writer.append(",").ws();
                    }
                    this.writer.appendClass(iface);
                }
                this.writer.append("],").ws();
                int flags = 0;
                if (cls.getModifiers().contains((Object)ElementModifier.ENUM)) {
                    flags |= 1;
                }
                this.writer.append(flags).append(',').ws();
                MethodReader clinit = this.classSource.get(cls.getName()).getMethod(new MethodDescriptor("<clinit>", ValueType.VOID));
                if (clinit != null) {
                    this.writer.appendClass(cls.getName()).append("_$callClinit");
                } else {
                    this.writer.append('0');
                }
                this.writer.append(',').ws();
                ArrayList<MethodReference> virtualMethods = new ArrayList<MethodReference>();
                for (MethodNode method : cls.getMethods()) {
                    if (method.getModifiers().contains((Object)ElementModifier.STATIC)) continue;
                    virtualMethods.add(method.getReference());
                }
                this.collectMethodsToCopyFromInterfaces(this.classSource.get(cls.getName()), virtualMethods);
                this.renderVirtualDeclarations(virtualMethods);
            }
            this.writer.append("]);").newLine();
        }
        catch (NamingException e) {
            throw new RenderingException("Error rendering class metadata. See a cause for details", e);
        }
        catch (IOException e) {
            throw new RenderingException("IO error occurred", e);
        }
    }

    private void collectMethodsToCopyFromInterfaces(ClassReader cls, List<MethodReference> targetList) {
        HashSet<MethodDescriptor> implementedMethods = new HashSet<MethodDescriptor>();
        implementedMethods.addAll(targetList.stream().map(method -> method.getDescriptor()).collect(Collectors.toList()));
        HashSet<String> visitedClasses = new HashSet<String>();
        for (String ifaceName : cls.getInterfaces()) {
            ClassReader iface = this.classSource.get(ifaceName);
            if (iface == null) continue;
            this.collectMethodsToCopyFromInterfacesImpl(iface, targetList, implementedMethods, visitedClasses);
        }
    }

    private void collectMethodsToCopyFromInterfacesImpl(ClassReader cls, List<MethodReference> targetList, Set<MethodDescriptor> visited, Set<String> visitedClasses) {
        if (!visitedClasses.add(cls.getName())) {
            return;
        }
        for (MethodReader methodReader : cls.getMethods()) {
            if (methodReader.hasModifier(ElementModifier.STATIC) || methodReader.hasModifier(ElementModifier.ABSTRACT) || !visited.add(methodReader.getDescriptor())) continue;
            targetList.add(methodReader.getReference());
        }
        for (String string : cls.getInterfaces()) {
            ClassReader iface = this.classSource.get(string);
            if (iface == null) continue;
            this.collectMethodsToCopyFromInterfacesImpl(iface, targetList, visited, visitedClasses);
        }
    }

    private static Object getDefaultValue(ValueType type) {
        if (type instanceof ValueType.Primitive) {
            ValueType.Primitive primitive = (ValueType.Primitive)type;
            switch (primitive.getKind()) {
                case BOOLEAN: {
                    return false;
                }
                case BYTE: {
                    return (byte)0;
                }
                case SHORT: {
                    return (short)0;
                }
                case INTEGER: {
                    return 0;
                }
                case CHARACTER: {
                    return Character.valueOf('\u0000');
                }
                case LONG: {
                    return 0L;
                }
                case FLOAT: {
                    return Float.valueOf(0.0f);
                }
                case DOUBLE: {
                    return 0.0;
                }
            }
        }
        return null;
    }

    private void renderInitializer(MethodNode method) throws IOException {
        int i;
        MethodReference ref = method.getReference();
        this.debugEmitter.emitMethod(ref.getDescriptor());
        this.writer.append("function ").append(this.naming.getNameForInit(ref)).append("(");
        for (i = 1; i <= ref.parameterCount(); ++i) {
            if (i > 1) {
                this.writer.append(",").ws();
            }
            this.writer.append(this.variableNameForInitializer(i));
        }
        this.writer.append(")").ws().append("{").softNewLine().indent();
        this.writer.append("var $r").ws().append("=").ws().append("new ").appendClass(ref.getClassName()).append("();").softNewLine();
        this.writer.append(this.naming.getFullNameFor(ref)).append("($r");
        for (i = 1; i <= ref.parameterCount(); ++i) {
            this.writer.append(",").ws();
            this.writer.append(this.variableNameForInitializer(i));
        }
        this.writer.append(");").softNewLine();
        this.writer.append("return $r;").softNewLine();
        this.writer.outdent().append("}").newLine();
        this.debugEmitter.emitMethod(null);
    }

    private String variableNameForInitializer(int index) {
        return this.minifying ? RenderingUtil.indexToId(index) : "var_" + index;
    }

    private void renderVirtualDeclarations(Iterable<MethodReference> methods) throws NamingException, IOException {
        this.writer.append("[");
        boolean first = true;
        for (MethodReference method : methods) {
            this.debugEmitter.emitMethod(method.getDescriptor());
            if (!first) {
                this.writer.append(",").ws();
            }
            first = false;
            this.emitVirtualDeclaration(method);
            this.debugEmitter.emitMethod(null);
        }
        this.writer.append("]");
    }

    private void emitVirtualDeclaration(MethodReference ref) throws IOException {
        int i;
        String methodName = this.naming.getNameFor(ref.getDescriptor());
        this.writer.append("\"").append(methodName).append("\"");
        this.writer.append(",").ws().append("function(");
        ArrayList<String> args = new ArrayList<String>();
        for (i = 1; i <= ref.parameterCount(); ++i) {
            args.add(this.variableNameForInitializer(i));
        }
        for (i = 0; i < args.size(); ++i) {
            if (i > 0) {
                this.writer.append(",").ws();
            }
            this.writer.append((String)args.get(i));
        }
        this.writer.append(")").ws().append("{").ws();
        if (ref.getDescriptor().getResultType() != ValueType.VOID) {
            this.writer.append("return ");
        }
        this.writer.appendMethodBody(ref).append("(");
        this.writer.append("this");
        for (String arg : args) {
            this.writer.append(",").ws().append(arg);
        }
        this.writer.append(");").ws().append("}");
    }

    private void renderBody(MethodNode method) throws IOException {
        StatementRenderer statementRenderer = new StatementRenderer(this.context, this.writer);
        statementRenderer.setCurrentMethod(method);
        MethodReference ref = method.getReference();
        this.debugEmitter.emitMethod(ref.getDescriptor());
        String name = this.naming.getFullNameFor(ref);
        this.writer.append("function ").append(name).append("(");
        int startParam = 0;
        if (method.getModifiers().contains((Object)ElementModifier.STATIC)) {
            startParam = 1;
        }
        for (int i = startParam; i <= ref.parameterCount(); ++i) {
            if (i > startParam) {
                this.writer.append(",").ws();
            }
            this.writer.append(statementRenderer.variableName(i));
        }
        this.writer.append(")").ws().append("{").softNewLine().indent();
        method.acceptVisitor(new MethodBodyRenderer(statementRenderer));
        this.writer.outdent().append("}");
        this.writer.newLine();
        this.debugEmitter.emitMethod(null);
    }

    private void renderAsyncPrologue() throws IOException {
        this.writer.append(this.context.mainLoopName()).append(":").ws().append("while").ws().append("(true)").ws().append("{").ws();
        this.writer.append("switch").ws().append("(").append(this.context.pointerName()).append(")").ws().append('{').softNewLine();
    }

    private void renderAsyncEpilogue() throws IOException {
        this.writer.append("default:").ws().appendFunction("$rt_invalidPointer").append("();").softNewLine();
        this.writer.append("}}").softNewLine();
    }

    private void appendMonitor(StatementRenderer statementRenderer, MethodNode methodNode) throws IOException {
        if (methodNode.getModifiers().contains((Object)ElementModifier.STATIC)) {
            this.writer.appendFunction("$rt_cls").append("(").appendClass(methodNode.getReference().getClassName()).append(")");
        } else {
            this.writer.append(statementRenderer.variableName(0));
        }
    }

    @Override
    public <T> T getService(Class<T> type) {
        return this.services.getService(type);
    }

    private static class PostponedFieldInitializer {
        FieldReference field;
        String value;

        public PostponedFieldInitializer(FieldReference field, String value) {
            this.field = field;
            this.value = value;
        }
    }

    private class MethodBodyRenderer
    implements MethodNodeVisitor,
    GeneratorContext {
        private boolean async;
        private StatementRenderer statementRenderer;

        MethodBodyRenderer(StatementRenderer statementRenderer) {
            this.statementRenderer = statementRenderer;
        }

        @Override
        public void visit(NativeMethodNode methodNode) {
            try {
                this.async = methodNode.isAsync();
                this.statementRenderer.setAsync(methodNode.isAsync());
                methodNode.getGenerator().generate(this, Renderer.this.writer, methodNode.getReference());
            }
            catch (IOException e) {
                throw new RenderingException("IO error occurred", e);
            }
        }

        @Override
        public void visit(RegularMethodNode method) {
            try {
                int i;
                this.statementRenderer.setAsync(false);
                this.async = false;
                MethodReference ref = method.getReference();
                for (int i2 = 0; i2 < method.getVariables().size(); ++i2) {
                    Renderer.this.debugEmitter.emitVariable(new String[]{method.getVariables().get(i2).getName()}, this.statementRenderer.variableName(i2));
                }
                int variableCount = 0;
                for (VariableNode var : method.getVariables()) {
                    variableCount = Math.max(variableCount, var.getIndex() + 1);
                }
                TryCatchFinder tryCatchFinder = new TryCatchFinder();
                method.getBody().acceptVisitor(tryCatchFinder);
                boolean hasTryCatch = tryCatchFinder.tryCatchFound;
                ArrayList<String> variableNames = new ArrayList<String>();
                for (i = ref.parameterCount() + 1; i < variableCount; ++i) {
                    variableNames.add(this.statementRenderer.variableName(i));
                }
                if (hasTryCatch) {
                    variableNames.add("$$je");
                }
                if (!variableNames.isEmpty()) {
                    Renderer.this.writer.append("var ");
                    for (i = 0; i < variableNames.size(); ++i) {
                        if (i > 0) {
                            Renderer.this.writer.append(",").ws();
                        }
                        Renderer.this.writer.append((String)variableNames.get(i));
                    }
                    Renderer.this.writer.append(";").softNewLine();
                }
                this.statementRenderer.setEnd(true);
                this.statementRenderer.setCurrentPart(0);
                method.getBody().acceptVisitor(this.statementRenderer);
            }
            catch (IOException e) {
                throw new RenderingException("IO error occurred", e);
            }
        }

        @Override
        public void visit(AsyncMethodNode methodNode) {
            try {
                int i;
                this.statementRenderer.setAsync(true);
                this.async = true;
                MethodReference ref = methodNode.getReference();
                for (int i2 = 0; i2 < methodNode.getVariables().size(); ++i2) {
                    Renderer.this.debugEmitter.emitVariable(new String[]{methodNode.getVariables().get(i2).getName()}, this.statementRenderer.variableName(i2));
                }
                int variableCount = 0;
                for (VariableNode var : methodNode.getVariables()) {
                    variableCount = Math.max(variableCount, var.getIndex() + 1);
                }
                ArrayList<String> variableNames = new ArrayList<String>();
                for (int i3 = ref.parameterCount() + 1; i3 < variableCount; ++i3) {
                    variableNames.add(this.statementRenderer.variableName(i3));
                }
                TryCatchFinder tryCatchFinder = new TryCatchFinder();
                for (AsyncMethodPart part : methodNode.getBody()) {
                    if (tryCatchFinder.tryCatchFound) continue;
                    part.getStatement().acceptVisitor(tryCatchFinder);
                }
                boolean hasTryCatch = tryCatchFinder.tryCatchFound;
                if (hasTryCatch) {
                    variableNames.add("$$je");
                }
                variableNames.add(Renderer.this.context.pointerName());
                variableNames.add(Renderer.this.context.tempVarName());
                if (!variableNames.isEmpty()) {
                    Renderer.this.writer.append("var ");
                    for (int i4 = 0; i4 < variableNames.size(); ++i4) {
                        if (i4 > 0) {
                            Renderer.this.writer.append(",").ws();
                        }
                        Renderer.this.writer.append((String)variableNames.get(i4));
                    }
                    Renderer.this.writer.append(";").softNewLine();
                }
                int firstToSave = 0;
                if (methodNode.getModifiers().contains((Object)ElementModifier.STATIC)) {
                    firstToSave = 1;
                }
                String popName = Renderer.this.minifying ? "l" : "pop";
                String pushName = Renderer.this.minifying ? "s" : "push";
                Renderer.this.writer.append(Renderer.this.context.pointerName()).ws().append('=').ws().append("0;").softNewLine();
                Renderer.this.writer.append("if").ws().append("(").appendFunction("$rt_resuming").append("())").ws().append("{").indent().softNewLine();
                Renderer.this.writer.append("var ").append(Renderer.this.context.threadName()).ws().append('=').ws().appendFunction("$rt_nativeThread").append("();").softNewLine();
                Renderer.this.writer.append(Renderer.this.context.pointerName()).ws().append('=').ws().append(Renderer.this.context.threadName()).append(".").append(popName).append("();");
                for (i = variableCount - 1; i >= firstToSave; --i) {
                    Renderer.this.writer.append(this.statementRenderer.variableName(i)).ws().append('=').ws().append(Renderer.this.context.threadName()).append(".").append(popName).append("();");
                }
                Renderer.this.writer.softNewLine();
                Renderer.this.writer.outdent().append("}").softNewLine();
                if (methodNode.getModifiers().contains((Object)ElementModifier.SYNCHRONIZED)) {
                    Renderer.this.writer.append("try").ws().append('{').indent().softNewLine();
                }
                Renderer.this.renderAsyncPrologue();
                for (i = 0; i < methodNode.getBody().size(); ++i) {
                    Renderer.this.writer.append("case ").append(i).append(":").indent().softNewLine();
                    if (i == 0 && methodNode.getModifiers().contains((Object)ElementModifier.SYNCHRONIZED)) {
                        Renderer.this.writer.appendMethodBody(new MethodReference(Object.class, "monitorEnter", Object.class, Void.TYPE));
                        Renderer.this.writer.append("(");
                        Renderer.this.appendMonitor(this.statementRenderer, methodNode);
                        Renderer.this.writer.append(");").softNewLine();
                        this.statementRenderer.emitSuspendChecker();
                    }
                    AsyncMethodPart part = methodNode.getBody().get(i);
                    this.statementRenderer.setEnd(true);
                    this.statementRenderer.setCurrentPart(i);
                    part.getStatement().acceptVisitor(this.statementRenderer);
                    Renderer.this.writer.outdent();
                }
                Renderer.this.renderAsyncEpilogue();
                if (methodNode.getModifiers().contains((Object)ElementModifier.SYNCHRONIZED)) {
                    Renderer.this.writer.outdent().append("}").ws().append("finally").ws().append('{').indent().softNewLine();
                    Renderer.this.writer.append("if").ws().append("(!").appendFunction("$rt_suspending").append("())").ws().append("{").indent().softNewLine();
                    Renderer.this.writer.appendMethodBody(new MethodReference(Object.class, "monitorExit", Object.class, Void.TYPE));
                    Renderer.this.writer.append("(");
                    Renderer.this.appendMonitor(this.statementRenderer, methodNode);
                    Renderer.this.writer.append(");").softNewLine();
                    Renderer.this.writer.outdent().append('}').softNewLine();
                    Renderer.this.writer.outdent().append('}').softNewLine();
                }
                Renderer.this.writer.appendFunction("$rt_nativeThread").append("().").append(pushName).append("(");
                for (i = firstToSave; i < variableCount; ++i) {
                    Renderer.this.writer.append(this.statementRenderer.variableName(i)).append(',').ws();
                }
                Renderer.this.writer.append(Renderer.this.context.pointerName()).append(");");
                Renderer.this.writer.softNewLine();
            }
            catch (IOException e) {
                throw new RenderingException("IO error occurred", e);
            }
        }

        @Override
        public String getParameterName(int index) {
            return this.statementRenderer.variableName(index);
        }

        @Override
        public ListableClassReaderSource getClassSource() {
            return Renderer.this.classSource;
        }

        @Override
        public ClassLoader getClassLoader() {
            return Renderer.this.classLoader;
        }

        @Override
        public Properties getProperties() {
            return new Properties(Renderer.this.properties);
        }

        @Override
        public <T> T getService(Class<T> type) {
            return Renderer.this.services.getService(type);
        }

        @Override
        public boolean isAsync() {
            return this.async;
        }

        @Override
        public boolean isAsync(MethodReference method) {
            return Renderer.this.asyncMethods.contains(method);
        }

        @Override
        public boolean isAsyncFamily(MethodReference method) {
            return Renderer.this.asyncFamilyMethods.contains(method);
        }

        @Override
        public Diagnostics getDiagnostics() {
            return Renderer.this.diagnostics;
        }

        @Override
        public String typeToClassString(ValueType type) {
            return Renderer.this.context.typeToClsString(type);
        }
    }
}

