/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.javascript.codegen;

import java.util.HashSet;
import java.util.Set;
import org.teavm.backend.javascript.codegen.AliasProvider;
import org.teavm.backend.javascript.rendering.RenderingUtil;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReference;

public class MinifyingAliasProvider
implements AliasProvider {
    private static final String startLetters = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String startVirtualLetters = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private int lastSuffix;
    private int lastVirtual;
    private final Set<String> usedAliases = new HashSet<String>();

    @Override
    public String getFieldAlias(FieldReference field) {
        String result;
        while (!this.usedAliases.add(result = RenderingUtil.indexToId(this.lastVirtual++, startVirtualLetters)) || RenderingUtil.KEYWORDS.contains(result)) {
        }
        return result;
    }

    @Override
    public String getStaticFieldAlias(FieldReference field) {
        String result;
        while (!this.usedAliases.add(result = RenderingUtil.indexToId(this.lastSuffix++, startLetters)) || RenderingUtil.KEYWORDS.contains(result)) {
        }
        return result;
    }

    @Override
    public String getStaticMethodAlias(MethodReference method) {
        return RenderingUtil.indexToId(this.lastSuffix++, startLetters);
    }

    @Override
    public String getMethodAlias(MethodDescriptor method) {
        String result;
        while (!this.usedAliases.add(result = RenderingUtil.indexToId(this.lastVirtual++, startVirtualLetters)) || RenderingUtil.KEYWORDS.contains(result)) {
        }
        return result;
    }

    @Override
    public String getClassAlias(String className) {
        return RenderingUtil.indexToId(this.lastSuffix++, startLetters);
    }

    @Override
    public String getFunctionAlias(String className) {
        return RenderingUtil.indexToId(this.lastSuffix++, startLetters);
    }
}

