/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.javascript.codegen;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.teavm.backend.javascript.codegen.AliasProvider;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReference;

public class DefaultAliasProvider
implements AliasProvider {
    private final Map<String, String> classAliases = new HashMap<String, String>();
    private final Set<String> knownAliases = new HashSet<String>();
    private final Set<String> knownVirtualAliases = new HashSet<String>();

    @Override
    public String getClassAlias(String cls) {
        return this.classAliases.computeIfAbsent(cls, key -> {
            StringBuilder alias = new StringBuilder();
            int lastIndex = 0;
            while (true) {
                int index;
                if ((index = cls.indexOf(46, lastIndex)) == -1) {
                    if (lastIndex > 0) {
                        alias.append("_");
                    }
                    break;
                }
                if (index > lastIndex) {
                    alias.append(cls.charAt(lastIndex));
                }
                lastIndex = index + 1;
            }
            alias.append(cls.substring(lastIndex));
            return this.makeUnique(this.knownAliases, alias.toString());
        });
    }

    @Override
    public String getMethodAlias(MethodDescriptor method) {
        String alias;
        switch (alias = method.getName()) {
            case "<init>": {
                alias = "$_init_";
                break;
            }
            case "<clinit>": {
                alias = "$_clinit_";
                break;
            }
            default: {
                alias = "$" + alias;
            }
        }
        return this.makeUnique(this.knownVirtualAliases, alias);
    }

    @Override
    public String getStaticMethodAlias(MethodReference method) {
        String alias;
        switch (alias = method.getDescriptor().getName()) {
            case "<init>": {
                alias = "_init_";
                break;
            }
            case "<clinit>": {
                alias = "_clinit_";
            }
        }
        return this.makeUnique(this.knownAliases, this.getClassAlias(method.getClassName()) + "_" + alias);
    }

    @Override
    public String getFieldAlias(FieldReference field) {
        return this.makeUnique(this.knownVirtualAliases, "$" + field.getFieldName());
    }

    @Override
    public String getStaticFieldAlias(FieldReference field) {
        return this.makeUnique(this.knownAliases, this.getClassAlias(field.getClassName()) + "_" + field.getFieldName());
    }

    @Override
    public String getFunctionAlias(String name) {
        return name;
    }

    private String makeUnique(Set<String> knowAliases, String alias) {
        String uniqueAlias = alias;
        int index = 1;
        while (!knowAliases.add(uniqueAlias)) {
            uniqueAlias = alias + index++;
        }
        return uniqueAlias;
    }
}

