/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.runtime;

import org.teavm.interop.Address;
import org.teavm.interop.Export;
import org.teavm.interop.StaticInit;
import org.teavm.interop.Structure;
import org.teavm.interop.Unmanaged;
import org.teavm.runtime.CallSite;
import org.teavm.runtime.CallSiteLocation;
import org.teavm.runtime.ExceptionHandler;
import org.teavm.runtime.RuntimeClass;
import org.teavm.runtime.RuntimeObject;
import org.teavm.runtime.ShadowStack;

@StaticInit
public final class ExceptionHandling {
    private static Throwable thrownException;

    private ExceptionHandling() {
    }

    public static native CallSite findCallSiteById(int var0);

    @Export(name="sys$catchException")
    @Unmanaged
    public static Throwable catchException() {
        Throwable exception = thrownException;
        thrownException = null;
        return exception;
    }

    @Unmanaged
    public static void throwException(Throwable exception) {
        thrownException = exception;
        RuntimeObject exceptionPtr = (RuntimeObject)Address.ofObject(exception).toStructure();
        RuntimeClass exceptionClass = RuntimeClass.getClass(exceptionPtr);
        Address stackFrame = ShadowStack.getStackTop();
        block0: while (stackFrame != null) {
            int callSiteId = ShadowStack.getCallSiteId(stackFrame);
            CallSite callSite = ExceptionHandling.findCallSiteById(callSiteId);
            ExceptionHandler handler = callSite.firstHandler;
            for (int i = 0; i < callSite.handlerCount; ++i) {
                if (handler.exceptionClass == null || handler.exceptionClass.isSupertypeOf.apply(exceptionClass)) {
                    ShadowStack.setExceptionHandlerId(stackFrame, handler.id);
                    break block0;
                }
                handler = Structure.add(ExceptionHandler.class, handler, 1);
            }
            ShadowStack.setExceptionHandlerId(stackFrame, callSiteId - 1);
            stackFrame = ShadowStack.getNextStackFrame(stackFrame);
        }
    }

    @Unmanaged
    public static int callStackSize() {
        Address stackFrame = ShadowStack.getStackTop();
        int size = 0;
        while (stackFrame != null) {
            stackFrame = ShadowStack.getNextStackFrame(stackFrame);
            ++size;
        }
        return size;
    }

    @Unmanaged
    public static void fillStackTrace(StackTraceElement[] target, int skip) {
        Address stackFrame = ShadowStack.getNextStackFrame(ShadowStack.getNextStackFrame(ShadowStack.getStackTop()));
        int index = 0;
        while (stackFrame != null && index < target.length) {
            int callSiteId = ShadowStack.getCallSiteId(stackFrame);
            CallSite callSite = ExceptionHandling.findCallSiteById(callSiteId);
            CallSiteLocation location = callSite.location;
            StackTraceElement element = ExceptionHandling.createElement(location != null ? location.className : "", location != null ? location.methodName : "", location != null ? location.fileName : null, location != null ? location.lineNumber : -1);
            if (skip > 0) {
                --skip;
            } else {
                target[index++] = element;
            }
            stackFrame = ShadowStack.getNextStackFrame(stackFrame);
        }
    }

    private static StackTraceElement createElement(String className, String methodName, String fileName, int lineNumber) {
        return new StackTraceElement(className, methodName, fileName, lineNumber);
    }
}

