/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model.lowlevel;

import org.teavm.model.BasicBlock;
import org.teavm.model.Incoming;
import org.teavm.model.Instruction;
import org.teavm.model.MethodReference;
import org.teavm.model.Phi;
import org.teavm.model.Program;
import org.teavm.model.ValueType;
import org.teavm.model.Variable;
import org.teavm.model.instructions.BranchingCondition;
import org.teavm.model.instructions.BranchingInstruction;
import org.teavm.model.instructions.ClassConstantInstruction;
import org.teavm.model.instructions.InitClassInstruction;
import org.teavm.model.instructions.InvocationType;
import org.teavm.model.instructions.InvokeInstruction;
import org.teavm.model.instructions.JumpInstruction;
import org.teavm.model.util.ProgramUtils;
import org.teavm.runtime.Allocator;

public class ClassInitializerTransformer {
    public void transform(Program program) {
        BasicBlock block;
        int i;
        int[] basicBlockMap = new int[program.basicBlockCount()];
        for (i = 0; i < basicBlockMap.length; ++i) {
            basicBlockMap[i] = i;
        }
        for (i = 0; i < basicBlockMap.length; ++i) {
            block = program.basicBlockAt(i);
            for (Instruction instruction : block) {
                if (!(instruction instanceof InitClassInstruction)) continue;
                String className = ((InitClassInstruction)instruction).getClassName();
                block = instruction.getBasicBlock();
                BasicBlock continueBlock = program.createBasicBlock();
                while (instruction.getNext() != null) {
                    Instruction toMove = instruction.getNext();
                    toMove.delete();
                    continueBlock.add(toMove);
                }
                continueBlock.getTryCatchBlocks().addAll(ProgramUtils.copyTryCatches(block, program));
                BasicBlock initBlock = program.createBasicBlock();
                instruction.delete();
                initBlock.add(instruction);
                JumpInstruction jumpToContinue = new JumpInstruction();
                jumpToContinue.setTarget(continueBlock);
                initBlock.add(jumpToContinue);
                this.createInitCheck(program, block, className, continueBlock, initBlock);
                basicBlockMap[i] = continueBlock.getIndex();
            }
        }
        for (i = 0; i < basicBlockMap.length; ++i) {
            block = program.basicBlockAt(i);
            for (Phi phi : block.getPhis()) {
                for (Incoming incoming : phi.getIncomings()) {
                    int source = incoming.getSource().getIndex();
                    BasicBlock mappedSource = program.basicBlockAt(basicBlockMap[source]);
                    incoming.setSource(mappedSource);
                }
            }
        }
    }

    private void createInitCheck(Program program, BasicBlock block, String className, BasicBlock continueBlock, BasicBlock initBlock) {
        Variable clsVariable = program.createVariable();
        Variable initializedVariable = program.createVariable();
        ClassConstantInstruction clsConstant = new ClassConstantInstruction();
        clsConstant.setReceiver(clsVariable);
        clsConstant.setConstant(ValueType.object(className));
        block.add(clsConstant);
        InvokeInstruction checkInitialized = new InvokeInstruction();
        checkInitialized.setType(InvocationType.SPECIAL);
        checkInitialized.setMethod(new MethodReference(Allocator.class, "isInitialized", Class.class, Boolean.TYPE));
        checkInitialized.getArguments().add(clsVariable);
        checkInitialized.setReceiver(initializedVariable);
        block.add(checkInitialized);
        BranchingInstruction branching = new BranchingInstruction(BranchingCondition.EQUAL);
        branching.setOperand(initializedVariable);
        branching.setConsequent(continueBlock);
        branching.setAlternative(initBlock);
        block.add(branching);
    }
}

