/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.stream.Stream;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.ValueType;

public class MethodReference
implements Serializable {
    private String className;
    private String name;
    private ValueType[] signature;
    private transient MethodDescriptor descriptor;
    private transient String reprCache;

    public MethodReference(String className, MethodDescriptor descriptor) {
        this.className = className;
        this.descriptor = descriptor;
        this.name = descriptor.getName();
        this.signature = descriptor.getSignature();
    }

    public MethodReference(String className, String name, ValueType ... signature) {
        this.className = className;
        this.name = name;
        this.signature = Arrays.copyOf(signature, signature.length);
    }

    public MethodReference(Class<?> cls, String name, Class<?> ... signature) {
        this(cls.getName(), name, MethodReference.convertSignature(signature));
    }

    private static ValueType[] convertSignature(Class<?> ... signature) {
        ValueType[] types = new ValueType[signature.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = ValueType.parse(signature[i]);
        }
        return types;
    }

    public String getClassName() {
        return this.className;
    }

    public MethodDescriptor getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = new MethodDescriptor(this.name, this.signature);
        }
        return this.descriptor;
    }

    public int parameterCount() {
        return this.signature.length - 1;
    }

    public ValueType parameterType(int index) {
        if (index >= this.signature.length + 1) {
            throw new IndexOutOfBoundsException("Index " + index + " is greater than size " + (this.signature.length - 1));
        }
        return this.signature[index];
    }

    public ValueType[] getParameterTypes() {
        return Arrays.copyOf(this.signature, this.signature.length - 1);
    }

    public ValueType[] getSignature() {
        return Arrays.copyOf(this.signature, this.signature.length);
    }

    public ValueType getReturnType() {
        return this.signature[this.signature.length - 1];
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MethodReference)) {
            return false;
        }
        MethodReference other = (MethodReference)obj;
        return this.toString().equals(other.toString());
    }

    @JsonValue
    public String toString() {
        if (this.reprCache == null) {
            this.reprCache = this.className + "." + this.name + this.signatureToString();
        }
        return this.reprCache;
    }

    @JsonCreator
    public static MethodReference parse(String string) {
        MethodReference reference = MethodReference.parseIfPossible(string);
        if (reference == null) {
            throw new IllegalArgumentException("Illegal method reference: " + string);
        }
        return reference;
    }

    public static MethodReference parseIfPossible(String string) {
        int index = string.lastIndexOf(46);
        if (index < 1) {
            return null;
        }
        String className = string.substring(0, index);
        MethodDescriptor desc = MethodDescriptor.parseIfPossible(string.substring(index + 1));
        return desc != null ? new MethodReference(className, desc) : null;
    }

    public static MethodReference parse(Method method) {
        ValueType[] signature = (ValueType[])Stream.concat(Arrays.stream(method.getParameterTypes()).map(ValueType::parse), Stream.of(ValueType.parse(method.getReturnType()))).toArray(ValueType[]::new);
        return new MethodReference(method.getDeclaringClass().getName(), method.getName(), signature);
    }

    public String signatureToString() {
        return this.getDescriptor().signatureToString();
    }
}

