/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.dependency;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.teavm.callgraph.CallGraph;
import org.teavm.callgraph.DefaultCallGraph;
import org.teavm.callgraph.DefaultCallGraphNode;
import org.teavm.common.CachedMapper;
import org.teavm.common.Mapper;
import org.teavm.common.ServiceRepository;
import org.teavm.dependency.BootstrapMethodSubstitutor;
import org.teavm.dependency.ClassDependency;
import org.teavm.dependency.DependencyAgent;
import org.teavm.dependency.DependencyCheckerInterruptor;
import org.teavm.dependency.DependencyClassSource;
import org.teavm.dependency.DependencyConsumer;
import org.teavm.dependency.DependencyGraphBuilder;
import org.teavm.dependency.DependencyInfo;
import org.teavm.dependency.DependencyListener;
import org.teavm.dependency.DependencyNode;
import org.teavm.dependency.DependencyPlugin;
import org.teavm.dependency.DependencyType;
import org.teavm.dependency.FieldDependency;
import org.teavm.dependency.MethodDependency;
import org.teavm.dependency.PluggableDependency;
import org.teavm.diagnostics.Diagnostics;
import org.teavm.model.AnnotationReader;
import org.teavm.model.CallLocation;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderTransformer;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.ElementModifier;
import org.teavm.model.FieldHolder;
import org.teavm.model.FieldReader;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.Program;
import org.teavm.model.ReferenceCache;
import org.teavm.model.TextLocation;
import org.teavm.model.ValueType;
import org.teavm.model.optimization.UnreachableBasicBlockEliminator;
import org.teavm.model.util.ModelUtils;
import org.teavm.model.util.ProgramUtils;
import org.teavm.parsing.Parser;

public class DependencyChecker
implements DependencyInfo {
    static final boolean shouldLog = System.getProperty("org.teavm.logDependencies", "false").equals("true");
    private int classNameSuffix;
    private DependencyClassSource classSource;
    private ClassLoader classLoader;
    private Mapper<MethodReference, MethodHolder> methodReaderCache;
    private Mapper<FieldReference, FieldHolder> fieldReaderCache;
    private CachedMapper<MethodReference, MethodDependency> methodCache;
    private CachedMapper<FieldReference, FieldDependency> fieldCache;
    private CachedMapper<String, ClassDependency> classCache;
    private List<DependencyListener> listeners = new ArrayList<DependencyListener>();
    private ServiceRepository services;
    private Queue<Runnable> tasks = new ArrayDeque<Runnable>();
    List<DependencyType> types = new ArrayList<DependencyType>();
    private Map<String, DependencyType> typeMap = new HashMap<String, DependencyType>();
    private DependencyCheckerInterruptor interruptor;
    private boolean interrupted;
    private Diagnostics diagnostics;
    DefaultCallGraph callGraph = new DefaultCallGraph();
    private DependencyAgent agent;
    Map<MethodReference, BootstrapMethodSubstitutor> bootstrapMethodSubstitutors = new HashMap<MethodReference, BootstrapMethodSubstitutor>();
    private boolean completing;
    private int propagationDepth;
    private Set<String> classesAddedByRoot = new HashSet<String>();
    private Set<MethodReference> methodsAddedByRoot = new HashSet<MethodReference>();
    private Set<FieldReference> fieldsAddedByRoot = new HashSet<FieldReference>();

    public DependencyChecker(ClassReaderSource classSource, ClassLoader classLoader, ServiceRepository services, Diagnostics diagnostics) {
        this.diagnostics = diagnostics;
        this.classSource = new DependencyClassSource(classSource, diagnostics);
        this.classLoader = classLoader;
        this.services = services;
        this.methodReaderCache = new CachedMapper<MethodReference, MethodHolder>(preimage -> this.classSource.resolveMutable((MethodReference)preimage));
        this.fieldReaderCache = new CachedMapper<FieldReference, FieldHolder>(preimage -> this.classSource.resolveMutable((FieldReference)preimage));
        this.methodCache = new CachedMapper<MethodReference, MethodDependency>(preimage -> {
            MethodHolder method = this.methodReaderCache.map((MethodReference)preimage);
            if (method != null && !method.getReference().equals(preimage)) {
                return this.methodCache.map(method.getReference());
            }
            return this.createMethodDep((MethodReference)preimage, method);
        });
        this.fieldCache = new CachedMapper<FieldReference, FieldDependency>(preimage -> {
            FieldReader field = this.fieldReaderCache.map((FieldReference)preimage);
            if (field != null && !field.getReference().equals(preimage)) {
                return this.fieldCache.map(field.getReference());
            }
            return this.createFieldNode((FieldReference)preimage, field);
        });
        this.classCache = new CachedMapper<String, ClassDependency>(this::createClassDependency);
        this.agent = new DependencyAgent(this);
    }

    public DependencyAgent getAgent() {
        return this.agent;
    }

    public DependencyCheckerInterruptor getInterruptor() {
        return this.interruptor;
    }

    public void setInterruptor(DependencyCheckerInterruptor interruptor) {
        this.interruptor = interruptor;
    }

    public boolean wasInterrupted() {
        return this.interrupted;
    }

    public DependencyType getType(String name) {
        DependencyType type = this.typeMap.get(name);
        if (type == null) {
            type = new DependencyType(this, name, this.types.size());
            this.types.add(type);
            this.typeMap.put(name, type);
        }
        return type;
    }

    public DependencyNode createNode() {
        return new DependencyNode(this);
    }

    @Override
    public ClassReaderSource getClassSource() {
        return this.classSource;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public String generateClassName() {
        return "$$teavm_generated_class$$" + this.classNameSuffix++;
    }

    public String submitClassFile(byte[] data) {
        ClassNode node = new ClassNode();
        org.objectweb.asm.ClassReader reader = new org.objectweb.asm.ClassReader(data);
        reader.accept((ClassVisitor)node, 0);
        this.submitClass(new Parser(new ReferenceCache()).parseClass(node));
        return node.name;
    }

    public void submitClass(ClassHolder cls) {
        if (this.completing) {
            throw new IllegalStateException("Can't submit class during completion phase");
        }
        this.classSource.submit(ModelUtils.copyClass(cls));
    }

    public void submitMethod(MethodReference methodRef, Program program) {
        if (!this.completing) {
            ClassHolder cls = this.classSource.get(methodRef.getClassName());
            if (cls == null) {
                throw new IllegalArgumentException("Class not found: " + methodRef.getClassName());
            }
            if (cls.getMethod(methodRef.getDescriptor()) != null) {
                throw new IllegalArgumentException("Method already exists: " + methodRef.getClassName());
            }
            MethodHolder method = new MethodHolder(methodRef.getDescriptor());
            method.getModifiers().add(ElementModifier.STATIC);
            method.setProgram(ProgramUtils.copy(program));
            new UnreachableBasicBlockEliminator().optimize(program);
            cls.addMethod(method);
        } else {
            MethodDependency dep = this.getMethod(methodRef);
            if (dep == null) {
                throw new IllegalArgumentException("Method was not reached: " + methodRef);
            }
            MethodHolder method = dep.method;
            if (!method.hasModifier(ElementModifier.NATIVE)) {
                throw new IllegalArgumentException("Method is not native: " + methodRef);
            }
            if (!dep.used) {
                return;
            }
            method.getModifiers().remove((Object)ElementModifier.NATIVE);
            method.setProgram(ProgramUtils.copy(program));
            new UnreachableBasicBlockEliminator().optimize(method.getProgram());
            dep.used = false;
            this.lock(dep, false);
            this.tasks.add(() -> {
                DependencyGraphBuilder graphBuilder = new DependencyGraphBuilder(this);
                graphBuilder.buildGraph(dep);
                dep.used = true;
            });
            this.processQueue();
        }
    }

    public void addDependencyListener(DependencyListener listener) {
        this.listeners.add(listener);
        listener.started(this.agent);
    }

    public void addClassTransformer(ClassHolderTransformer transformer) {
        this.classSource.addTransformer(transformer);
    }

    public void addEntryPoint(MethodReference methodRef, String ... argumentTypes) {
        ValueType[] parameters = methodRef.getDescriptor().getParameterTypes();
        if (parameters.length + 1 != argumentTypes.length) {
            throw new IllegalArgumentException("argumentTypes length does not match the number of method's arguments");
        }
        MethodDependency method = this.linkMethod(methodRef, null);
        method.use();
        DependencyNode[] varNodes = method.getVariables();
        varNodes[0].propagate(this.getType(methodRef.getClassName()));
        for (int i = 0; i < argumentTypes.length; ++i) {
            varNodes[i + 1].propagate(this.getType(argumentTypes[i]));
        }
    }

    void schedulePropagation(DependencyConsumer consumer, DependencyType type) {
        if (this.propagationDepth < 50) {
            ++this.propagationDepth;
            consumer.consume(type);
            --this.propagationDepth;
        } else {
            this.tasks.add(() -> consumer.consume(type));
        }
    }

    void schedulePropagation(DependencyConsumer consumer, DependencyType[] types) {
        if (this.propagationDepth < 50) {
            ++this.propagationDepth;
            for (DependencyType type : types) {
                consumer.consume(type);
            }
            --this.propagationDepth;
        } else {
            this.tasks.add(() -> {
                for (DependencyType type : types) {
                    consumer.consume(type);
                }
            });
        }
    }

    public ClassDependency linkClass(String className, CallLocation callLocation) {
        if (this.completing && this.getClass(className) == null) {
            throw new IllegalStateException("Can't link class during completion phase");
        }
        ClassDependency dep = this.classCache.map(className);
        boolean added = true;
        if (callLocation != null && callLocation.getMethod() != null) {
            DefaultCallGraphNode callGraphNode = this.callGraph.getNode(callLocation.getMethod());
            if (!this.addClassAccess(callGraphNode, className, callLocation.getSourceLocation())) {
                added = false;
            }
        } else {
            added = this.classesAddedByRoot.add(className);
        }
        if (!dep.isMissing() && added) {
            this.tasks.add(() -> {
                for (DependencyListener listener : this.listeners) {
                    listener.classReached(this.agent, className, callLocation);
                }
            });
        }
        return dep;
    }

    private boolean addClassAccess(DefaultCallGraphNode node, String className, TextLocation loc) {
        if (!node.addClassAccess(className, loc)) {
            return false;
        }
        ClassHolder cls = this.classSource.get(className);
        if (cls != null) {
            if (cls.getParent() != null && !cls.getParent().equals(cls.getName())) {
                this.addClassAccess(node, cls.getParent(), loc);
            }
            for (String iface : cls.getInterfaces()) {
                this.addClassAccess(node, iface, loc);
            }
        }
        return true;
    }

    private ClassDependency createClassDependency(String className) {
        ClassHolder cls = this.classSource.get(className);
        ClassDependency dependency = new ClassDependency(this, className, cls);
        if (!dependency.isMissing()) {
            if (cls.getParent() != null && !cls.getParent().equals(className)) {
                this.linkClass(cls.getParent(), null);
            }
            for (String ifaceName : cls.getInterfaces()) {
                this.linkClass(ifaceName, null);
            }
        }
        return dependency;
    }

    public MethodDependency linkMethod(MethodReference methodRef, CallLocation callLocation) {
        if (methodRef == null) {
            throw new IllegalArgumentException();
        }
        MethodReader methodReader = this.methodReaderCache.map(methodRef);
        if (methodReader != null) {
            methodRef = methodReader.getReference();
        }
        if (this.completing && this.getMethod(methodRef) == null) {
            throw new IllegalStateException("Can't submit class during completion phase");
        }
        this.callGraph.getNode(methodRef);
        boolean added = callLocation != null && callLocation.getMethod() != null ? this.callGraph.getNode(callLocation.getMethod()).addCallSite(methodRef, callLocation.getSourceLocation()) : this.methodsAddedByRoot.add(methodRef);
        MethodDependency graph = this.methodCache.map(methodRef);
        if (!graph.isMissing() && added) {
            for (DependencyListener listener : this.listeners) {
                listener.methodReached(this.agent, graph, callLocation);
            }
            this.activateDependencyPlugin(graph, callLocation);
        }
        return graph;
    }

    void initClass(ClassDependency cls, CallLocation callLocation) {
        ClassReader reader = cls.getClassReader();
        MethodReader method = reader.getMethod(new MethodDescriptor("<clinit>", Void.TYPE));
        if (method != null) {
            this.tasks.add(() -> this.linkMethod(method.getReference(), callLocation).use());
        }
    }

    private MethodDependency createMethodDep(MethodReference methodRef, MethodHolder method) {
        DependencyNode resultNode;
        ValueType[] arguments = methodRef.getParameterTypes();
        int paramCount = arguments.length + 1;
        DependencyNode[] parameterNodes = new DependencyNode[arguments.length + 1];
        for (int i = 0; i < parameterNodes.length; ++i) {
            parameterNodes[i] = this.createNode();
            parameterNodes[i].method = methodRef;
            if (!shouldLog) continue;
            parameterNodes[i].setTag(methodRef + ":" + i);
        }
        if (methodRef.getDescriptor().getResultType() == ValueType.VOID) {
            resultNode = null;
        } else {
            resultNode = this.createNode();
            resultNode.method = methodRef;
            if (shouldLog) {
                resultNode.setTag(methodRef + ":RESULT");
            }
        }
        DependencyNode thrown = this.createNode();
        thrown.method = methodRef;
        if (shouldLog) {
            thrown.setTag(methodRef + ":THROWN");
        }
        MethodDependency dep = new MethodDependency(this, parameterNodes, paramCount, resultNode, thrown, method, methodRef);
        if (method != null) {
            this.tasks.add(() -> {
                CallLocation caller = new CallLocation(dep.getMethod().getReference());
                this.linkClass(dep.getMethod().getOwnerName(), caller).initClass(caller);
            });
        }
        return dep;
    }

    void scheduleMethodAnalysis(MethodDependency dep) {
        this.tasks.add(() -> {
            DependencyGraphBuilder graphBuilder = new DependencyGraphBuilder(this);
            graphBuilder.buildGraph(dep);
        });
    }

    @Override
    public Collection<MethodReference> getReachableMethods() {
        return this.methodCache.getCachedPreimages();
    }

    @Override
    public Collection<FieldReference> getReachableFields() {
        return this.fieldCache.getCachedPreimages();
    }

    @Override
    public Collection<String> getReachableClasses() {
        return this.classCache.getCachedPreimages();
    }

    public FieldDependency linkField(FieldReference fieldRef, CallLocation location) {
        if (this.completing) {
            throw new IllegalStateException("Can't submit class during completion phase");
        }
        boolean added = location != null ? this.callGraph.getNode(location.getMethod()).addFieldAccess(fieldRef, location.getSourceLocation()) : this.fieldsAddedByRoot.add(fieldRef);
        FieldDependency dep = this.fieldCache.map(fieldRef);
        if (!dep.isMissing()) {
            this.tasks.add(() -> this.linkClass(fieldRef.getClassName(), location).initClass(location));
        }
        if (!dep.isMissing() && added) {
            for (DependencyListener listener : this.listeners) {
                listener.fieldReached(this.agent, dep, location);
            }
        }
        return dep;
    }

    @Override
    public FieldDependency getField(FieldReference fieldRef) {
        return this.fieldCache.getKnown(fieldRef);
    }

    @Override
    public ClassDependency getClass(String className) {
        return this.classCache.getKnown(className);
    }

    private FieldDependency createFieldNode(FieldReference fieldRef, FieldReader field) {
        FieldDependency dep;
        DependencyNode node = this.createNode();
        if (shouldLog) {
            node.setTag(fieldRef.getClassName() + "#" + fieldRef.getFieldName());
        }
        if (!(dep = new FieldDependency(node, field, fieldRef)).isMissing()) {
            this.tasks.add(() -> this.linkClass(fieldRef.getClassName(), null).initClass(null));
        }
        return dep;
    }

    private void activateDependencyPlugin(MethodDependency methodDep, CallLocation location) {
        this.attachDependencyPlugin(methodDep);
        if (methodDep.dependencyPlugin != null) {
            methodDep.dependencyPlugin.methodReached(this.agent, methodDep, location);
        }
    }

    private void attachDependencyPlugin(MethodDependency methodDep) {
        Class<?> depClass;
        if (methodDep.dependencyPluginAttached) {
            return;
        }
        methodDep.dependencyPluginAttached = true;
        AnnotationReader depAnnot = methodDep.getMethod().getAnnotations().get(PluggableDependency.class.getName());
        if (depAnnot == null) {
            return;
        }
        ValueType depType = depAnnot.getValue("value").getJavaClass();
        String depClassName = ((ValueType.Object)depType).getClassName();
        try {
            depClass = Class.forName(depClassName, true, this.classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Dependency plugin not found: " + depClassName, e);
        }
        try {
            methodDep.dependencyPlugin = (DependencyPlugin)depClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Can't instantiate dependency plugin " + depClassName, e);
        }
    }

    @Override
    public MethodDependency getMethod(MethodReference methodRef) {
        return this.methodCache.getKnown(methodRef);
    }

    @Override
    public MethodDependency getMethodImplementation(MethodReference methodRef) {
        MethodReader method = this.methodReaderCache.map(methodRef);
        return method != null ? this.methodCache.getKnown(method.getReference()) : null;
    }

    private void processQueue() {
        if (this.interrupted) {
            return;
        }
        int index = 0;
        while (!this.tasks.isEmpty()) {
            this.tasks.poll().run();
            if (++index != 100) continue;
            if (this.interruptor != null && !this.interruptor.shouldContinue()) {
                this.interrupted = true;
                break;
            }
            index = 0;
        }
    }

    public void processDependencies() {
        this.interrupted = false;
        this.processQueue();
        if (!this.interrupted) {
            this.completing = true;
            this.lock();
            for (DependencyListener listener : this.listeners) {
                listener.completing(this.agent);
            }
        }
    }

    private void lock() {
        for (MethodReference method : this.getReachableMethods()) {
            this.lock(this.getMethod(method), true);
        }
        for (FieldReference field : this.getReachableFields()) {
            this.lock(this.getField(field));
        }
    }

    private void lock(MethodDependency dep, boolean lock) {
        for (DependencyNode node : dep.variableNodes) {
            if (node == null) continue;
            node.locked = lock;
        }
        if (dep.resultNode != null) {
            dep.resultNode.locked = lock;
        }
        if (dep.thrown != null) {
            dep.thrown.locked = lock;
        }
    }

    private void lock(FieldDependency dep) {
        dep.value.locked = true;
    }

    public <T> T getService(Class<T> type) {
        return this.services.getService(type);
    }

    public Diagnostics getDiagnostics() {
        return this.diagnostics;
    }

    @Override
    public CallGraph getCallGraph() {
        return this.callGraph;
    }

    public void addBootstrapMethodSubstitutor(MethodReference method, BootstrapMethodSubstitutor substitutor) {
        this.bootstrapMethodSubstitutors.put(method, substitutor);
    }
}

