/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.debugging;

import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.teavm.debugging.Debugger;
import org.teavm.debugging.PropertyMap;
import org.teavm.debugging.Variable;
import org.teavm.debugging.javascript.JavaScriptValue;

public class Value {
    private Debugger debugger;
    private JavaScriptValue jsValue;
    private AtomicReference<PropertyMap> properties = new AtomicReference();

    Value(Debugger debugger, JavaScriptValue jsValue) {
        this.debugger = debugger;
        this.jsValue = jsValue;
    }

    public String getRepresentation() {
        return this.jsValue.getRepresentation();
    }

    public String getType() {
        return this.jsValue.getClassName();
    }

    public Map<String, Variable> getProperties() {
        if (this.properties.get() == null) {
            this.properties.compareAndSet(null, new PropertyMap(this.jsValue.getClassName(), this.jsValue.getProperties(), this.debugger));
        }
        return this.properties.get();
    }

    public boolean hasInnerStructure() {
        if (this.getType().equals("long")) {
            return false;
        }
        return this.jsValue.hasInnerStructure();
    }

    public String getInstanceId() {
        if (this.getType().equals("long")) {
            return null;
        }
        return this.jsValue.getInstanceId();
    }
}

