/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.render;

import java.util.Arrays;
import org.teavm.backend.wasm.model.WasmFunction;
import org.teavm.backend.wasm.model.WasmType;

final class WasmSignature {
    WasmType[] types;

    WasmSignature(WasmType[] types) {
        this.types = types;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WasmSignature that = (WasmSignature)o;
        return Arrays.equals((Object[])this.types, (Object[])that.types);
    }

    public int hashCode() {
        return Arrays.hashCode((Object[])this.types);
    }

    public static WasmSignature fromFunction(WasmFunction function) {
        WasmType[] types = new WasmType[function.getParameters().size() + 1];
        types[0] = function.getResult();
        for (int i = 0; i < function.getParameters().size(); ++i) {
            types[i + 1] = function.getParameters().get(i);
        }
        return new WasmSignature(types);
    }
}

