/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.render;

import java.util.ArrayList;
import java.util.List;
import org.teavm.backend.wasm.model.WasmFunction;
import org.teavm.backend.wasm.model.WasmLocal;
import org.teavm.backend.wasm.model.WasmMemorySegment;
import org.teavm.backend.wasm.model.WasmModule;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.render.CLine;
import org.teavm.backend.wasm.render.CSingleLine;
import org.teavm.backend.wasm.render.WasmCRenderingVisitor;
import org.teavm.model.TextLocation;

public class WasmCRenderer {
    private StringBuilder out = new StringBuilder();
    private int indentLevel;
    String currentFile = "";
    int currentLine = -1;
    boolean lineNumbersEmitted;
    boolean memoryAccessChecked;
    TextLocation lastReportedLocation;

    public boolean isLineNumbersEmitted() {
        return this.lineNumbersEmitted;
    }

    public void setLineNumbersEmitted(boolean value) {
        this.lineNumbersEmitted = value;
    }

    public boolean isMemoryAccessChecked() {
        return this.memoryAccessChecked;
    }

    public void setMemoryAccessChecked(boolean memoryAccessChecked) {
        this.memoryAccessChecked = memoryAccessChecked;
    }

    void indent() {
        ++this.indentLevel;
    }

    void outdent() {
        --this.indentLevel;
    }

    void line(String line) {
        for (int i = 0; i < this.indentLevel; ++i) {
            this.out.append("    ");
        }
        this.out.append(line).append("\n");
    }

    public void render(WasmModule module) {
        this.line("#include <inttypes.h>");
        this.line("#include <string.h>");
        this.line("#include <stdlib.h>");
        this.line("#include <assert.h>");
        this.line("");
        this.renderFunctionDeclarations(module);
        this.line("static int8_t *wasm_heap;");
        this.line("static int32_t wasm_heap_size;");
        this.renderFunctionTable(module);
        for (WasmFunction function : module.getFunctions().values()) {
            if (function.getImportName() != null) continue;
            this.renderFunction(function);
        }
        this.line("void main() {");
        this.indent();
        this.renderHeap(module);
        if (module.getStartFunction() != null) {
            this.line(module.getStartFunction().getName() + "();");
        }
        for (WasmFunction function : module.getFunctions().values()) {
            if (function.getExportName() == null || !function.getExportName().equals("main")) continue;
            this.line(function.getName() + "(1);");
        }
        this.outdent();
        this.line("}");
    }

    private void renderHeap(WasmModule module) {
        this.line("wasm_heap_size = " + 65536 * module.getMemorySize() + ";");
        this.line("wasm_heap = malloc(" + 65536 * module.getMemorySize() + ");");
        for (WasmMemorySegment segment : module.getSegments()) {
            this.line("memcpy(wasm_heap + " + segment.getOffset() + ",");
            this.indent();
            for (int i = 0; i < segment.getLength(); i += 48) {
                byte[] data = segment.getData(i, Math.min(i + 48, segment.getLength()) - i);
                boolean last = i + data.length >= segment.getLength();
                StringBuilder sb = new StringBuilder("\"");
                for (int j = 0; j < data.length; ++j) {
                    byte b = data[j];
                    sb.append("\\x").append(Character.forDigit(b >>> 4 & 0xF, 16)).append(Character.forDigit(b & 0xF, 16));
                }
                sb.append("\"");
                if (last) {
                    sb.append(", " + segment.getLength() + ");");
                }
                this.line(sb.toString());
            }
            this.outdent();
        }
    }

    private void renderFunctionTable(WasmModule module) {
        this.line("static void *wasm_table[] = {");
        if (!module.getFunctionTable().isEmpty()) {
            this.indent();
            for (int i = 0; i < module.getFunctionTable().size() - 1; ++i) {
                WasmFunction function = module.getFunctionTable().get(i);
                this.line((function != null ? function.getName() : "unknown") + ",");
            }
            this.line(module.getFunctionTable().get(module.getFunctionTable().size() - 1).getName());
            this.outdent();
        }
        this.line("};");
        this.line("");
    }

    private void renderFunctionDeclarations(WasmModule module) {
        for (WasmFunction function : module.getFunctions().values()) {
            this.line(this.functionDeclaration(function) + ";");
        }
    }

    private void renderFunction(WasmFunction function) {
        WasmCRenderingVisitor visitor = new WasmCRenderingVisitor(function.getResult(), function.getLocalVariables().size(), function.getModule());
        visitor.setMemoryAccessChecked(this.memoryAccessChecked);
        StringBuilder declaration = new StringBuilder();
        WasmCRenderer.renderFunctionModifiers(declaration, function);
        declaration.append(WasmCRenderingVisitor.mapType(function.getResult())).append(' ');
        declaration.append(function.getName()).append('(');
        for (int i = 0; i < function.getParameters().size(); ++i) {
            if (i > 0) {
                declaration.append(", ");
            }
            declaration.append(WasmCRenderingVisitor.mapType(function.getParameters().get(i)));
            WasmLocal var = function.getLocalVariables().get(i);
            declaration.append(' ').append(visitor.getVariableName(var));
        }
        declaration.append(") {");
        this.line(declaration.toString());
        this.indent();
        List<WasmLocal> variables = function.getLocalVariables().subList(function.getParameters().size(), function.getLocalVariables().size());
        for (WasmLocal variable : variables) {
            this.line(WasmCRenderingVisitor.mapType(variable.getType()) + " " + visitor.getVariableName(variable) + ";");
        }
        List<WasmExpression> body = function.getBody();
        ArrayList<CLine> lines = new ArrayList<CLine>();
        if (!body.isEmpty()) {
            for (int i = 0; i < body.size() - 1; ++i) {
                visitor.setRequiredType(null);
                body.get(i).acceptVisitor(visitor);
                lines.addAll(visitor.getValue().getLines());
            }
            visitor.setRequiredType(function.getResult());
            body.get(body.size() - 1).acceptVisitor(visitor);
            lines.addAll(visitor.getValue().getLines());
            if (visitor.getValue().getText() != null) {
                lines.add(new CSingleLine(visitor.getValue().getText()));
            }
        }
        for (CLine line : lines) {
            line.render(this);
        }
        this.outdent();
        this.line("}");
        this.line("");
    }

    private String functionDeclaration(WasmFunction function) {
        StringBuilder sb = new StringBuilder();
        WasmCRenderer.renderFunctionModifiers(sb, function);
        sb.append(WasmCRenderingVisitor.mapType(function.getResult())).append(' ');
        sb.append(function.getName()).append("(");
        for (int i = 0; i < function.getParameters().size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(WasmCRenderingVisitor.mapType(function.getParameters().get(i)));
        }
        sb.append(")");
        return sb.toString();
    }

    private static void renderFunctionModifiers(StringBuilder sb, WasmFunction function) {
        if (function.getImportName() != null) {
            sb.append("extern ");
        } else if (function.getExportName() == null) {
            sb.append("static ");
        }
    }

    public String toString() {
        return this.out.toString();
    }
}

