/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.generate;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;

public final class WasmMangling {
    private WasmMangling() {
    }

    public static String mangleIsSupertype(ValueType type) {
        return "isSupertype$" + WasmMangling.mangleType(type);
    }

    public static String mangleMethod(MethodReference method) {
        String className = method.getClassName().length() + WasmMangling.mangleString(method.getClassName());
        StringBuilder sb = new StringBuilder("method$" + className + "_");
        String name = WasmMangling.mangleString(method.getName());
        sb.append(WasmMangling.mangleType(method.getReturnType()));
        sb.append(name.length() + "_" + name);
        sb.append(Arrays.stream(method.getParameterTypes()).map(WasmMangling::mangleType).collect(Collectors.joining()));
        return sb.toString();
    }

    public static String mangleInitializer(String className) {
        return "clinit$" + WasmMangling.mangleString(className);
    }

    private static String mangleString(String string) {
        StringBuilder sb = new StringBuilder();
        block7: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '$': {
                    sb.append(c);
                    continue block7;
                }
                case '.': {
                    sb.append("_g");
                    continue block7;
                }
                case '<': {
                    sb.append("_h");
                    continue block7;
                }
                case '>': {
                    sb.append("_i");
                    continue block7;
                }
                case '_': {
                    sb.append("__");
                    continue block7;
                }
                default: {
                    if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9') {
                        sb.append(c);
                        continue block7;
                    }
                    sb.append('_').append(Character.forDigit(c >>> 12, 16)).append(Character.forDigit(c >>> 8 & 0xF, 16)).append(Character.forDigit(c >>> 4 & 0xF, 16)).append(Character.forDigit(c & 0xF, 16));
                }
            }
        }
        return sb.toString();
    }

    public static String mangleType(ValueType type) {
        if (type instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)type).getKind()) {
                case BOOLEAN: {
                    return "Z";
                }
                case BYTE: {
                    return "B";
                }
                case SHORT: {
                    return "S";
                }
                case CHARACTER: {
                    return "C";
                }
                case INTEGER: {
                    return "I";
                }
                case LONG: {
                    return "L";
                }
                case FLOAT: {
                    return "F";
                }
                case DOUBLE: {
                    return "D";
                }
            }
        } else {
            if (type instanceof ValueType.Void) {
                return "V";
            }
            if (type instanceof ValueType.Array) {
                return "A" + WasmMangling.mangleType(((ValueType.Array)type).getItemType());
            }
            if (type instanceof ValueType.Object) {
                String className = ((ValueType.Object)type).getClassName();
                return className.length() + "_" + WasmMangling.mangleString(className);
            }
        }
        throw new IllegalArgumentException("Don't know how to mangle " + type);
    }
}

