/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.generate;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teavm.ast.AssignmentStatement;
import org.teavm.ast.BinaryExpr;
import org.teavm.ast.BlockStatement;
import org.teavm.ast.BreakStatement;
import org.teavm.ast.CastExpr;
import org.teavm.ast.ConditionalExpr;
import org.teavm.ast.ConditionalStatement;
import org.teavm.ast.ConstantExpr;
import org.teavm.ast.ContinueStatement;
import org.teavm.ast.Expr;
import org.teavm.ast.ExprVisitor;
import org.teavm.ast.GotoPartStatement;
import org.teavm.ast.IdentifiedStatement;
import org.teavm.ast.InitClassStatement;
import org.teavm.ast.InstanceOfExpr;
import org.teavm.ast.InvocationExpr;
import org.teavm.ast.InvocationType;
import org.teavm.ast.MonitorEnterStatement;
import org.teavm.ast.MonitorExitStatement;
import org.teavm.ast.NewArrayExpr;
import org.teavm.ast.NewExpr;
import org.teavm.ast.NewMultiArrayExpr;
import org.teavm.ast.OperationType;
import org.teavm.ast.PrimitiveCastExpr;
import org.teavm.ast.QualificationExpr;
import org.teavm.ast.ReturnStatement;
import org.teavm.ast.SequentialStatement;
import org.teavm.ast.Statement;
import org.teavm.ast.StatementVisitor;
import org.teavm.ast.SubscriptExpr;
import org.teavm.ast.SwitchClause;
import org.teavm.ast.SwitchStatement;
import org.teavm.ast.ThrowStatement;
import org.teavm.ast.TryCatchStatement;
import org.teavm.ast.UnaryExpr;
import org.teavm.ast.UnwrapArrayExpr;
import org.teavm.ast.VariableExpr;
import org.teavm.ast.WhileStatement;
import org.teavm.backend.wasm.WasmRuntime;
import org.teavm.backend.wasm.binary.BinaryWriter;
import org.teavm.backend.wasm.binary.DataPrimitives;
import org.teavm.backend.wasm.generate.WasmClassGenerator;
import org.teavm.backend.wasm.generate.WasmGenerationContext;
import org.teavm.backend.wasm.generate.WasmGeneratorUtil;
import org.teavm.backend.wasm.generate.WasmMangling;
import org.teavm.backend.wasm.generate.WasmStringPool;
import org.teavm.backend.wasm.intrinsics.WasmIntrinsic;
import org.teavm.backend.wasm.intrinsics.WasmIntrinsicManager;
import org.teavm.backend.wasm.model.WasmFunction;
import org.teavm.backend.wasm.model.WasmLocal;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmBlock;
import org.teavm.backend.wasm.model.expression.WasmBranch;
import org.teavm.backend.wasm.model.expression.WasmBreak;
import org.teavm.backend.wasm.model.expression.WasmCall;
import org.teavm.backend.wasm.model.expression.WasmConditional;
import org.teavm.backend.wasm.model.expression.WasmConversion;
import org.teavm.backend.wasm.model.expression.WasmDrop;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.backend.wasm.model.expression.WasmFloat32Constant;
import org.teavm.backend.wasm.model.expression.WasmFloat64Constant;
import org.teavm.backend.wasm.model.expression.WasmFloatBinary;
import org.teavm.backend.wasm.model.expression.WasmFloatBinaryOperation;
import org.teavm.backend.wasm.model.expression.WasmFloatType;
import org.teavm.backend.wasm.model.expression.WasmGetLocal;
import org.teavm.backend.wasm.model.expression.WasmIndirectCall;
import org.teavm.backend.wasm.model.expression.WasmInt32Constant;
import org.teavm.backend.wasm.model.expression.WasmInt32Subtype;
import org.teavm.backend.wasm.model.expression.WasmInt64Constant;
import org.teavm.backend.wasm.model.expression.WasmInt64Subtype;
import org.teavm.backend.wasm.model.expression.WasmIntBinary;
import org.teavm.backend.wasm.model.expression.WasmIntBinaryOperation;
import org.teavm.backend.wasm.model.expression.WasmIntType;
import org.teavm.backend.wasm.model.expression.WasmLoadFloat32;
import org.teavm.backend.wasm.model.expression.WasmLoadFloat64;
import org.teavm.backend.wasm.model.expression.WasmLoadInt32;
import org.teavm.backend.wasm.model.expression.WasmLoadInt64;
import org.teavm.backend.wasm.model.expression.WasmReturn;
import org.teavm.backend.wasm.model.expression.WasmSetLocal;
import org.teavm.backend.wasm.model.expression.WasmStoreFloat32;
import org.teavm.backend.wasm.model.expression.WasmStoreFloat64;
import org.teavm.backend.wasm.model.expression.WasmStoreInt32;
import org.teavm.backend.wasm.model.expression.WasmStoreInt64;
import org.teavm.backend.wasm.model.expression.WasmSwitch;
import org.teavm.backend.wasm.model.expression.WasmUnreachable;
import org.teavm.backend.wasm.render.WasmTypeInference;
import org.teavm.diagnostics.Diagnostics;
import org.teavm.interop.Address;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodReference;
import org.teavm.model.TextLocation;
import org.teavm.model.ValueType;
import org.teavm.model.classes.TagRegistry;
import org.teavm.model.classes.VirtualTableEntry;
import org.teavm.runtime.Allocator;
import org.teavm.runtime.RuntimeArray;
import org.teavm.runtime.RuntimeClass;
import org.teavm.runtime.ShadowStack;

class WasmGenerationVisitor
implements StatementVisitor,
ExprVisitor {
    private static FieldReference tagField = new FieldReference(RuntimeClass.class.getName(), "tag");
    private static final int SWITCH_TABLE_THRESHOLD = 256;
    private WasmGenerationContext context;
    private WasmClassGenerator classGenerator;
    private WasmTypeInference typeInference;
    private WasmFunction function;
    private int firstVariable;
    private IdentifiedStatement currentContinueTarget;
    private IdentifiedStatement currentBreakTarget;
    private Map<IdentifiedStatement, WasmBlock> breakTargets = new HashMap<IdentifiedStatement, WasmBlock>();
    private Map<IdentifiedStatement, WasmBlock> continueTargets = new HashMap<IdentifiedStatement, WasmBlock>();
    private Set<WasmBlock> usedBlocks = new HashSet<WasmBlock>();
    private List<Deque<WasmLocal>> temporaryVariablesByType = new ArrayList<Deque<WasmLocal>>();
    private WasmLocal stackVariable;
    private BinaryWriter binaryWriter;
    WasmExpression result;
    private WasmIntrinsicManager intrinsicManager = new WasmIntrinsicManager(){

        @Override
        public WasmExpression generate(Expr expr) {
            WasmGenerationVisitor.this.accept(expr);
            return WasmGenerationVisitor.this.result;
        }

        @Override
        public BinaryWriter getBinaryWriter() {
            return WasmGenerationVisitor.this.binaryWriter;
        }

        @Override
        public WasmStringPool getStringPool() {
            return WasmGenerationVisitor.this.context.getStringPool();
        }

        @Override
        public Diagnostics getDiagnostics() {
            return WasmGenerationVisitor.this.context.getDiagnostics();
        }
    };

    WasmGenerationVisitor(WasmGenerationContext context, WasmClassGenerator classGenerator, BinaryWriter binaryWriter, WasmFunction function, int firstVariable) {
        this.context = context;
        this.classGenerator = classGenerator;
        this.binaryWriter = binaryWriter;
        this.function = function;
        this.firstVariable = firstVariable;
        int typeCount = WasmType.values().length;
        for (int i = 0; i < typeCount; ++i) {
            this.temporaryVariablesByType.add(new ArrayDeque());
        }
        this.typeInference = new WasmTypeInference(context);
    }

    private void accept(Expr expr) {
        expr.acceptVisitor(this);
    }

    private void accept(Statement statement) {
        statement.acceptVisitor(this);
    }

    @Override
    public void visit(BinaryExpr expr) {
        block0 : switch (expr.getOperation()) {
            case ADD: {
                this.generateBinary(WasmIntBinaryOperation.ADD, WasmFloatBinaryOperation.ADD, expr);
                break;
            }
            case SUBTRACT: {
                this.generateBinary(WasmIntBinaryOperation.SUB, WasmFloatBinaryOperation.SUB, expr);
                break;
            }
            case MULTIPLY: {
                this.generateBinary(WasmIntBinaryOperation.MUL, WasmFloatBinaryOperation.MUL, expr);
                break;
            }
            case DIVIDE: {
                this.generateBinary(WasmIntBinaryOperation.DIV_SIGNED, WasmFloatBinaryOperation.DIV, expr);
                break;
            }
            case MODULO: {
                switch (expr.getType()) {
                    case INT: 
                    case LONG: {
                        this.generateBinary(WasmIntBinaryOperation.REM_SIGNED, expr);
                        break block0;
                    }
                }
                Class<?> type = this.convertType(expr.getType());
                MethodReference method = new MethodReference(WasmRuntime.class, "remainder", type, type, type);
                WasmCall call = new WasmCall(WasmMangling.mangleMethod(method), false);
                this.accept(expr.getFirstOperand());
                call.getArguments().add(this.result);
                this.accept(expr.getSecondOperand());
                call.getArguments().add(this.result);
                call.setLocation(expr.getLocation());
                this.result = call;
                break;
            }
            case BITWISE_AND: {
                this.generateBinary(WasmIntBinaryOperation.AND, expr);
                break;
            }
            case BITWISE_OR: {
                this.generateBinary(WasmIntBinaryOperation.OR, expr);
                break;
            }
            case BITWISE_XOR: {
                this.generateBinary(WasmIntBinaryOperation.XOR, expr);
                break;
            }
            case EQUALS: {
                this.generateBinary(WasmIntBinaryOperation.EQ, WasmFloatBinaryOperation.EQ, expr);
                break;
            }
            case NOT_EQUALS: {
                this.generateBinary(WasmIntBinaryOperation.NE, WasmFloatBinaryOperation.NE, expr);
                break;
            }
            case GREATER: {
                this.generateBinary(WasmIntBinaryOperation.GT_SIGNED, WasmFloatBinaryOperation.GT, expr);
                break;
            }
            case GREATER_OR_EQUALS: {
                this.generateBinary(WasmIntBinaryOperation.GE_SIGNED, WasmFloatBinaryOperation.GE, expr);
                break;
            }
            case LESS: {
                this.generateBinary(WasmIntBinaryOperation.LT_SIGNED, WasmFloatBinaryOperation.LT, expr);
                break;
            }
            case LESS_OR_EQUALS: {
                this.generateBinary(WasmIntBinaryOperation.LE_SIGNED, WasmFloatBinaryOperation.LE, expr);
                break;
            }
            case LEFT_SHIFT: {
                this.generateBinary(WasmIntBinaryOperation.SHL, expr);
                break;
            }
            case RIGHT_SHIFT: {
                this.generateBinary(WasmIntBinaryOperation.SHR_SIGNED, expr);
                break;
            }
            case UNSIGNED_RIGHT_SHIFT: {
                this.generateBinary(WasmIntBinaryOperation.SHR_UNSIGNED, expr);
                break;
            }
            case COMPARE: {
                Class<?> type = this.convertType(expr.getType());
                MethodReference method = new MethodReference(WasmRuntime.class, "compare", type, type, Integer.TYPE);
                WasmCall call = new WasmCall(WasmMangling.mangleMethod(method), false);
                this.accept(expr.getFirstOperand());
                call.getArguments().add(this.result);
                this.accept(expr.getSecondOperand());
                call.getArguments().add(this.result);
                call.setLocation(expr.getLocation());
                this.result = call;
                break;
            }
            case AND: {
                this.generateAnd(expr);
                break;
            }
            case OR: {
                this.generateOr(expr);
            }
        }
    }

    private void generateBinary(WasmIntBinaryOperation intOp, WasmFloatBinaryOperation floatOp, BinaryExpr expr) {
        this.accept(expr.getFirstOperand());
        WasmExpression first = this.result;
        this.accept(expr.getSecondOperand());
        WasmExpression second = this.result;
        if (expr.getType() == null) {
            this.result = new WasmIntBinary(WasmIntType.INT32, intOp, first, second);
        } else {
            switch (expr.getType()) {
                case INT: {
                    this.result = new WasmIntBinary(WasmIntType.INT32, intOp, first, second);
                    break;
                }
                case LONG: {
                    this.result = new WasmIntBinary(WasmIntType.INT64, intOp, first, second);
                    break;
                }
                case FLOAT: {
                    this.result = new WasmFloatBinary(WasmFloatType.FLOAT32, floatOp, first, second);
                    break;
                }
                case DOUBLE: {
                    this.result = new WasmFloatBinary(WasmFloatType.FLOAT64, floatOp, first, second);
                }
            }
        }
        this.result.setLocation(expr.getLocation());
    }

    private void generateBinary(WasmIntBinaryOperation intOp, BinaryExpr expr) {
        this.accept(expr.getFirstOperand());
        WasmExpression first = this.result;
        this.accept(expr.getSecondOperand());
        WasmExpression second = this.result;
        if (expr.getType() == OperationType.LONG) {
            switch (expr.getOperation()) {
                case LEFT_SHIFT: 
                case RIGHT_SHIFT: 
                case UNSIGNED_RIGHT_SHIFT: {
                    second = new WasmConversion(WasmType.INT32, WasmType.INT64, false, second);
                    break;
                }
            }
        }
        switch (expr.getType()) {
            case INT: {
                this.result = new WasmIntBinary(WasmIntType.INT32, intOp, first, second);
                break;
            }
            case LONG: {
                this.result = new WasmIntBinary(WasmIntType.INT64, intOp, first, second);
                break;
            }
            case FLOAT: 
            case DOUBLE: {
                throw new AssertionError((Object)("Can't translate operation " + (Object)((Object)intOp) + " for type " + (Object)((Object)expr.getType())));
            }
        }
        this.result.setLocation(expr.getLocation());
    }

    private Class<?> convertType(OperationType type) {
        switch (type) {
            case INT: {
                return Integer.TYPE;
            }
            case LONG: {
                return Long.TYPE;
            }
            case FLOAT: {
                return Float.TYPE;
            }
            case DOUBLE: {
                return Double.TYPE;
            }
        }
        throw new AssertionError((Object)type.toString());
    }

    private void generateAnd(BinaryExpr expr) {
        WasmBlock block = new WasmBlock(false);
        block.setType(WasmType.INT32);
        this.accept(expr.getFirstOperand());
        WasmBranch branch = new WasmBranch(this.negate(this.result), block);
        branch.setResult(new WasmInt32Constant(0));
        branch.setLocation(expr.getLocation());
        branch.getResult().setLocation(expr.getLocation());
        block.getBody().add(new WasmDrop(branch));
        this.accept(expr.getSecondOperand());
        block.getBody().add(this.result);
        block.setLocation(expr.getLocation());
        this.result = block;
    }

    private void generateOr(BinaryExpr expr) {
        WasmBlock block = new WasmBlock(false);
        block.setType(WasmType.INT32);
        this.accept(expr.getFirstOperand());
        WasmBranch branch = new WasmBranch(this.result, block);
        branch.setResult(new WasmInt32Constant(1));
        branch.setLocation(expr.getLocation());
        branch.getResult().setLocation(expr.getLocation());
        block.getBody().add(new WasmDrop(branch));
        this.accept(expr.getSecondOperand());
        block.getBody().add(this.result);
        block.setLocation(expr.getLocation());
        this.result = block;
    }

    @Override
    public void visit(UnaryExpr expr) {
        switch (expr.getOperation()) {
            case INT_TO_BYTE: {
                this.accept(expr.getOperand());
                this.result = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.SHL, this.result, new WasmInt32Constant(24));
                this.result.setLocation(expr.getLocation());
                this.result = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.SHR_SIGNED, this.result, new WasmInt32Constant(24));
                this.result.setLocation(expr.getLocation());
                break;
            }
            case INT_TO_SHORT: {
                this.accept(expr.getOperand());
                this.result = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.SHL, this.result, new WasmInt32Constant(16));
                this.result.setLocation(expr.getLocation());
                this.result = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.SHR_SIGNED, this.result, new WasmInt32Constant(16));
                this.result.setLocation(expr.getLocation());
                break;
            }
            case INT_TO_CHAR: {
                this.accept(expr.getOperand());
                this.result = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.SHL, this.result, new WasmInt32Constant(16));
                this.result.setLocation(expr.getLocation());
                this.result = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.SHR_UNSIGNED, this.result, new WasmInt32Constant(16));
                this.result.setLocation(expr.getLocation());
                break;
            }
            case LENGTH: {
                this.accept(expr.getOperand());
                this.result = this.generateArrayLength(this.result);
                break;
            }
            case NOT: {
                this.accept(expr.getOperand());
                this.result = this.negate(this.result);
                break;
            }
            case NEGATE: {
                this.accept(expr.getOperand());
                switch (expr.getType()) {
                    case INT: {
                        this.result = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.SUB, new WasmInt32Constant(0), this.result);
                        this.result.setLocation(expr.getLocation());
                        break;
                    }
                    case LONG: {
                        this.result = new WasmIntBinary(WasmIntType.INT64, WasmIntBinaryOperation.SUB, new WasmInt64Constant(0L), this.result);
                        this.result.setLocation(expr.getLocation());
                        break;
                    }
                    case FLOAT: {
                        this.result = new WasmFloatBinary(WasmFloatType.FLOAT32, WasmFloatBinaryOperation.SUB, new WasmFloat32Constant(0.0f), this.result);
                        this.result.setLocation(expr.getLocation());
                        break;
                    }
                    case DOUBLE: {
                        this.result = new WasmFloatBinary(WasmFloatType.FLOAT64, WasmFloatBinaryOperation.SUB, new WasmFloat64Constant(0.0), this.result);
                        this.result.setLocation(expr.getLocation());
                    }
                }
                break;
            }
            case NULL_CHECK: {
                this.accept(expr.getOperand());
            }
        }
    }

    private WasmExpression generateArrayLength(WasmExpression array) {
        int sizeOffset = this.classGenerator.getFieldOffset(new FieldReference(RuntimeArray.class.getName(), "size"));
        WasmIntBinary ptr = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.ADD, array, new WasmInt32Constant(sizeOffset));
        ptr.setLocation(array.getLocation());
        WasmLoadInt32 length = new WasmLoadInt32(4, ptr, WasmInt32Subtype.INT32);
        length.setLocation(array.getLocation());
        return length;
    }

    @Override
    public void visit(AssignmentStatement statement) {
        Expr left = statement.getLeftValue();
        if (left == null) {
            this.accept(statement.getRightValue());
            this.result.acceptVisitor(this.typeInference);
            if (this.typeInference.getResult() != null) {
                this.result = new WasmDrop(this.result);
                this.result.setLocation(statement.getLocation());
            }
        } else if (left instanceof VariableExpr) {
            VariableExpr varExpr = (VariableExpr)left;
            WasmLocal local = this.function.getLocalVariables().get(varExpr.getIndex() - this.firstVariable);
            this.accept(statement.getRightValue());
            this.result = new WasmSetLocal(local, this.result);
            this.result.setLocation(statement.getLocation());
        } else if (left instanceof QualificationExpr) {
            QualificationExpr lhs = (QualificationExpr)left;
            this.storeField(lhs.getQualified(), lhs.getField(), statement.getRightValue(), statement.getLocation());
        } else if (left instanceof SubscriptExpr) {
            SubscriptExpr lhs = (SubscriptExpr)left;
            this.storeArrayItem(lhs, statement.getRightValue());
        } else {
            throw new UnsupportedOperationException("This expression is not supported yet");
        }
    }

    private void storeField(Expr qualified, FieldReference field, Expr value, TextLocation location) {
        WasmExpression resultExpr;
        block10: {
            WasmExpression address;
            block9: {
                address = this.getAddress(qualified, field, location);
                ValueType type = this.context.getFieldType(field);
                this.accept(value);
                if (!(type instanceof ValueType.Primitive)) break block9;
                switch (((ValueType.Primitive)type).getKind()) {
                    case BOOLEAN: 
                    case BYTE: {
                        resultExpr = new WasmStoreInt32(1, address, this.result, WasmInt32Subtype.INT8);
                        break block10;
                    }
                    case SHORT: {
                        resultExpr = new WasmStoreInt32(2, address, this.result, WasmInt32Subtype.INT16);
                        break block10;
                    }
                    case CHARACTER: {
                        resultExpr = new WasmStoreInt32(2, address, this.result, WasmInt32Subtype.UINT16);
                        break block10;
                    }
                    case INTEGER: {
                        resultExpr = new WasmStoreInt32(4, address, this.result, WasmInt32Subtype.INT32);
                        break block10;
                    }
                    case LONG: {
                        resultExpr = new WasmStoreInt64(8, address, this.result, WasmInt64Subtype.INT64);
                        break block10;
                    }
                    case FLOAT: {
                        resultExpr = new WasmStoreFloat32(4, address, this.result);
                        break block10;
                    }
                    case DOUBLE: {
                        resultExpr = new WasmStoreFloat64(8, address, this.result);
                        break block10;
                    }
                    default: {
                        throw new AssertionError((Object)type.toString());
                    }
                }
            }
            resultExpr = new WasmStoreInt32(4, address, this.result, WasmInt32Subtype.INT32);
        }
        resultExpr.setOffset(this.getOffset(qualified, field));
        this.result = resultExpr;
        this.result.setLocation(location);
    }

    private void storeArrayItem(SubscriptExpr leftValue, Expr rightValue) {
        WasmExpression ptr = this.getArrayElementPointer(leftValue);
        this.accept(rightValue);
        switch (leftValue.getType()) {
            case BYTE: {
                this.result = new WasmStoreInt32(1, ptr, this.result, WasmInt32Subtype.INT8);
                break;
            }
            case SHORT: {
                this.result = new WasmStoreInt32(2, ptr, this.result, WasmInt32Subtype.INT16);
                break;
            }
            case CHAR: {
                this.result = new WasmStoreInt32(2, ptr, this.result, WasmInt32Subtype.UINT16);
                break;
            }
            case INT: 
            case OBJECT: {
                this.result = new WasmStoreInt32(4, ptr, this.result, WasmInt32Subtype.INT32);
                break;
            }
            case LONG: {
                this.result = new WasmStoreInt64(8, ptr, this.result, WasmInt64Subtype.INT64);
                break;
            }
            case FLOAT: {
                this.result = new WasmStoreFloat32(4, ptr, this.result);
                break;
            }
            case DOUBLE: {
                this.result = new WasmStoreFloat64(8, ptr, this.result);
            }
        }
    }

    @Override
    public void visit(ConditionalExpr expr) {
        this.accept(expr.getCondition());
        WasmConditional conditional = new WasmConditional(this.forCondition(this.result));
        this.accept(expr.getConsequent());
        conditional.getThenBlock().getBody().add(this.result);
        this.result.acceptVisitor(this.typeInference);
        WasmType thenType = this.typeInference.getResult();
        conditional.getThenBlock().setType(thenType);
        this.accept(expr.getAlternative());
        conditional.getElseBlock().getBody().add(this.result);
        this.result.acceptVisitor(this.typeInference);
        WasmType elseType = this.typeInference.getResult();
        conditional.getElseBlock().setType(elseType);
        assert (thenType == elseType);
        conditional.setType(thenType);
        this.result = conditional;
    }

    @Override
    public void visit(SequentialStatement statement) {
        WasmBlock block = new WasmBlock(false);
        for (Statement part : statement.getSequence()) {
            this.accept(part);
            if (this.result == null) continue;
            block.getBody().add(this.result);
        }
        this.result = block;
    }

    @Override
    public void visit(ConstantExpr expr) {
        if (expr.getValue() == null) {
            this.result = new WasmInt32Constant(0);
        } else if (expr.getValue() instanceof Integer) {
            this.result = new WasmInt32Constant((Integer)expr.getValue());
        } else if (expr.getValue() instanceof Long) {
            this.result = new WasmInt64Constant((Long)expr.getValue());
        } else if (expr.getValue() instanceof Float) {
            this.result = new WasmFloat32Constant(((Float)expr.getValue()).floatValue());
        } else if (expr.getValue() instanceof Double) {
            this.result = new WasmFloat64Constant((Double)expr.getValue());
        } else if (expr.getValue() instanceof String) {
            String str = (String)expr.getValue();
            this.result = new WasmInt32Constant(this.context.getStringPool().getStringPointer(str));
        } else if (expr.getValue() instanceof ValueType) {
            int pointer = this.classGenerator.getClassPointer((ValueType)expr.getValue());
            this.result = new WasmInt32Constant(pointer);
        } else {
            throw new IllegalArgumentException("Constant unsupported: " + expr.getValue());
        }
    }

    @Override
    public void visit(ConditionalStatement statement) {
        this.accept(statement.getCondition());
        WasmConditional conditional = new WasmConditional(this.forCondition(this.result));
        for (Statement part : statement.getConsequent()) {
            this.accept(part);
            if (this.result == null) continue;
            conditional.getThenBlock().getBody().add(this.result);
        }
        for (Statement part : statement.getAlternative()) {
            this.accept(part);
            if (this.result == null) continue;
            conditional.getElseBlock().getBody().add(this.result);
        }
        this.result = conditional;
    }

    @Override
    public void visit(VariableExpr expr) {
        this.result = new WasmGetLocal(this.function.getLocalVariables().get(expr.getIndex() - this.firstVariable));
    }

    @Override
    public void visit(SubscriptExpr expr) {
        WasmExpression ptr = this.getArrayElementPointer(expr);
        switch (expr.getType()) {
            case BYTE: {
                this.result = new WasmLoadInt32(1, ptr, WasmInt32Subtype.INT8);
                break;
            }
            case SHORT: {
                this.result = new WasmLoadInt32(2, ptr, WasmInt32Subtype.INT16);
                break;
            }
            case CHAR: {
                this.result = new WasmLoadInt32(2, ptr, WasmInt32Subtype.UINT16);
                break;
            }
            case INT: 
            case OBJECT: {
                this.result = new WasmLoadInt32(4, ptr, WasmInt32Subtype.INT32);
                break;
            }
            case LONG: {
                this.result = new WasmLoadInt64(8, ptr, WasmInt64Subtype.INT64);
                break;
            }
            case FLOAT: {
                this.result = new WasmLoadFloat32(4, ptr);
                break;
            }
            case DOUBLE: {
                this.result = new WasmLoadFloat64(8, ptr);
            }
        }
    }

    private WasmExpression getArrayElementPointer(SubscriptExpr expr) {
        this.accept(expr.getArray());
        WasmExpression array = this.result;
        this.accept(expr.getIndex());
        WasmExpression index = this.result;
        int size = -1;
        switch (expr.getType()) {
            case BYTE: {
                size = 0;
                break;
            }
            case SHORT: 
            case CHAR: {
                size = 1;
                break;
            }
            case INT: 
            case OBJECT: 
            case FLOAT: {
                size = 2;
                break;
            }
            case LONG: 
            case DOUBLE: {
                size = 3;
            }
        }
        int base = this.classGenerator.getClassSize(RuntimeArray.class.getName());
        array = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.ADD, array, new WasmInt32Constant(base));
        if (size != 0) {
            index = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.SHL, index, new WasmInt32Constant(size));
        }
        return new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.ADD, array, index);
    }

    @Override
    public void visit(SwitchStatement statement) {
        int min = statement.getClauses().stream().flatMapToInt(clause -> Arrays.stream(clause.getConditions())).min().orElse(0);
        int max = statement.getClauses().stream().flatMapToInt(clause -> Arrays.stream(clause.getConditions())).max().orElse(0);
        WasmBlock defaultBlock = new WasmBlock(false);
        this.breakTargets.put(statement, defaultBlock);
        IdentifiedStatement oldBreakTarget = this.currentBreakTarget;
        this.currentBreakTarget = statement;
        WasmBlock wrapper = new WasmBlock(false);
        this.accept(statement.getValue());
        WasmExpression condition = this.result;
        WasmBlock initialWrapper = wrapper;
        List<SwitchClause> clauses = statement.getClauses();
        WasmBlock[] targets = new WasmBlock[clauses.size()];
        for (int i = 0; i < clauses.size(); ++i) {
            SwitchClause clause2 = clauses.get(i);
            WasmBlock caseBlock = new WasmBlock(false);
            caseBlock.getBody().add(wrapper);
            targets[i] = wrapper;
            for (Statement part : clause2.getBody()) {
                this.accept(part);
                if (this.result == null) continue;
                caseBlock.getBody().add(this.result);
            }
            wrapper = caseBlock;
        }
        defaultBlock.getBody().add(wrapper);
        for (Statement part : statement.getDefaultClause()) {
            this.accept(part);
            if (this.result == null) continue;
            defaultBlock.getBody().add(this.result);
        }
        WasmBlock defaultTarget = wrapper;
        wrapper = defaultBlock;
        if ((long)max - (long)min >= 256L) {
            this.translateSwitchToBinarySearch(statement, condition, initialWrapper, defaultTarget, targets);
        } else {
            this.translateSwitchToWasmSwitch(statement, condition, initialWrapper, defaultTarget, targets, min, max);
        }
        this.breakTargets.remove(statement);
        this.currentBreakTarget = oldBreakTarget;
        this.result = wrapper;
    }

    private void translateSwitchToBinarySearch(SwitchStatement statement, WasmExpression condition, WasmBlock initialWrapper, WasmBlock defaultTarget, WasmBlock[] targets) {
        ArrayList<TableEntry> entries = new ArrayList<TableEntry>();
        for (int i = 0; i < statement.getClauses().size(); ++i) {
            SwitchClause clause = statement.getClauses().get(i);
            for (int label : clause.getConditions()) {
                entries.add(new TableEntry(label, targets[i]));
            }
        }
        entries.sort(Comparator.comparingInt(entry -> entry.label));
        WasmLocal conditionVar = this.getTemporary(WasmType.INT32);
        initialWrapper.getBody().add(new WasmSetLocal(conditionVar, condition));
        this.generateBinarySearch(entries, 0, entries.size() - 1, initialWrapper, defaultTarget, conditionVar);
    }

    private void generateBinarySearch(List<TableEntry> entries, int lower, int upper, WasmBlock consumer, WasmBlock defaultTarget, WasmLocal conditionVar) {
        if (upper - lower == 0) {
            int label = entries.get((int)lower).label;
            WasmIntBinary condition = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.EQ, new WasmGetLocal(conditionVar), new WasmInt32Constant(label));
            WasmConditional conditional = new WasmConditional(condition);
            consumer.getBody().add(conditional);
            conditional.getThenBlock().getBody().add(new WasmBreak(entries.get((int)lower).target));
            conditional.getElseBlock().getBody().add(new WasmBreak(defaultTarget));
        } else if (upper - lower <= 0) {
            consumer.getBody().add(new WasmBreak(defaultTarget));
        } else {
            int mid = (upper + lower) / 2;
            int label = entries.get((int)mid).label;
            WasmIntBinary condition = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.GT_SIGNED, new WasmGetLocal(conditionVar), new WasmInt32Constant(label));
            WasmConditional conditional = new WasmConditional(condition);
            consumer.getBody().add(conditional);
            this.generateBinarySearch(entries, mid + 1, upper, conditional.getThenBlock(), defaultTarget, conditionVar);
            this.generateBinarySearch(entries, lower, mid, conditional.getElseBlock(), defaultTarget, conditionVar);
        }
    }

    private void translateSwitchToWasmSwitch(SwitchStatement statement, WasmExpression condition, WasmBlock initialWrapper, WasmBlock defaultTarget, WasmBlock[] targets, int min, int max) {
        if (min > 0) {
            condition = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.SUB, condition, new WasmInt32Constant(min));
        }
        WasmSwitch wasmSwitch = new WasmSwitch(condition, initialWrapper);
        initialWrapper.getBody().add(wasmSwitch);
        wasmSwitch.setDefaultTarget(defaultTarget);
        WasmBlock[] expandedTargets = new WasmBlock[max - min + 1];
        for (int i = 0; i < statement.getClauses().size(); ++i) {
            SwitchClause clause = statement.getClauses().get(i);
            for (int label : clause.getConditions()) {
                expandedTargets[label - min] = targets[i];
            }
        }
        for (WasmBlock target : expandedTargets) {
            wasmSwitch.getTargets().add(target != null ? target : wasmSwitch.getDefaultTarget());
        }
    }

    @Override
    public void visit(UnwrapArrayExpr expr) {
        this.accept(expr.getArray());
    }

    @Override
    public void visit(WhileStatement statement) {
        WasmBlock wrapper = new WasmBlock(false);
        WasmBlock loop = new WasmBlock(true);
        this.continueTargets.put(statement, loop);
        this.breakTargets.put(statement, wrapper);
        IdentifiedStatement oldBreakTarget = this.currentBreakTarget;
        IdentifiedStatement oldContinueTarget = this.currentContinueTarget;
        this.currentBreakTarget = statement;
        this.currentContinueTarget = statement;
        if (statement.getCondition() != null) {
            this.accept(statement.getCondition());
            loop.getBody().add(new WasmBranch(this.negate(this.result), wrapper));
            this.usedBlocks.add(wrapper);
        }
        for (Statement part : statement.getBody()) {
            this.accept(part);
            if (this.result == null) continue;
            loop.getBody().add(this.result);
        }
        loop.getBody().add(new WasmBreak(loop));
        this.currentBreakTarget = oldBreakTarget;
        this.currentContinueTarget = oldContinueTarget;
        this.continueTargets.remove(statement);
        this.breakTargets.remove(statement);
        if (this.usedBlocks.contains(wrapper)) {
            wrapper.getBody().add(loop);
            this.result = wrapper;
        } else {
            this.result = loop;
        }
    }

    @Override
    public void visit(InvocationExpr expr) {
        WasmIntrinsic intrinsic;
        if (expr.getMethod().getClassName().equals(ShadowStack.class.getName())) {
            switch (expr.getMethod().getName()) {
                case "allocStack": {
                    this.generateAllocStack(expr.getArguments().get(0));
                    return;
                }
                case "releaseStack": {
                    this.generateReleaseStack();
                    return;
                }
                case "registerGCRoot": {
                    this.generateRegisterGcRoot(expr.getArguments().get(0), expr.getArguments().get(1));
                    return;
                }
                case "removeGCRoot": {
                    this.generateRemoveGcRoot(expr.getArguments().get(0));
                    return;
                }
                case "registerCallSite": {
                    this.generateRegisterCallSite(expr.getArguments().get(0));
                    return;
                }
                case "getExceptionHandlerId": {
                    this.generateGetHandlerId();
                    return;
                }
            }
        }
        if ((intrinsic = this.context.getIntrinsic(expr.getMethod())) != null) {
            this.result = intrinsic.apply(expr, this.intrinsicManager);
            return;
        }
        if (expr.getType() == InvocationType.STATIC || expr.getType() == InvocationType.SPECIAL) {
            String methodName = WasmMangling.mangleMethod(expr.getMethod());
            WasmCall call = new WasmCall(methodName);
            if (this.context.getImportedMethod(expr.getMethod()) != null) {
                call.setImported(true);
            }
            for (Expr argument : expr.getArguments()) {
                this.accept(argument);
                call.getArguments().add(this.result);
            }
            this.result = call;
        } else if (expr.getType() == InvocationType.CONSTRUCTOR) {
            WasmBlock block = new WasmBlock(false);
            block.setType(WasmType.INT32);
            WasmLocal tmp = this.getTemporary(WasmType.INT32);
            block.getBody().add(new WasmSetLocal(tmp, this.allocateObject(expr.getMethod().getClassName(), expr.getLocation())));
            String methodName = WasmMangling.mangleMethod(expr.getMethod());
            WasmCall call = new WasmCall(methodName);
            call.getArguments().add(new WasmGetLocal(tmp));
            for (Expr argument : expr.getArguments()) {
                this.accept(argument);
                call.getArguments().add(this.result);
            }
            block.getBody().add(call);
            block.getBody().add(new WasmGetLocal(tmp));
            this.releaseTemporary(tmp);
            this.result = block;
        } else {
            int i;
            this.accept(expr.getArguments().get(0));
            WasmExpression instance = this.result;
            WasmBlock block = new WasmBlock(false);
            block.setType(WasmGeneratorUtil.mapType(expr.getMethod().getReturnType()));
            WasmLocal instanceVar = this.getTemporary(WasmType.INT32);
            block.getBody().add(new WasmSetLocal(instanceVar, instance));
            instance = new WasmGetLocal(instanceVar);
            int vtableOffset = this.classGenerator.getClassSize(RuntimeClass.class.getName());
            VirtualTableEntry vtableEntry = this.context.getVirtualTableProvider().lookup(expr.getMethod());
            if (vtableEntry == null) {
                this.result = new WasmUnreachable();
                return;
            }
            WasmExpression methodIndex = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.ADD, this.getReferenceToClass(instance), new WasmInt32Constant(vtableEntry.getIndex() * 4 + vtableOffset));
            methodIndex = new WasmLoadInt32(4, methodIndex, WasmInt32Subtype.INT32);
            WasmIndirectCall call = new WasmIndirectCall(methodIndex);
            call.getParameterTypes().add(WasmType.INT32);
            for (i = 0; i < expr.getMethod().parameterCount(); ++i) {
                call.getParameterTypes().add(WasmGeneratorUtil.mapType(expr.getMethod().parameterType(i)));
            }
            if (expr.getMethod().getReturnType() != ValueType.VOID) {
                call.setReturnType(WasmGeneratorUtil.mapType(expr.getMethod().getReturnType()));
            }
            call.getArguments().add(instance);
            for (i = 1; i < expr.getArguments().size(); ++i) {
                this.accept(expr.getArguments().get(i));
                call.getArguments().add(this.result);
            }
            block.getBody().add(call);
            this.releaseTemporary(instanceVar);
            this.result = block;
        }
    }

    private void generateAllocStack(Expr sizeExpr) {
        if (this.stackVariable != null) {
            throw new IllegalStateException("Call to ShadowStack.allocStack must be done only once");
        }
        this.stackVariable = this.getTemporary(WasmType.INT32);
        this.stackVariable.setName("__stack__");
        InvocationExpr expr = new InvocationExpr();
        expr.setType(InvocationType.SPECIAL);
        expr.setMethod(new MethodReference(WasmRuntime.class, "allocStack", Integer.TYPE, Address.class));
        expr.getArguments().add(sizeExpr);
        expr.acceptVisitor(this);
        this.result = new WasmSetLocal(this.stackVariable, this.result);
    }

    private void generateReleaseStack() {
        if (this.stackVariable == null) {
            throw new IllegalStateException("Call to ShadowStack.releaseStack must be dominated by Mutator.allocStack");
        }
        int offset = this.classGenerator.getFieldOffset(new FieldReference(WasmRuntime.class.getName(), "stack"));
        WasmExpression oldValue = new WasmGetLocal(this.stackVariable);
        oldValue = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.SUB, oldValue, new WasmInt32Constant(4));
        this.result = new WasmStoreInt32(4, new WasmInt32Constant(offset), oldValue, WasmInt32Subtype.INT32);
    }

    private void generateRegisterCallSite(Expr callSiteExpr) {
        if (this.stackVariable == null) {
            throw new IllegalStateException("Call to ShadowStack.registerCallSite must be dominated by Mutator.allocStack");
        }
        callSiteExpr.acceptVisitor(this);
        WasmExpression callSite = this.result;
        this.result = new WasmStoreInt32(4, new WasmGetLocal(this.stackVariable), callSite, WasmInt32Subtype.INT32);
    }

    private void generateGetHandlerId() {
        if (this.stackVariable == null) {
            throw new IllegalStateException("Call to ShadowStack.getHandlerId must be dominated by Mutator.allocStack");
        }
        this.result = new WasmLoadInt32(4, new WasmGetLocal(this.stackVariable), WasmInt32Subtype.INT32);
    }

    private void generateRegisterGcRoot(Expr slotExpr, Expr gcRootExpr) {
        if (this.stackVariable == null) {
            throw new IllegalStateException("Call to ShadowStack.registerGCRoot must be dominated by Mutator.allocStack");
        }
        slotExpr.acceptVisitor(this);
        WasmExpression slotOffset = this.getSlotOffset(this.result);
        WasmExpression address = new WasmGetLocal(this.stackVariable);
        if (!(slotOffset instanceof WasmInt32Constant)) {
            address = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.ADD, address, slotOffset);
        }
        gcRootExpr.acceptVisitor(this);
        WasmExpression gcRoot = this.result;
        WasmStoreInt32 store = new WasmStoreInt32(4, address, gcRoot, WasmInt32Subtype.INT32);
        if (slotOffset instanceof WasmInt32Constant) {
            store.setOffset(((WasmInt32Constant)slotOffset).getValue());
        }
        this.result = store;
    }

    private void generateRemoveGcRoot(Expr slotExpr) {
        if (this.stackVariable == null) {
            throw new IllegalStateException("Call to ShadowStack.removeGCRoot must be dominated by Mutator.allocStack");
        }
        slotExpr.acceptVisitor(this);
        WasmExpression slotOffset = this.getSlotOffset(this.result);
        WasmExpression address = new WasmGetLocal(this.stackVariable);
        if (!(slotOffset instanceof WasmInt32Constant)) {
            address = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.ADD, address, slotOffset);
        }
        WasmStoreInt32 store = new WasmStoreInt32(4, address, new WasmInt32Constant(0), WasmInt32Subtype.INT32);
        if (slotOffset instanceof WasmInt32Constant) {
            store.setOffset(((WasmInt32Constant)slotOffset).getValue());
        }
        this.result = store;
    }

    private WasmExpression getSlotOffset(WasmExpression slot) {
        if (slot instanceof WasmInt32Constant) {
            int slotConstant = ((WasmInt32Constant)slot).getValue();
            return new WasmInt32Constant((slotConstant << 2) + 4);
        }
        slot = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.SHL, slot, new WasmInt32Constant(2));
        slot = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.ADD, slot, new WasmInt32Constant(4));
        return slot;
    }

    @Override
    public void visit(BlockStatement statement) {
        WasmBlock block = new WasmBlock(false);
        if (statement.getId() != null) {
            this.breakTargets.put(statement, block);
        }
        for (Statement part : statement.getBody()) {
            this.accept(part);
            if (this.result == null) continue;
            block.getBody().add(this.result);
        }
        if (statement.getId() != null) {
            this.breakTargets.remove(statement);
        }
        this.result = block;
    }

    @Override
    public void visit(QualificationExpr expr) {
        WasmExpression resultExpr;
        block10: {
            WasmExpression address;
            block9: {
                address = this.getAddress(expr.getQualified(), expr.getField(), expr.getLocation());
                ValueType type = this.context.getFieldType(expr.getField());
                if (!(type instanceof ValueType.Primitive)) break block9;
                switch (((ValueType.Primitive)type).getKind()) {
                    case BOOLEAN: 
                    case BYTE: {
                        resultExpr = new WasmLoadInt32(1, address, WasmInt32Subtype.INT8);
                        break block10;
                    }
                    case SHORT: {
                        resultExpr = new WasmLoadInt32(2, address, WasmInt32Subtype.INT16);
                        break block10;
                    }
                    case CHARACTER: {
                        resultExpr = new WasmLoadInt32(2, address, WasmInt32Subtype.UINT16);
                        break block10;
                    }
                    case INTEGER: {
                        resultExpr = new WasmLoadInt32(4, address, WasmInt32Subtype.INT32);
                        break block10;
                    }
                    case LONG: {
                        resultExpr = new WasmLoadInt64(8, address, WasmInt64Subtype.INT64);
                        break block10;
                    }
                    case FLOAT: {
                        resultExpr = new WasmLoadFloat32(4, address);
                        break block10;
                    }
                    case DOUBLE: {
                        resultExpr = new WasmLoadFloat64(8, address);
                        break block10;
                    }
                    default: {
                        throw new AssertionError((Object)type.toString());
                    }
                }
            }
            resultExpr = new WasmLoadInt32(4, address, WasmInt32Subtype.INT32);
        }
        resultExpr.setOffset(this.getOffset(expr.getQualified(), expr.getField()));
        this.result = resultExpr;
    }

    private WasmExpression getAddress(Expr qualified, FieldReference field, TextLocation location) {
        if (qualified == null) {
            int offset = this.classGenerator.getFieldOffset(field);
            WasmInt32Constant result = new WasmInt32Constant(offset);
            result.setLocation(location);
            return result;
        }
        this.accept(qualified);
        return this.result;
    }

    private int getOffset(Expr qualified, FieldReference field) {
        if (qualified == null) {
            return 0;
        }
        return this.classGenerator.getFieldOffset(field);
    }

    @Override
    public void visit(BreakStatement statement) {
        IdentifiedStatement target = statement.getTarget();
        if (target == null) {
            target = this.currentBreakTarget;
        }
        WasmBlock wasmTarget = this.breakTargets.get(target);
        this.usedBlocks.add(wasmTarget);
        this.result = new WasmBreak(wasmTarget);
        this.result.setLocation(statement.getLocation());
    }

    @Override
    public void visit(ContinueStatement statement) {
        IdentifiedStatement target = statement.getTarget();
        if (target == null) {
            target = this.currentContinueTarget;
        }
        WasmBlock wasmTarget = this.continueTargets.get(target);
        this.usedBlocks.add(wasmTarget);
        this.result = new WasmBreak(wasmTarget);
        this.result.setLocation(statement.getLocation());
    }

    @Override
    public void visit(NewExpr expr) {
        this.result = this.allocateObject(expr.getConstructedClass(), expr.getLocation());
    }

    private WasmExpression allocateObject(String className, TextLocation location) {
        int tag = this.classGenerator.getClassPointer(ValueType.object(className));
        String allocName = WasmMangling.mangleMethod(new MethodReference(Allocator.class, "allocate", RuntimeClass.class, Address.class));
        WasmCall call = new WasmCall(allocName);
        call.getArguments().add(new WasmInt32Constant(tag));
        call.setLocation(location);
        return call;
    }

    @Override
    public void visit(NewArrayExpr expr) {
        ValueType type = expr.getType();
        int classPointer = this.classGenerator.getClassPointer(ValueType.arrayOf(type));
        String allocName = WasmMangling.mangleMethod(new MethodReference(Allocator.class, "allocateArray", RuntimeClass.class, Integer.TYPE, Address.class));
        WasmCall call = new WasmCall(allocName);
        call.getArguments().add(new WasmInt32Constant(classPointer));
        this.accept(expr.getLength());
        call.getArguments().add(this.result);
        call.setLocation(expr.getLocation());
        this.result = call;
    }

    @Override
    public void visit(NewMultiArrayExpr expr) {
        ValueType type = expr.getType();
        WasmBlock block = new WasmBlock(false);
        block.setType(WasmType.INT32);
        int dimensionList = -1;
        for (Expr dimension : expr.getDimensions()) {
            int dimensionAddress = this.binaryWriter.append(DataPrimitives.INT.createValue());
            if (dimensionList < 0) {
                dimensionList = dimensionAddress;
            }
            this.accept(dimension);
            block.getBody().add(new WasmStoreInt32(4, new WasmInt32Constant(dimensionAddress), this.result, WasmInt32Subtype.INT32));
        }
        int classPointer = this.classGenerator.getClassPointer(ValueType.arrayOf(type));
        String allocName = WasmMangling.mangleMethod(new MethodReference(Allocator.class, "allocateMultiArray", RuntimeClass.class, Address.class, Integer.TYPE, RuntimeArray.class));
        WasmCall call = new WasmCall(allocName);
        call.getArguments().add(new WasmInt32Constant(classPointer));
        call.getArguments().add(new WasmInt32Constant(dimensionList));
        call.getArguments().add(new WasmInt32Constant(expr.getDimensions().size()));
        call.setLocation(expr.getLocation());
        block.getBody().add(call);
        this.result = block;
    }

    @Override
    public void visit(ReturnStatement statement) {
        if (statement.getResult() != null) {
            this.accept(statement.getResult());
        } else {
            this.result = null;
        }
        this.result = new WasmReturn(this.result);
        this.result.setLocation(statement.getLocation());
    }

    @Override
    public void visit(InstanceOfExpr expr) {
        WasmLocal tagVar;
        WasmBlock block;
        this.accept(expr.getExpr());
        if (expr.getType() instanceof ValueType.Object) {
            ValueType.Object cls = (ValueType.Object)expr.getType();
            List<TagRegistry.Range> ranges = this.context.getTagRegistry().getRanges(cls.getClassName());
            ranges.sort(Comparator.comparingInt(range -> range.lower));
            block = new WasmBlock(false);
            block.setType(WasmType.INT32);
            block.setLocation(expr.getLocation());
            tagVar = this.getTemporary(WasmType.INT32);
            int tagOffset = this.classGenerator.getFieldOffset(tagField);
            WasmIntBinary tagPtr = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.ADD, this.getReferenceToClass(this.result), new WasmInt32Constant(tagOffset));
            block.getBody().add(new WasmSetLocal(tagVar, new WasmLoadInt32(4, tagPtr, WasmInt32Subtype.INT32)));
            WasmIntBinary lowerThanMinCond = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.LT_SIGNED, new WasmGetLocal(tagVar), new WasmInt32Constant(ranges.get((int)0).lower));
            WasmBranch lowerThanMin = new WasmBranch(lowerThanMinCond, block);
            lowerThanMin.setResult(new WasmInt32Constant(0));
            block.getBody().add(new WasmDrop(lowerThanMin));
            WasmIntBinary upperThanMaxCond = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.GT_SIGNED, new WasmGetLocal(tagVar), new WasmInt32Constant(ranges.get((int)(ranges.size() - 1)).upper));
            WasmBranch upperThanMax = new WasmBranch(upperThanMaxCond, block);
            upperThanMax.setResult(new WasmInt32Constant(0));
            block.getBody().add(new WasmDrop(upperThanMax));
            for (int i = 1; i < ranges.size(); ++i) {
                WasmIntBinary upperThanExcluded = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.GT_SIGNED, new WasmGetLocal(tagVar), new WasmInt32Constant(ranges.get((int)(i - 1)).upper));
                WasmConditional conditional = new WasmConditional(upperThanExcluded);
                WasmIntBinary lowerThanExcluded = new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.LT_SIGNED, new WasmGetLocal(tagVar), new WasmInt32Constant(ranges.get((int)i).lower));
                WasmBranch branch = new WasmBranch(lowerThanExcluded, block);
                branch.setResult(new WasmInt32Constant(0));
                conditional.getThenBlock().getBody().add(new WasmDrop(branch));
                block.getBody().add(conditional);
            }
        } else {
            if (expr.getType() instanceof ValueType.Array) {
                throw new UnsupportedOperationException();
            }
            throw new AssertionError();
        }
        block.getBody().add(new WasmInt32Constant(1));
        this.releaseTemporary(tagVar);
        this.result = block;
    }

    @Override
    public void visit(ThrowStatement statement) {
        WasmBlock block = new WasmBlock(false);
        block.setLocation(statement.getLocation());
        this.accept(statement.getException());
        block.getBody().add(this.result);
        block.getBody().add(new WasmUnreachable());
        this.result = block;
    }

    @Override
    public void visit(CastExpr expr) {
        this.accept(expr.getValue());
    }

    @Override
    public void visit(InitClassStatement statement) {
        if (this.classGenerator.hasClinit(statement.getClassName())) {
            this.result = new WasmCall(WasmMangling.mangleInitializer(statement.getClassName()));
            this.result.setLocation(statement.getLocation());
        } else {
            this.result = null;
        }
    }

    @Override
    public void visit(PrimitiveCastExpr expr) {
        this.accept(expr.getValue());
        this.result = new WasmConversion(WasmGeneratorUtil.mapType(expr.getSource()), WasmGeneratorUtil.mapType(expr.getTarget()), true, this.result);
        this.result.setLocation(expr.getLocation());
    }

    @Override
    public void visit(TryCatchStatement statement) {
        WasmBlock block = new WasmBlock(false);
        for (Statement bodyPart : statement.getProtectedBody()) {
            this.accept(bodyPart);
            if (this.result == null) continue;
            block.getBody().add(this.result);
        }
        this.result = block;
    }

    @Override
    public void visit(GotoPartStatement statement) {
    }

    @Override
    public void visit(MonitorEnterStatement statement) {
    }

    @Override
    public void visit(MonitorExitStatement statement) {
    }

    private WasmExpression negate(WasmExpression expr) {
        WasmFloatBinary binary;
        WasmFloatBinaryOperation negatedOp;
        if (expr instanceof WasmIntBinary) {
            WasmIntBinaryOperation negatedOp2;
            WasmIntBinary binary2 = (WasmIntBinary)expr;
            if (binary2.getType() == WasmIntType.INT32 && binary2.getOperation() == WasmIntBinaryOperation.XOR) {
                if (this.isOne(binary2.getFirst())) {
                    return binary2.getSecond();
                }
                if (this.isOne(binary2.getSecond())) {
                    return binary2.getFirst();
                }
            }
            if ((negatedOp2 = this.negate(binary2.getOperation())) != null) {
                return new WasmIntBinary(binary2.getType(), negatedOp2, binary2.getFirst(), binary2.getSecond());
            }
        } else if (expr instanceof WasmFloatBinary && (negatedOp = this.negate((binary = (WasmFloatBinary)expr).getOperation())) != null) {
            return new WasmFloatBinary(binary.getType(), negatedOp, binary.getFirst(), binary.getSecond());
        }
        return new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.XOR, expr, new WasmInt32Constant(1));
    }

    private boolean isOne(WasmExpression expression) {
        return expression instanceof WasmInt32Constant && ((WasmInt32Constant)expression).getValue() == 1;
    }

    private boolean isZero(WasmExpression expression) {
        return expression instanceof WasmInt32Constant && ((WasmInt32Constant)expression).getValue() == 0;
    }

    private boolean isBoolean(WasmExpression expression) {
        if (expression instanceof WasmIntBinary) {
            WasmIntBinary binary = (WasmIntBinary)expression;
            switch (binary.getOperation()) {
                case EQ: 
                case NE: 
                case LT_SIGNED: 
                case LT_UNSIGNED: 
                case LE_SIGNED: 
                case LE_UNSIGNED: 
                case GT_SIGNED: 
                case GT_UNSIGNED: 
                case GE_SIGNED: 
                case GE_UNSIGNED: {
                    return true;
                }
            }
            return false;
        }
        if (expression instanceof WasmFloatBinary) {
            WasmFloatBinary binary = (WasmFloatBinary)expression;
            switch (binary.getOperation()) {
                case EQ: 
                case NE: 
                case LT: 
                case LE: 
                case GT: 
                case GE: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private WasmExpression forCondition(WasmExpression expression) {
        if (expression instanceof WasmIntBinary) {
            WasmIntBinary binary = (WasmIntBinary)expression;
            switch (binary.getOperation()) {
                case EQ: {
                    if (this.isZero(binary.getFirst()) && this.isBoolean(binary.getSecond())) {
                        return this.negate(binary.getSecond());
                    }
                    if (!this.isZero(binary.getSecond()) || !this.isBoolean(binary.getFirst())) break;
                    return this.negate(binary.getFirst());
                }
                case NE: {
                    if (this.isZero(binary.getFirst()) && this.isBoolean(binary.getSecond())) {
                        return binary.getSecond();
                    }
                    if (!this.isZero(binary.getSecond()) || !this.isBoolean(binary.getFirst())) break;
                    return binary.getFirst();
                }
            }
        }
        return expression;
    }

    private WasmIntBinaryOperation negate(WasmIntBinaryOperation op) {
        switch (op) {
            case EQ: {
                return WasmIntBinaryOperation.NE;
            }
            case NE: {
                return WasmIntBinaryOperation.EQ;
            }
            case LT_SIGNED: {
                return WasmIntBinaryOperation.GE_SIGNED;
            }
            case LT_UNSIGNED: {
                return WasmIntBinaryOperation.GE_UNSIGNED;
            }
            case LE_SIGNED: {
                return WasmIntBinaryOperation.GT_SIGNED;
            }
            case LE_UNSIGNED: {
                return WasmIntBinaryOperation.GT_UNSIGNED;
            }
            case GT_SIGNED: {
                return WasmIntBinaryOperation.LE_SIGNED;
            }
            case GT_UNSIGNED: {
                return WasmIntBinaryOperation.LE_UNSIGNED;
            }
            case GE_SIGNED: {
                return WasmIntBinaryOperation.LT_SIGNED;
            }
            case GE_UNSIGNED: {
                return WasmIntBinaryOperation.LT_UNSIGNED;
            }
        }
        return null;
    }

    private WasmFloatBinaryOperation negate(WasmFloatBinaryOperation op) {
        switch (op) {
            case EQ: {
                return WasmFloatBinaryOperation.NE;
            }
            case NE: {
                return WasmFloatBinaryOperation.EQ;
            }
            case LT: {
                return WasmFloatBinaryOperation.GE;
            }
            case LE: {
                return WasmFloatBinaryOperation.GT;
            }
            case GT: {
                return WasmFloatBinaryOperation.LE;
            }
            case GE: {
                return WasmFloatBinaryOperation.LT;
            }
        }
        return null;
    }

    private WasmLocal getTemporary(WasmType type) {
        Deque<WasmLocal> stack = this.temporaryVariablesByType.get(type.ordinal());
        WasmLocal variable = stack.pollFirst();
        if (variable == null) {
            variable = new WasmLocal(type);
            this.function.add(variable);
        }
        return variable;
    }

    private void releaseTemporary(WasmLocal variable) {
        Deque<WasmLocal> stack = this.temporaryVariablesByType.get(variable.getType().ordinal());
        stack.push(variable);
    }

    private WasmExpression getReferenceToClass(WasmExpression instance) {
        WasmLoadInt32 classIndex = new WasmLoadInt32(4, instance, WasmInt32Subtype.INT32);
        return new WasmIntBinary(WasmIntType.INT32, WasmIntBinaryOperation.SHL, classIndex, new WasmInt32Constant(3));
    }

    static class TableEntry {
        final int label;
        final WasmBlock target;

        TableEntry(int label, WasmBlock target) {
            this.label = label;
            this.target = target;
        }
    }
}

