/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.generate;

import org.teavm.dependency.AbstractDependencyListener;
import org.teavm.dependency.DependencyAgent;
import org.teavm.dependency.MethodDependency;
import org.teavm.diagnostics.Diagnostics;
import org.teavm.interop.DelegateTo;
import org.teavm.interop.Export;
import org.teavm.model.AnnotationHolder;
import org.teavm.model.AnnotationReader;
import org.teavm.model.CallLocation;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderTransformer;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.ElementModifier;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReader;

public class WasmDependencyListener
extends AbstractDependencyListener
implements ClassHolderTransformer {
    @Override
    public void classReached(DependencyAgent agent, String className, CallLocation location) {
        super.classReached(agent, className, location);
        for (MethodReader methodReader : agent.getClassSource().get(className).getMethods()) {
            AnnotationReader annotation = methodReader.getAnnotations().get(Export.class.getName());
            if (annotation == null) continue;
            agent.linkMethod(methodReader.getReference(), null).use();
        }
    }

    @Override
    public void methodReached(DependencyAgent agent, MethodDependency method, CallLocation location) {
        AnnotationReader delegateAnnot = method.getMethod().getAnnotations().get(DelegateTo.class.getName());
        if (delegateAnnot != null) {
            String delegateMethodName = delegateAnnot.getValue("value").getString();
            ClassReader cls = agent.getClassSource().get(method.getReference().getClassName());
            for (MethodReader methodReader : cls.getMethods()) {
                if (!methodReader.getName().equals(delegateMethodName) || methodReader == method.getMethod()) continue;
                agent.linkMethod(methodReader.getReference(), location).use();
            }
        }
    }

    @Override
    public void transformClass(ClassHolder cls, ClassReaderSource innerSource, Diagnostics diagnostics) {
        for (MethodHolder method : cls.getMethods()) {
            AnnotationHolder delegateAnnot = method.getAnnotations().get(DelegateTo.class.getName());
            if (delegateAnnot == null) continue;
            method.setProgram(null);
            method.getModifiers().add(ElementModifier.NATIVE);
        }
    }
}

