/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.javascript;

import org.teavm.diagnostics.Diagnostics;
import org.teavm.model.BasicBlock;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderTransformer;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.Instruction;
import org.teavm.model.MethodHolder;
import org.teavm.model.Program;
import org.teavm.model.Variable;
import org.teavm.model.instructions.InvocationType;
import org.teavm.model.instructions.InvokeInstruction;
import org.teavm.model.instructions.NullCheckInstruction;

public class NullPointerExceptionTransformer
implements ClassHolderTransformer {
    @Override
    public void transformClass(ClassHolder cls, ClassReaderSource innerSource, Diagnostics diagnostics) {
        for (MethodHolder method : cls.getMethods()) {
            Program program = method.getProgram();
            if (program == null) continue;
            for (int i = 0; i < program.basicBlockCount(); ++i) {
                BasicBlock block = program.basicBlockAt(i);
                this.transformBlock(block);
            }
        }
    }

    private void transformBlock(BasicBlock block) {
        for (Instruction insn : block) {
            InvokeInstruction invoke;
            if (!(insn instanceof InvokeInstruction) || (invoke = (InvokeInstruction)insn).getType() != InvocationType.VIRTUAL) continue;
            NullCheckInstruction nullCheck = new NullCheckInstruction();
            nullCheck.setValue(invoke.getInstance());
            Variable var = block.getProgram().createVariable();
            nullCheck.setReceiver(var);
            invoke.setInstance(var);
            insn.insertPrevious(nullCheck);
        }
    }
}

