/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.parsing;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.JSRInlinerAdapter;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;
import org.teavm.model.AccessLevel;
import org.teavm.model.AnnotationContainer;
import org.teavm.model.AnnotationHolder;
import org.teavm.model.AnnotationValue;
import org.teavm.model.ClassHolder;
import org.teavm.model.ElementHolder;
import org.teavm.model.ElementModifier;
import org.teavm.model.FieldHolder;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodHolder;
import org.teavm.model.Program;
import org.teavm.model.ValueType;
import org.teavm.optimization.UnreachableBasicBlockEliminator;
import org.teavm.parsing.ProgramParser;
import org.teavm.parsing.SSATransformer;

public final class Parser {
    private Parser() {
    }

    public static MethodHolder parseMethod(MethodNode node, String className, String fileName) {
        MethodNode nodeWithoutJsr = new MethodNode(327680, node.access, node.name, node.desc, node.signature, node.exceptions.toArray(new String[0]));
        JSRInlinerAdapter adapter = new JSRInlinerAdapter((MethodVisitor)nodeWithoutJsr, node.access, node.name, node.desc, node.signature, node.exceptions.toArray(new String[0]));
        node.accept((MethodVisitor)adapter);
        node = nodeWithoutJsr;
        ValueType[] signature = MethodDescriptor.parseSignature(node.desc);
        MethodHolder method = new MethodHolder(node.name, signature);
        Parser.parseModifiers(node.access, method);
        ProgramParser programParser = new ProgramParser();
        programParser.setFileName(fileName);
        Program program = programParser.parse(node, className);
        new UnreachableBasicBlockEliminator().optimize(program);
        SSATransformer ssaProducer = new SSATransformer();
        ssaProducer.transformToSSA(program, programParser, method.getParameterTypes());
        method.setProgram(program);
        Parser.parseAnnotations(method.getAnnotations(), node.visibleAnnotations, node.invisibleAnnotations);
        while (program.variableCount() <= method.parameterCount()) {
            program.createVariable();
        }
        if (node.annotationDefault != null) {
            method.setAnnotationDefault(Parser.parseAnnotationValue(node.annotationDefault));
        }
        for (int i = 0; i < method.parameterCount(); ++i) {
            Parser.parseAnnotations(method.parameterAnnotation(i), node.visibleParameterAnnotations != null ? node.visibleParameterAnnotations[i] : null, node.invisibleParameterAnnotations != null ? node.invisibleParameterAnnotations[i] : null);
        }
        return method;
    }

    public static ClassHolder parseClass(ClassNode node) {
        ClassHolder cls = new ClassHolder(node.name.replace('/', '.'));
        Parser.parseModifiers(node.access, cls);
        if (node.superName != null) {
            cls.setParent(node.superName.replace('/', '.'));
        }
        if (cls.getName().equals("java.lang.Object")) {
            cls.setParent(null);
        }
        if (node.interfaces != null) {
            for (String iface : node.interfaces) {
                cls.getInterfaces().add(iface.replace('/', '.'));
            }
        }
        for (Object obj : node.fields) {
            FieldNode fieldNode = (FieldNode)obj;
            cls.addField(Parser.parseField(fieldNode));
        }
        String fullFileName = node.name.substring(0, node.name.lastIndexOf(47) + 1) + node.sourceFile;
        for (MethodNode methodNode : node.methods) {
            cls.addMethod(Parser.parseMethod(methodNode, node.name, fullFileName));
        }
        if (node.outerClass != null) {
            cls.setOwnerName(node.outerClass.replace('/', '.'));
        } else {
            int lastIndex = node.name.lastIndexOf(36);
            if (lastIndex != -1) {
                cls.setOwnerName(node.name.substring(0, lastIndex).replace('/', '.'));
            }
        }
        Parser.parseAnnotations(cls.getAnnotations(), node.visibleAnnotations, node.invisibleAnnotations);
        return cls;
    }

    public static FieldHolder parseField(FieldNode node) {
        FieldHolder field = new FieldHolder(node.name);
        field.setType(ValueType.parse(node.desc));
        field.setInitialValue(node.value);
        Parser.parseModifiers(node.access, field);
        Parser.parseAnnotations(field.getAnnotations(), node.visibleAnnotations, node.invisibleAnnotations);
        return field;
    }

    public static void parseModifiers(int access, ElementHolder member) {
        if ((access & 2) != 0) {
            member.setLevel(AccessLevel.PRIVATE);
        } else if ((access & 4) != 0) {
            member.setLevel(AccessLevel.PROTECTED);
        } else if ((access & 1) != 0) {
            member.setLevel(AccessLevel.PUBLIC);
        }
        if ((access & 0x400) != 0) {
            member.getModifiers().add(ElementModifier.ABSTRACT);
        }
        if ((access & 0x2000) != 0) {
            member.getModifiers().add(ElementModifier.ANNOTATION);
        }
        if ((access & 0x40) != 0) {
            member.getModifiers().add(ElementModifier.BRIDGE);
        }
        if ((access & 0x20000) != 0) {
            member.getModifiers().add(ElementModifier.DEPRECATED);
        }
        if ((access & 0x4000) != 0) {
            member.getModifiers().add(ElementModifier.ENUM);
        }
        if ((access & 0x10) != 0) {
            member.getModifiers().add(ElementModifier.FINAL);
        }
        if ((access & 0x200) != 0) {
            member.getModifiers().add(ElementModifier.INTERFACE);
        }
        if ((access & 0x100) != 0) {
            member.getModifiers().add(ElementModifier.NATIVE);
        }
        if ((access & 8) != 0) {
            member.getModifiers().add(ElementModifier.STATIC);
        }
        if ((access & 0x800) != 0) {
            member.getModifiers().add(ElementModifier.STRICT);
        }
        if ((access & 0x20) != 0) {
            member.getModifiers().add(ElementModifier.SUPER);
        }
        if ((access & 0x20) != 0) {
            member.getModifiers().add(ElementModifier.SYNCHRONIZED);
        }
        if ((access & 0x1000) != 0) {
            member.getModifiers().add(ElementModifier.SYNTHETIC);
        }
        if ((access & 0x80) != 0) {
            member.getModifiers().add(ElementModifier.TRANSIENT);
        }
        if ((access & 0x80) != 0) {
            member.getModifiers().add(ElementModifier.VARARGS);
        }
        if ((access & 0x40) != 0) {
            member.getModifiers().add(ElementModifier.VOLATILE);
        }
    }

    private static void parseAnnotations(AnnotationContainer annotations, List<AnnotationNode> visibleAnnotations, List<AnnotationNode> invisibleAnnotations) {
        ArrayList<AnnotationNode> annotNodes = new ArrayList<AnnotationNode>();
        if (visibleAnnotations != null) {
            annotNodes.addAll(visibleAnnotations);
        }
        if (invisibleAnnotations != null) {
            annotNodes.addAll(invisibleAnnotations);
        }
        for (Object e : annotNodes) {
            AnnotationNode annotNode = (AnnotationNode)e;
            String desc = annotNode.desc;
            if (desc.startsWith("L") && desc.endsWith(";")) {
                desc = desc.substring(1, desc.length() - 1);
            }
            desc = desc.replace('/', '.');
            AnnotationHolder annot = new AnnotationHolder(desc);
            Parser.parseAnnotationValues(annot, annotNode.values);
            annotations.add(annot);
        }
    }

    private static void parseAnnotationValues(AnnotationHolder annot, List<Object> values) {
        if (values == null) {
            return;
        }
        for (int i = 0; i < values.size(); i += 2) {
            String key = (String)values.get(i);
            Object value = values.get(i + 1);
            annot.getValues().put(key, Parser.parseAnnotationValue(value));
        }
    }

    private static AnnotationValue parseAnnotationValue(Object value) {
        if (value instanceof String[]) {
            String[] enumInfo = (String[])value;
            ValueType.Object object = (ValueType.Object)ValueType.parse(enumInfo[0]);
            return new AnnotationValue(new FieldReference(object.getClassName(), enumInfo[1]));
        }
        if (value instanceof Type) {
            Type cls = (Type)value;
            return new AnnotationValue(ValueType.parse(cls.getDescriptor()));
        }
        if (value instanceof List) {
            List originalList = (List)value;
            ArrayList<AnnotationValue> resultList = new ArrayList<AnnotationValue>();
            for (Object item : originalList) {
                resultList.add(Parser.parseAnnotationValue(item));
            }
            return new AnnotationValue(resultList);
        }
        if (value instanceof AnnotationNode) {
            AnnotationNode annotNode = (AnnotationNode)value;
            ValueType.Object object = (ValueType.Object)ValueType.parse(annotNode.desc);
            AnnotationHolder annotation = new AnnotationHolder(object.getClassName());
            Parser.parseAnnotationValues(annotation, annotNode.values);
            return new AnnotationValue(annotation);
        }
        if (value instanceof String) {
            return new AnnotationValue((String)value);
        }
        if (value instanceof Boolean) {
            return new AnnotationValue((Boolean)value);
        }
        if (value instanceof Byte) {
            return new AnnotationValue((Byte)value);
        }
        if (value instanceof Short) {
            return new AnnotationValue((Short)value);
        }
        if (value instanceof Integer) {
            return new AnnotationValue((Integer)value);
        }
        if (value instanceof Long) {
            return new AnnotationValue((Long)value);
        }
        if (value instanceof Float) {
            return new AnnotationValue(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return new AnnotationValue((Double)value);
        }
        if (value.getClass().isArray()) {
            ArrayList<AnnotationValue> resultList = new ArrayList<AnnotationValue>();
            int size = Array.getLength(value);
            for (int i = 0; i < size; ++i) {
                Object item = Array.get(value, i);
                resultList.add(Parser.parseAnnotationValue(item));
            }
            return new AnnotationValue(resultList);
        }
        throw new AssertionError();
    }
}

