/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.teavm.common.Graph;
import org.teavm.common.GraphBuilder;
import org.teavm.model.BasicBlock;
import org.teavm.model.BasicBlockReader;
import org.teavm.model.FieldReference;
import org.teavm.model.Incoming;
import org.teavm.model.IncomingReader;
import org.teavm.model.Instruction;
import org.teavm.model.InstructionLocation;
import org.teavm.model.InvokeDynamicInstruction;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodHandle;
import org.teavm.model.MethodReference;
import org.teavm.model.Phi;
import org.teavm.model.PhiReader;
import org.teavm.model.Program;
import org.teavm.model.ProgramReader;
import org.teavm.model.RuntimeConstant;
import org.teavm.model.TryCatchBlock;
import org.teavm.model.TryCatchBlockReader;
import org.teavm.model.ValueType;
import org.teavm.model.Variable;
import org.teavm.model.VariableReader;
import org.teavm.model.instructions.ArrayElementType;
import org.teavm.model.instructions.ArrayLengthInstruction;
import org.teavm.model.instructions.AssignInstruction;
import org.teavm.model.instructions.BinaryBranchingCondition;
import org.teavm.model.instructions.BinaryBranchingInstruction;
import org.teavm.model.instructions.BinaryInstruction;
import org.teavm.model.instructions.BinaryOperation;
import org.teavm.model.instructions.BranchingCondition;
import org.teavm.model.instructions.BranchingInstruction;
import org.teavm.model.instructions.CastInstruction;
import org.teavm.model.instructions.CastIntegerDirection;
import org.teavm.model.instructions.CastIntegerInstruction;
import org.teavm.model.instructions.CastNumberInstruction;
import org.teavm.model.instructions.ClassConstantInstruction;
import org.teavm.model.instructions.CloneArrayInstruction;
import org.teavm.model.instructions.ConstructArrayInstruction;
import org.teavm.model.instructions.ConstructInstruction;
import org.teavm.model.instructions.ConstructMultiArrayInstruction;
import org.teavm.model.instructions.DoubleConstantInstruction;
import org.teavm.model.instructions.EmptyInstruction;
import org.teavm.model.instructions.ExitInstruction;
import org.teavm.model.instructions.FloatConstantInstruction;
import org.teavm.model.instructions.GetElementInstruction;
import org.teavm.model.instructions.GetFieldInstruction;
import org.teavm.model.instructions.InitClassInstruction;
import org.teavm.model.instructions.InstructionReader;
import org.teavm.model.instructions.IntegerConstantInstruction;
import org.teavm.model.instructions.IntegerSubtype;
import org.teavm.model.instructions.InvocationType;
import org.teavm.model.instructions.InvokeInstruction;
import org.teavm.model.instructions.IsInstanceInstruction;
import org.teavm.model.instructions.JumpInstruction;
import org.teavm.model.instructions.LongConstantInstruction;
import org.teavm.model.instructions.MonitorEnterInstruction;
import org.teavm.model.instructions.MonitorExitInstruction;
import org.teavm.model.instructions.NegateInstruction;
import org.teavm.model.instructions.NullCheckInstruction;
import org.teavm.model.instructions.NullConstantInstruction;
import org.teavm.model.instructions.NumericOperandType;
import org.teavm.model.instructions.PutElementInstruction;
import org.teavm.model.instructions.PutFieldInstruction;
import org.teavm.model.instructions.RaiseInstruction;
import org.teavm.model.instructions.StringConstantInstruction;
import org.teavm.model.instructions.SwitchInstruction;
import org.teavm.model.instructions.SwitchTableEntry;
import org.teavm.model.instructions.SwitchTableEntryReader;
import org.teavm.model.instructions.UnwrapArrayInstruction;
import org.teavm.model.util.InstructionTransitionExtractor;
import org.teavm.model.util.LocationGraphBuilder;

public final class ProgramUtils {
    private ProgramUtils() {
    }

    public static Graph buildControlFlowGraph(Program program) {
        GraphBuilder graphBuilder = new GraphBuilder(program.basicBlockCount());
        InstructionTransitionExtractor transitionExtractor = new InstructionTransitionExtractor();
        for (int i = 0; i < program.basicBlockCount(); ++i) {
            BasicBlock block = program.basicBlockAt(i);
            Instruction insn = block.getLastInstruction();
            if (insn != null) {
                insn.acceptVisitor(transitionExtractor);
                if (transitionExtractor.getTargets() != null) {
                    for (BasicBlock successor : transitionExtractor.getTargets()) {
                        graphBuilder.addEdge(i, successor.getIndex());
                    }
                }
            }
            for (TryCatchBlock tryCatch : block.getTryCatchBlocks()) {
                graphBuilder.addEdge(i, tryCatch.getHandler().getIndex());
            }
        }
        return graphBuilder.build();
    }

    public static Graph buildControlFlowGraphWithTryCatch(Program program) {
        GraphBuilder graphBuilder = new GraphBuilder(program.basicBlockCount());
        InstructionTransitionExtractor transitionExtractor = new InstructionTransitionExtractor();
        for (int i = 0; i < program.basicBlockCount(); ++i) {
            BasicBlock block = program.basicBlockAt(i);
            Instruction insn = block.getLastInstruction();
            if (insn != null) {
                insn.acceptVisitor(transitionExtractor);
                if (transitionExtractor.getTargets() != null) {
                    for (BasicBlock successor : transitionExtractor.getTargets()) {
                        graphBuilder.addEdge(i, successor.getIndex());
                        for (TryCatchBlock succTryCatch : successor.getTryCatchBlocks()) {
                            graphBuilder.addEdge(i, succTryCatch.getHandler().getIndex());
                        }
                    }
                }
            }
            for (TryCatchBlock tryCatch : block.getTryCatchBlocks()) {
                graphBuilder.addEdge(i, tryCatch.getHandler().getIndex());
            }
        }
        return graphBuilder.build();
    }

    public static Map<InstructionLocation, InstructionLocation[]> getLocationCFG(Program program) {
        return new LocationGraphBuilder().build(program);
    }

    public static Program copy(ProgramReader program) {
        int i;
        Program copy = new Program();
        InstructionCopyReader insnCopier = new InstructionCopyReader();
        insnCopier.programCopy = copy;
        for (i = 0; i < program.variableCount(); ++i) {
            Variable var = copy.createVariable();
            var.getDebugNames().addAll(program.variableAt(i).readDebugNames());
        }
        for (i = 0; i < program.basicBlockCount(); ++i) {
            copy.createBasicBlock();
        }
        for (i = 0; i < program.basicBlockCount(); ++i) {
            BasicBlockReader block = program.basicBlockAt(i);
            BasicBlock blockCopy = copy.basicBlockAt(i);
            blockCopy.getInstructions().addAll(ProgramUtils.copyInstructions(block, 0, block.instructionCount(), copy));
            blockCopy.getPhis().addAll(ProgramUtils.copyPhis(block, copy));
            for (TryCatchBlockReader tryCatchBlockReader : block.readTryCatchBlocks()) {
                TryCatchBlock tryCatchCopy = new TryCatchBlock();
                tryCatchCopy.setExceptionType(tryCatchBlockReader.getExceptionType());
                tryCatchCopy.setExceptionVariable(copy.variableAt(tryCatchBlockReader.getExceptionVariable().getIndex()));
                tryCatchCopy.setHandler(copy.basicBlockAt(tryCatchBlockReader.getHandler().getIndex()));
                blockCopy.getTryCatchBlocks().add(tryCatchCopy);
            }
        }
        return copy;
    }

    public static List<Instruction> copyInstructions(BasicBlockReader block, int from, int to, Program target) {
        ArrayList<Instruction> result = new ArrayList<Instruction>();
        InstructionCopyReader copyReader = new InstructionCopyReader();
        copyReader.programCopy = target;
        for (int i = from; i < to; ++i) {
            block.readInstruction(i, copyReader);
            copyReader.copy.setLocation(copyReader.location);
            result.add(copyReader.copy);
        }
        return result;
    }

    public static List<Phi> copyPhis(BasicBlockReader block, Program target) {
        ArrayList<Phi> result = new ArrayList<Phi>();
        for (PhiReader phiReader : block.readPhis()) {
            Phi phiCopy = new Phi();
            phiCopy.setReceiver(target.variableAt(phiReader.getReceiver().getIndex()));
            for (IncomingReader incomingReader : phiReader.readIncomings()) {
                Incoming incomingCopy = new Incoming();
                incomingCopy.setSource(target.basicBlockAt(incomingReader.getSource().getIndex()));
                incomingCopy.setValue(target.variableAt(incomingReader.getValue().getIndex()));
                phiCopy.getIncomings().add(incomingCopy);
            }
            result.add(phiCopy);
        }
        return result;
    }

    public static List<TryCatchBlock> copyTryCatches(BasicBlockReader block, Program target) {
        ArrayList<TryCatchBlock> result = new ArrayList<TryCatchBlock>();
        for (TryCatchBlockReader tryCatchBlockReader : block.readTryCatchBlocks()) {
            TryCatchBlock tryCatchCopy = new TryCatchBlock();
            tryCatchCopy.setExceptionType(tryCatchBlockReader.getExceptionType());
            tryCatchCopy.setExceptionVariable(target.variableAt(tryCatchBlockReader.getExceptionVariable().getIndex()));
            tryCatchCopy.setHandler(target.basicBlockAt(tryCatchBlockReader.getHandler().getIndex()));
            result.add(tryCatchCopy);
        }
        return result;
    }

    private static class InstructionCopyReader
    implements InstructionReader {
        Instruction copy;
        Program programCopy;
        InstructionLocation location;

        private InstructionCopyReader() {
        }

        @Override
        public void location(InstructionLocation location) {
            this.location = location;
        }

        private Variable copyVar(VariableReader var) {
            return this.programCopy.variableAt(var.getIndex());
        }

        private BasicBlock copyBlock(BasicBlockReader block) {
            return this.programCopy.basicBlockAt(block.getIndex());
        }

        @Override
        public void nop() {
            this.copy = new EmptyInstruction();
            this.copy.setLocation(this.location);
        }

        @Override
        public void classConstant(VariableReader receiver, ValueType cst) {
            ClassConstantInstruction insnCopy = new ClassConstantInstruction();
            insnCopy.setConstant(cst);
            insnCopy.setReceiver(this.copyVar(receiver));
            this.copy = insnCopy;
            this.copy.setLocation(this.location);
        }

        @Override
        public void nullConstant(VariableReader receiver) {
            NullConstantInstruction insnCopy = new NullConstantInstruction();
            insnCopy.setReceiver(this.copyVar(receiver));
            this.copy = insnCopy;
            this.copy.setLocation(this.location);
        }

        @Override
        public void integerConstant(VariableReader receiver, int cst) {
            IntegerConstantInstruction insnCopy = new IntegerConstantInstruction();
            insnCopy.setConstant(cst);
            insnCopy.setReceiver(this.copyVar(receiver));
            this.copy = insnCopy;
            this.copy.setLocation(this.location);
        }

        @Override
        public void longConstant(VariableReader receiver, long cst) {
            LongConstantInstruction insnCopy = new LongConstantInstruction();
            insnCopy.setConstant(cst);
            insnCopy.setReceiver(this.copyVar(receiver));
            this.copy = insnCopy;
            this.copy.setLocation(this.location);
        }

        @Override
        public void floatConstant(VariableReader receiver, float cst) {
            FloatConstantInstruction insnCopy = new FloatConstantInstruction();
            insnCopy.setConstant(cst);
            insnCopy.setReceiver(this.copyVar(receiver));
            this.copy = insnCopy;
            this.copy.setLocation(this.location);
        }

        @Override
        public void doubleConstant(VariableReader receiver, double cst) {
            DoubleConstantInstruction insnCopy = new DoubleConstantInstruction();
            insnCopy.setConstant(cst);
            insnCopy.setReceiver(this.copyVar(receiver));
            this.copy = insnCopy;
            this.copy.setLocation(this.location);
        }

        @Override
        public void stringConstant(VariableReader receiver, String cst) {
            StringConstantInstruction insnCopy = new StringConstantInstruction();
            insnCopy.setConstant(cst);
            insnCopy.setReceiver(this.copyVar(receiver));
            this.copy = insnCopy;
            this.copy.setLocation(this.location);
        }

        @Override
        public void binary(BinaryOperation op, VariableReader receiver, VariableReader first, VariableReader second, NumericOperandType type) {
            BinaryInstruction insnCopy = new BinaryInstruction(op, type);
            insnCopy.setFirstOperand(this.copyVar(first));
            insnCopy.setSecondOperand(this.copyVar(second));
            insnCopy.setReceiver(this.copyVar(receiver));
            this.copy = insnCopy;
            this.copy.setLocation(this.location);
        }

        @Override
        public void negate(VariableReader receiver, VariableReader operand, NumericOperandType type) {
            NegateInstruction insnCopy = new NegateInstruction(type);
            insnCopy.setOperand(this.copyVar(operand));
            insnCopy.setReceiver(this.copyVar(receiver));
            this.copy = insnCopy;
            this.copy.setLocation(this.location);
        }

        @Override
        public void assign(VariableReader receiver, VariableReader assignee) {
            AssignInstruction insnCopy = new AssignInstruction();
            insnCopy.setAssignee(this.copyVar(assignee));
            insnCopy.setReceiver(this.copyVar(receiver));
            this.copy = insnCopy;
            this.copy.setLocation(this.location);
        }

        @Override
        public void cast(VariableReader receiver, VariableReader value, ValueType targetType) {
            CastInstruction insnCopy = new CastInstruction();
            insnCopy.setValue(this.copyVar(value));
            insnCopy.setReceiver(this.copyVar(receiver));
            insnCopy.setTargetType(targetType);
            this.copy = insnCopy;
            this.copy.setLocation(this.location);
        }

        @Override
        public void cast(VariableReader receiver, VariableReader value, NumericOperandType sourceType, NumericOperandType targetType) {
            CastNumberInstruction insnCopy = new CastNumberInstruction(sourceType, targetType);
            insnCopy.setValue(this.copyVar(value));
            insnCopy.setReceiver(this.copyVar(receiver));
            this.copy = insnCopy;
            this.copy.setLocation(this.location);
        }

        @Override
        public void cast(VariableReader receiver, VariableReader value, IntegerSubtype type, CastIntegerDirection dir) {
            CastIntegerInstruction insnCopy = new CastIntegerInstruction(type, dir);
            insnCopy.setValue(this.copyVar(value));
            insnCopy.setReceiver(this.copyVar(receiver));
            this.copy = insnCopy;
            this.copy.setLocation(this.location);
        }

        @Override
        public void jumpIf(BranchingCondition cond, VariableReader operand, BasicBlockReader consequent, BasicBlockReader alternative) {
            BranchingInstruction insnCopy = new BranchingInstruction(cond);
            insnCopy.setOperand(this.copyVar(operand));
            insnCopy.setConsequent(this.copyBlock(consequent));
            insnCopy.setAlternative(this.copyBlock(alternative));
            this.copy = insnCopy;
            this.copy.setLocation(this.location);
        }

        @Override
        public void jumpIf(BinaryBranchingCondition cond, VariableReader first, VariableReader second, BasicBlockReader consequent, BasicBlockReader alternative) {
            BinaryBranchingInstruction insnCopy = new BinaryBranchingInstruction(cond);
            insnCopy.setFirstOperand(this.copyVar(first));
            insnCopy.setSecondOperand(this.copyVar(second));
            insnCopy.setConsequent(this.copyBlock(consequent));
            insnCopy.setAlternative(this.copyBlock(alternative));
            this.copy = insnCopy;
            this.copy.setLocation(this.location);
        }

        @Override
        public void jump(BasicBlockReader target) {
            JumpInstruction insnCopy = new JumpInstruction();
            insnCopy.setTarget(this.copyBlock(target));
            this.copy = insnCopy;
            this.copy.setLocation(this.location);
        }

        @Override
        public void choose(VariableReader condition, List<? extends SwitchTableEntryReader> table, BasicBlockReader defaultTarget) {
            SwitchInstruction insnCopy = new SwitchInstruction();
            insnCopy.setCondition(this.copyVar(condition));
            insnCopy.setDefaultTarget(this.copyBlock(defaultTarget));
            for (SwitchTableEntryReader switchTableEntryReader : table) {
                SwitchTableEntry entryCopy = new SwitchTableEntry();
                entryCopy.setCondition(switchTableEntryReader.getCondition());
                entryCopy.setTarget(this.copyBlock(switchTableEntryReader.getTarget()));
                insnCopy.getEntries().add(entryCopy);
            }
            this.copy = insnCopy;
            this.copy.setLocation(this.location);
        }

        @Override
        public void exit(VariableReader valueToReturn) {
            ExitInstruction insnCopy = new ExitInstruction();
            insnCopy.setValueToReturn(valueToReturn != null ? this.copyVar(valueToReturn) : null);
            this.copy = insnCopy;
            this.copy.setLocation(this.location);
        }

        @Override
        public void raise(VariableReader exception) {
            RaiseInstruction insnCopy = new RaiseInstruction();
            insnCopy.setException(this.copyVar(exception));
            this.copy = insnCopy;
            this.copy.setLocation(this.location);
        }

        @Override
        public void createArray(VariableReader receiver, ValueType itemType, VariableReader size) {
            ConstructArrayInstruction insnCopy = new ConstructArrayInstruction();
            insnCopy.setItemType(itemType);
            insnCopy.setSize(this.copyVar(size));
            insnCopy.setReceiver(this.copyVar(receiver));
            this.copy = insnCopy;
            this.copy.setLocation(this.location);
        }

        @Override
        public void createArray(VariableReader receiver, ValueType itemType, List<? extends VariableReader> dimensions) {
            ConstructMultiArrayInstruction insnCopy = new ConstructMultiArrayInstruction();
            insnCopy.setItemType(itemType);
            insnCopy.setReceiver(this.copyVar(receiver));
            for (VariableReader variableReader : dimensions) {
                insnCopy.getDimensions().add(this.copyVar(variableReader));
            }
            this.copy = insnCopy;
            this.copy.setLocation(this.location);
        }

        @Override
        public void create(VariableReader receiver, String type) {
            ConstructInstruction insnCopy = new ConstructInstruction();
            insnCopy.setType(type);
            insnCopy.setReceiver(this.copyVar(receiver));
            this.copy = insnCopy;
            this.copy.setLocation(this.location);
        }

        @Override
        public void getField(VariableReader receiver, VariableReader instance, FieldReference field, ValueType fieldType) {
            GetFieldInstruction insnCopy = new GetFieldInstruction();
            insnCopy.setField(field);
            insnCopy.setFieldType(fieldType);
            insnCopy.setInstance(instance != null ? this.copyVar(instance) : null);
            insnCopy.setReceiver(this.copyVar(receiver));
            this.copy = insnCopy;
            this.copy.setLocation(this.location);
        }

        @Override
        public void putField(VariableReader instance, FieldReference field, VariableReader value, ValueType fieldType) {
            PutFieldInstruction insnCopy = new PutFieldInstruction();
            insnCopy.setField(field);
            insnCopy.setInstance(instance != null ? this.copyVar(instance) : null);
            insnCopy.setValue(this.copyVar(value));
            insnCopy.setFieldType(fieldType);
            this.copy = insnCopy;
            this.copy.setLocation(this.location);
        }

        @Override
        public void arrayLength(VariableReader receiver, VariableReader array) {
            ArrayLengthInstruction insnCopy = new ArrayLengthInstruction();
            insnCopy.setArray(this.copyVar(array));
            insnCopy.setReceiver(this.copyVar(receiver));
            this.copy = insnCopy;
            this.copy.setLocation(this.location);
        }

        @Override
        public void cloneArray(VariableReader receiver, VariableReader array) {
            CloneArrayInstruction insnCopy = new CloneArrayInstruction();
            insnCopy.setArray(this.copyVar(array));
            insnCopy.setReceiver(this.copyVar(receiver));
            this.copy = insnCopy;
            this.copy.setLocation(this.location);
        }

        @Override
        public void unwrapArray(VariableReader receiver, VariableReader array, ArrayElementType elementType) {
            UnwrapArrayInstruction insnCopy = new UnwrapArrayInstruction(elementType);
            insnCopy.setArray(this.copyVar(array));
            insnCopy.setReceiver(this.copyVar(receiver));
            this.copy = insnCopy;
            this.copy.setLocation(this.location);
        }

        @Override
        public void getElement(VariableReader receiver, VariableReader array, VariableReader index) {
            GetElementInstruction insnCopy = new GetElementInstruction();
            insnCopy.setArray(this.copyVar(array));
            insnCopy.setReceiver(this.copyVar(receiver));
            insnCopy.setIndex(this.copyVar(index));
            this.copy = insnCopy;
            this.copy.setLocation(this.location);
        }

        @Override
        public void putElement(VariableReader array, VariableReader index, VariableReader value) {
            PutElementInstruction insnCopy = new PutElementInstruction();
            insnCopy.setArray(this.copyVar(array));
            insnCopy.setValue(this.copyVar(value));
            insnCopy.setIndex(this.copyVar(index));
            this.copy = insnCopy;
            this.copy.setLocation(this.location);
        }

        @Override
        public void invoke(VariableReader receiver, VariableReader instance, MethodReference method, List<? extends VariableReader> arguments, InvocationType type) {
            InvokeInstruction insnCopy = new InvokeInstruction();
            insnCopy.setMethod(method);
            insnCopy.setType(type);
            insnCopy.setInstance(instance != null ? this.copyVar(instance) : null);
            insnCopy.setReceiver(receiver != null ? this.copyVar(receiver) : null);
            for (VariableReader variableReader : arguments) {
                insnCopy.getArguments().add(this.copyVar(variableReader));
            }
            this.copy = insnCopy;
            this.copy.setLocation(this.location);
        }

        @Override
        public void invokeDynamic(VariableReader receiver, VariableReader instance, MethodDescriptor method, List<? extends VariableReader> arguments, MethodHandle bootstrapMethod, List<RuntimeConstant> bootstrapArguments) {
            InvokeDynamicInstruction insnCopy = new InvokeDynamicInstruction();
            insnCopy.setMethod(method);
            insnCopy.setBootstrapMethod(bootstrapMethod);
            insnCopy.getBootstrapArguments().addAll(bootstrapArguments);
            if (instance != null) {
                insnCopy.setInstance(this.copyVar(instance));
            }
            insnCopy.getArguments().addAll(arguments.stream().map(v -> this.copyVar((VariableReader)v)).collect(Collectors.toList()));
            insnCopy.setReceiver(receiver != null ? this.copyVar(receiver) : null);
            this.copy = insnCopy;
            this.copy.setLocation(this.location);
        }

        @Override
        public void isInstance(VariableReader receiver, VariableReader value, ValueType type) {
            IsInstanceInstruction insnCopy = new IsInstanceInstruction();
            insnCopy.setValue(this.copyVar(value));
            insnCopy.setReceiver(this.copyVar(receiver));
            insnCopy.setType(type);
            this.copy = insnCopy;
            this.copy.setLocation(this.location);
        }

        @Override
        public void initClass(String className) {
            InitClassInstruction insnCopy = new InitClassInstruction();
            insnCopy.setClassName(className);
            this.copy = insnCopy;
            this.copy.setLocation(this.location);
        }

        @Override
        public void nullCheck(VariableReader receiver, VariableReader value) {
            NullCheckInstruction insnCopy = new NullCheckInstruction();
            insnCopy.setReceiver(this.copyVar(receiver));
            insnCopy.setValue(this.copyVar(value));
            this.copy = insnCopy;
            this.copy.setLocation(this.location);
        }

        @Override
        public void monitorEnter(VariableReader objectRef) {
            MonitorEnterInstruction insnCopy = new MonitorEnterInstruction();
            insnCopy.setObjectRef(this.copyVar(objectRef));
            this.copy = insnCopy;
            this.copy.setLocation(this.location);
        }

        @Override
        public void monitorExit(VariableReader objectRef) {
            MonitorExitInstruction insnCopy = new MonitorExitInstruction();
            insnCopy.setObjectRef(this.copyVar(objectRef));
            this.copy = insnCopy;
            this.copy.setLocation(this.location);
        }
    }
}

