/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model;

import java.util.HashMap;
import java.util.Map;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderSource;
import org.teavm.model.MethodHolder;
import org.teavm.optimization.GlobalValueNumbering;
import org.teavm.optimization.UnusedVariableElimination;

public class PreOptimizingClassHolderSource
implements ClassHolderSource {
    private ClassHolderSource innerClassSource;
    private Map<String, ClassHolder> cache = new HashMap<String, ClassHolder>();

    public PreOptimizingClassHolderSource(ClassHolderSource innerClassSource) {
        this.innerClassSource = innerClassSource;
    }

    @Override
    public ClassHolder get(String name) {
        ClassHolder cls = this.cache.get(name);
        if (cls == null) {
            cls = this.innerClassSource.get(name);
            if (cls == null) {
                return null;
            }
            for (MethodHolder method : cls.getMethods()) {
                new GlobalValueNumbering().optimize(method, method.getProgram());
                new UnusedVariableElimination().optimize(method, method.getProgram());
            }
            this.cache.put(name, cls);
        }
        return cls;
    }
}

