/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.javascript;

import java.util.List;
import org.teavm.javascript.ast.AssignmentStatement;
import org.teavm.javascript.ast.BlockStatement;
import org.teavm.javascript.ast.BreakStatement;
import org.teavm.javascript.ast.ConditionalStatement;
import org.teavm.javascript.ast.ContinueStatement;
import org.teavm.javascript.ast.GotoPartStatement;
import org.teavm.javascript.ast.InitClassStatement;
import org.teavm.javascript.ast.MonitorEnterStatement;
import org.teavm.javascript.ast.MonitorExitStatement;
import org.teavm.javascript.ast.ReturnStatement;
import org.teavm.javascript.ast.SequentialStatement;
import org.teavm.javascript.ast.Statement;
import org.teavm.javascript.ast.StatementVisitor;
import org.teavm.javascript.ast.SwitchClause;
import org.teavm.javascript.ast.SwitchStatement;
import org.teavm.javascript.ast.ThrowStatement;
import org.teavm.javascript.ast.TryCatchStatement;
import org.teavm.javascript.ast.WhileStatement;

class TryCatchFinder
implements StatementVisitor {
    public boolean tryCatchFound;

    TryCatchFinder() {
    }

    @Override
    public void visit(AssignmentStatement statement) {
    }

    private void visitSequence(List<Statement> statements) {
        if (this.tryCatchFound) {
            return;
        }
        for (Statement statement : statements) {
            statement.acceptVisitor(this);
            if (!this.tryCatchFound) continue;
            return;
        }
    }

    @Override
    public void visit(SequentialStatement statement) {
        if (this.tryCatchFound) {
            return;
        }
        this.visitSequence(statement.getSequence());
    }

    @Override
    public void visit(ConditionalStatement statement) {
        if (this.tryCatchFound) {
            return;
        }
        this.visitSequence(statement.getConsequent());
        this.visitSequence(statement.getAlternative());
    }

    @Override
    public void visit(SwitchStatement statement) {
        if (this.tryCatchFound) {
            return;
        }
        for (SwitchClause clause : statement.getClauses()) {
            this.visitSequence(clause.getBody());
            if (!this.tryCatchFound) continue;
            return;
        }
        this.visitSequence(statement.getDefaultClause());
    }

    @Override
    public void visit(WhileStatement statement) {
        if (!this.tryCatchFound) {
            this.visitSequence(statement.getBody());
        }
    }

    @Override
    public void visit(BlockStatement statement) {
        if (!this.tryCatchFound) {
            this.visitSequence(statement.getBody());
        }
    }

    @Override
    public void visit(BreakStatement statement) {
    }

    @Override
    public void visit(ContinueStatement statement) {
    }

    @Override
    public void visit(ReturnStatement statement) {
    }

    @Override
    public void visit(ThrowStatement statement) {
    }

    @Override
    public void visit(InitClassStatement statement) {
    }

    @Override
    public void visit(TryCatchStatement statement) {
        this.tryCatchFound = true;
    }

    @Override
    public void visit(GotoPartStatement statement) {
    }

    @Override
    public void visit(MonitorEnterStatement statement) {
    }

    @Override
    public void visit(MonitorExitStatement statement) {
    }
}

