/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.codegen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.teavm.codegen.NameFrequencyConsumer;
import org.teavm.codegen.NamingStrategy;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReference;

public class NamingOrderer
implements NameFrequencyConsumer {
    private Map<String, Entry> entries = new HashMap<String, Entry>();

    @Override
    public void consume(MethodReference method) {
        String key = "R:" + method;
        Entry entry = this.entries.get(key);
        if (entry == null) {
            entry = new Entry();
            entry.operation = naming -> naming.getFullNameFor(method);
            this.entries.put(key, entry);
        }
        ++entry.frequency;
    }

    @Override
    public void consumeInit(MethodReference method) {
        String key = "I:" + method;
        Entry entry = this.entries.get(key);
        if (entry == null) {
            entry = new Entry();
            entry.operation = naming -> naming.getNameForInit(method);
            this.entries.put(key, entry);
        }
        ++entry.frequency;
    }

    @Override
    public void consume(MethodDescriptor method) {
        String key = "r:" + method;
        Entry entry = this.entries.get(key);
        if (entry == null) {
            entry = new Entry();
            entry.operation = naming -> naming.getNameFor(method);
            this.entries.put(key, entry);
        }
        ++entry.frequency;
    }

    @Override
    public void consume(String className) {
        String key = "c:" + className;
        Entry entry = this.entries.get(key);
        if (entry == null) {
            entry = new Entry();
            entry.operation = naming -> naming.getNameFor(className);
            this.entries.put(key, entry);
        }
        ++entry.frequency;
    }

    @Override
    public void consume(FieldReference field) {
        String key = "f:" + field;
        Entry entry = this.entries.get(key);
        if (entry == null) {
            entry = new Entry();
            entry.operation = naming -> naming.getNameFor(field);
            this.entries.put(key, entry);
        }
        ++entry.frequency;
    }

    @Override
    public void consumeFunction(String name) {
        String key = "n:" + name;
        Entry entry = this.entries.get(key);
        if (entry == null) {
            entry = new Entry();
            entry.operation = naming -> naming.getNameForFunction(name);
            this.entries.put(key, entry);
        }
        ++entry.frequency;
    }

    public void apply(NamingStrategy naming) {
        ArrayList<Entry> entryList = new ArrayList<Entry>(this.entries.values());
        Collections.sort(entryList, (o1, o2) -> Integer.compare(o2.frequency, o1.frequency));
        for (Entry entry : entryList) {
            entry.operation.perform(naming);
        }
    }

    static interface NamingOperation {
        public void perform(NamingStrategy var1);
    }

    static class Entry {
        NamingOperation operation;
        int frequency;

        Entry() {
        }
    }
}

