/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.common;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.teavm.common.FiniteExecutor;

public class ThreadPoolFiniteExecutor
implements FiniteExecutor {
    private List<Thread> threads = new ArrayList<Thread>();
    private BlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>();
    private AtomicInteger runningTasks = new AtomicInteger();
    private final Object monitor = new Object();
    private AtomicReference<RuntimeException> thrownException = new AtomicReference();
    private ThreadLocal<Queue<Runnable>> localQueueues = new ThreadLocal();

    public ThreadPoolFiniteExecutor(int numThreads) {
        for (int i = 0; i < numThreads; ++i) {
            Thread thread = new Thread(() -> this.takeTask());
            this.threads.add(thread);
            thread.start();
        }
    }

    @Override
    public void execute(Runnable command) {
        this.runningTasks.incrementAndGet();
        try {
            this.queue.put(command);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void executeFast(Runnable runnable) {
        this.localQueueues.get().add(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void complete() {
        Object object = this.monitor;
        synchronized (object) {
            while (true) {
                if (this.thrownException.get() != null) {
                    throw this.thrownException.get();
                }
                if (this.runningTasks.get() == 0) {
                    return;
                }
                try {
                    this.monitor.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void takeTask() {
        localQueue = new ArrayDeque<E>();
        this.localQueueues.set(localQueue);
        block16: while (true) {
            try {
                while (true) lbl-1000:
                // 3 sources

                {
                    task = this.queue.take();
                    try {
                        task.run();
                        while (!localQueue.isEmpty()) {
                            ((Runnable)localQueue.remove()).run();
                        }
                    }
                    catch (RuntimeException e) {
                        this.thrownException.set(e);
                        continue block16;
                    }
                    finally {
                        if (this.runningTasks.decrementAndGet() != 0 && this.thrownException.get() == null) continue;
                        var3_4 = this.monitor;
                        synchronized (var3_4) {
                            this.monitor.notifyAll();
                            continue block16;
                        }
                    }
                    if (this.runningTasks.decrementAndGet() != 0 && this.thrownException.get() == null) ** GOTO lbl-1000
                    var3_4 = this.monitor;
                    synchronized (var3_4) {
                        this.monitor.notifyAll();
                        continue block16;
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }
    }

    public void stop() {
        for (Thread thread : this.threads) {
            thread.interrupt();
        }
    }
}

