/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.common;

import java.io.IOException;
import java.io.Writer;

public class CommutatedWriter
extends Writer {
    private ThreadLocal<StringBuilder> buffer = new ThreadLocal();
    private Writer innerWriter;

    public CommutatedWriter(Writer innerWriter) {
        this.innerWriter = innerWriter;
    }

    private StringBuilder getBuffer() {
        if (this.buffer.get() == null) {
            this.buffer.set(new StringBuilder());
        }
        return this.buffer.get();
    }

    @Override
    public void write(int c) throws IOException {
        this.getBuffer().append(c);
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        this.getBuffer().append(cbuf);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.getBuffer().append(cbuf, off, len);
    }

    @Override
    public void write(String str) throws IOException {
        this.getBuffer().append(str);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.getBuffer().append(str, off, len + off);
    }

    @Override
    public Writer append(CharSequence csq) throws IOException {
        this.getBuffer().append(csq);
        return this;
    }

    @Override
    public Writer append(CharSequence csq, int start, int end) throws IOException {
        this.getBuffer().append(csq, start, end);
        return this;
    }

    @Override
    public Writer append(char c) throws IOException {
        this.getBuffer().append(c);
        return this;
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        StringBuilder sb = this.getBuffer();
        this.innerWriter.write(sb.toString());
        this.buffer.set(null);
    }
}

