/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model.emit;

import org.teavm.model.BasicBlock;
import org.teavm.model.FieldReference;
import org.teavm.model.Instruction;
import org.teavm.model.InstructionLocation;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReference;
import org.teavm.model.Program;
import org.teavm.model.ValueType;
import org.teavm.model.Variable;
import org.teavm.model.emit.ValueEmitter;
import org.teavm.model.instructions.ClassConstantInstruction;
import org.teavm.model.instructions.ConstructArrayInstruction;
import org.teavm.model.instructions.ConstructInstruction;
import org.teavm.model.instructions.DoubleConstantInstruction;
import org.teavm.model.instructions.ExitInstruction;
import org.teavm.model.instructions.FloatConstantInstruction;
import org.teavm.model.instructions.GetFieldInstruction;
import org.teavm.model.instructions.InitClassInstruction;
import org.teavm.model.instructions.IntegerConstantInstruction;
import org.teavm.model.instructions.InvocationType;
import org.teavm.model.instructions.InvokeInstruction;
import org.teavm.model.instructions.JumpInstruction;
import org.teavm.model.instructions.LongConstantInstruction;
import org.teavm.model.instructions.NullConstantInstruction;
import org.teavm.model.instructions.PutFieldInstruction;
import org.teavm.model.instructions.StringConstantInstruction;

public final class ProgramEmitter {
    private Program program;
    private BasicBlock block;
    private InstructionLocation currentLocation;

    private ProgramEmitter(Program program, BasicBlock block) {
        this.program = program;
        this.block = block;
    }

    public Program getProgram() {
        return this.program;
    }

    public BasicBlock getBlock() {
        return this.block;
    }

    public void setBlock(BasicBlock block) {
        this.block = block;
    }

    public BasicBlock createBlock() {
        BasicBlock block = this.program.createBasicBlock();
        this.setBlock(block);
        return block;
    }

    public ValueEmitter constant(Class<?> cls) {
        return this.constant(ValueType.parse(cls));
    }

    public ValueEmitter constant(ValueType value) {
        Variable var = this.program.createVariable();
        ClassConstantInstruction insn = new ClassConstantInstruction();
        insn.setReceiver(var);
        insn.setConstant(value);
        this.addInstruction(insn);
        return this.var(var);
    }

    public ValueEmitter constant(String value) {
        Variable var = this.program.createVariable();
        StringConstantInstruction insn = new StringConstantInstruction();
        insn.setReceiver(var);
        insn.setConstant(value);
        this.addInstruction(insn);
        return this.var(var);
    }

    public ValueEmitter constant(int value) {
        Variable var = this.program.createVariable();
        IntegerConstantInstruction insn = new IntegerConstantInstruction();
        insn.setReceiver(var);
        insn.setConstant(value);
        this.addInstruction(insn);
        return this.var(var);
    }

    public ValueEmitter constant(long value) {
        Variable var = this.program.createVariable();
        LongConstantInstruction insn = new LongConstantInstruction();
        insn.setReceiver(var);
        insn.setConstant(value);
        this.addInstruction(insn);
        return this.var(var);
    }

    public ValueEmitter constant(float value) {
        Variable var = this.program.createVariable();
        FloatConstantInstruction insn = new FloatConstantInstruction();
        insn.setReceiver(var);
        insn.setConstant(value);
        this.addInstruction(insn);
        return this.var(var);
    }

    public ValueEmitter constant(double value) {
        Variable var = this.program.createVariable();
        DoubleConstantInstruction insn = new DoubleConstantInstruction();
        insn.setReceiver(var);
        insn.setConstant(value);
        this.addInstruction(insn);
        return this.var(var);
    }

    public ValueEmitter constantNull() {
        Variable var = this.program.createVariable();
        NullConstantInstruction insn = new NullConstantInstruction();
        insn.setReceiver(var);
        this.addInstruction(insn);
        return this.var(var);
    }

    public ValueEmitter getField(FieldReference field, ValueType type) {
        Variable var = this.program.createVariable();
        GetFieldInstruction insn = new GetFieldInstruction();
        insn.setField(field);
        insn.setFieldType(type);
        insn.setReceiver(var);
        this.addInstruction(insn);
        return this.var(var);
    }

    public ProgramEmitter setField(FieldReference field, ValueType type, ValueEmitter value) {
        PutFieldInstruction insn = new PutFieldInstruction();
        insn.setField(field);
        insn.setFieldType(type);
        insn.setValue(value.getVariable());
        this.addInstruction(insn);
        return this;
    }

    public ValueEmitter invoke(MethodReference method, ValueEmitter ... arguments) {
        Variable result = null;
        if (method.getReturnType() != ValueType.VOID) {
            result = this.program.createVariable();
        }
        InvokeInstruction insn = new InvokeInstruction();
        insn.setType(InvocationType.SPECIAL);
        insn.setMethod(method);
        insn.setReceiver(result);
        for (ValueEmitter arg : arguments) {
            insn.getArguments().add(arg.variable);
        }
        this.addInstruction(insn);
        return result != null ? this.var(result) : null;
    }

    public ProgramEmitter invokeAndIgnore(MethodReference method, ValueEmitter ... arguments) {
        this.invoke(method, arguments);
        return this;
    }

    public ValueEmitter construct(MethodReference method, ValueEmitter ... arguments) {
        Variable var = this.program.createVariable();
        ConstructInstruction insn = new ConstructInstruction();
        insn.setReceiver(var);
        insn.setType(method.getClassName());
        this.addInstruction(insn);
        ValueEmitter instance = this.var(var);
        instance.invokeSpecial(method, arguments);
        return instance;
    }

    public ValueEmitter constructArray(ValueType type, ValueEmitter size) {
        Variable var = this.program.createVariable();
        ConstructArrayInstruction insn = new ConstructArrayInstruction();
        insn.setReceiver(var);
        insn.setSize(size.getVariable());
        insn.setItemType(type);
        this.addInstruction(insn);
        return this.var(var);
    }

    public ValueEmitter constructArray(ValueType type, int size) {
        return this.constructArray(type, this.constant(size));
    }

    public ValueEmitter constructArray(Class<?> type, int size) {
        return this.constructArray(ValueType.parse(type), size);
    }

    public ValueEmitter constructArray(Class<?> type, ValueEmitter size) {
        return this.constructArray(ValueType.parse(type), size);
    }

    public void initClass(String className) {
        InitClassInstruction insn = new InitClassInstruction();
        insn.setClassName(className);
        this.addInstruction(insn);
    }

    public ProgramEmitter jump(BasicBlock block) {
        JumpInstruction insn = new JumpInstruction();
        insn.setTarget(block);
        this.addInstruction(insn);
        this.block = block;
        return this;
    }

    public void exit() {
        ExitInstruction insn = new ExitInstruction();
        this.addInstruction(insn);
    }

    public ValueEmitter var(Variable var) {
        return new ValueEmitter(this, this.block, var);
    }

    public ValueEmitter newVar() {
        return this.var(this.program.createVariable());
    }

    public InstructionLocation getCurrentLocation() {
        return this.currentLocation;
    }

    public void setCurrentLocation(InstructionLocation currentLocation) {
        this.currentLocation = currentLocation;
    }

    public void addInstruction(Instruction insn) {
        if (this.currentLocation != null) {
            insn.setLocation(this.currentLocation);
        }
        this.block.getInstructions().add(insn);
    }

    public static ProgramEmitter create(MethodHolder method) {
        Program program = new Program();
        method.setProgram(program);
        BasicBlock zeroBlock = program.createBasicBlock();
        BasicBlock block = program.createBasicBlock();
        JumpInstruction insn = new JumpInstruction();
        insn.setTarget(block);
        zeroBlock.getInstructions().add(insn);
        return new ProgramEmitter(program, block);
    }
}

