/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.dependency;

import java.util.Arrays;
import org.teavm.dependency.DependencyAgent;
import org.teavm.dependency.DependencyChecker;
import org.teavm.dependency.DependencyNode;
import org.teavm.dependency.DependencyPlugin;
import org.teavm.dependency.DependencyType;
import org.teavm.dependency.MethodDependencyInfo;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;

public class MethodDependency
implements MethodDependencyInfo {
    private DependencyChecker dependencyChecker;
    private DependencyNode[] variableNodes;
    private int parameterCount;
    private DependencyNode resultNode;
    private DependencyNode thrown;
    private MethodReader method;
    private MethodReference reference;
    private boolean used;
    DependencyPlugin dependencyPlugin;
    boolean dependencyPluginAttached;

    MethodDependency(DependencyChecker dependencyChecker, DependencyNode[] variableNodes, int parameterCount, DependencyNode resultNode, DependencyNode thrown, MethodReader method, MethodReference reference) {
        this.dependencyChecker = dependencyChecker;
        this.variableNodes = Arrays.copyOf(variableNodes, variableNodes.length);
        this.parameterCount = parameterCount;
        this.thrown = thrown;
        this.resultNode = resultNode;
        this.method = method;
        this.reference = reference;
    }

    public DependencyAgent getDependencyAgent() {
        return this.dependencyChecker.getAgent();
    }

    public DependencyNode[] getVariables() {
        return Arrays.copyOf(this.variableNodes, this.variableNodes.length);
    }

    void setVariables(DependencyNode[] variables) {
        this.variableNodes = variables;
    }

    @Override
    public int getVariableCount() {
        return this.variableNodes.length;
    }

    @Override
    public DependencyNode getVariable(int index) {
        return this.variableNodes[index];
    }

    @Override
    public int getParameterCount() {
        return this.parameterCount;
    }

    @Override
    public DependencyNode getResult() {
        return this.resultNode;
    }

    @Override
    public DependencyNode getThrown() {
        return this.thrown;
    }

    @Override
    public MethodReference getReference() {
        return this.reference;
    }

    public MethodReader getMethod() {
        return this.method;
    }

    @Override
    public boolean isMissing() {
        return this.method == null;
    }

    @Override
    public boolean isUsed() {
        return this.used;
    }

    public MethodDependency propagate(int parameterIndex, Class<?> type) {
        return this.propagate(parameterIndex, this.dependencyChecker.getType(type.getName()));
    }

    public MethodDependency propagate(int parameterIndex, String type) {
        return this.propagate(parameterIndex, this.dependencyChecker.getType(type));
    }

    public MethodDependency propagate(int parameterIndex, DependencyType type) {
        this.getVariable(parameterIndex).propagate(type);
        return this;
    }

    public void use() {
        if (!this.used) {
            this.used = true;
            if (!this.isMissing()) {
                this.dependencyChecker.scheduleMethodAnalysis(this);
            }
        }
    }
}

