/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.testing;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collections;
import org.junit.Test;
import org.teavm.model.AnnotationReader;
import org.teavm.model.AnnotationValue;
import org.teavm.model.MethodReader;
import org.teavm.model.ValueType;
import org.teavm.testing.TestAdapter;

public class JUnitTestAdapter
implements TestAdapter {
    @Override
    public boolean acceptClass(Class<?> cls) {
        for (Method method : cls.getDeclaredMethods()) {
            for (Annotation annot : method.getAnnotations()) {
                if (!annot.annotationType().getName().equals(Test.class.getName())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean acceptMethod(MethodReader method) {
        return method.getAnnotations().get(Test.class.getName()) != null;
    }

    @Override
    public Iterable<String> getExpectedExceptions(MethodReader method) {
        AnnotationReader annot = method.getAnnotations().get(Test.class.getName());
        AnnotationValue expectedAnnot = annot.getValue("expected");
        if (expectedAnnot != null) {
            String className = ((ValueType.Object)expectedAnnot.getJavaClass()).getClassName();
            return Collections.singletonList(className);
        }
        return Collections.emptyList();
    }
}

