/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.optimization;

import java.util.ArrayList;
import java.util.List;
import org.teavm.model.BasicBlock;
import org.teavm.model.Instruction;
import org.teavm.model.MethodReader;
import org.teavm.model.Program;
import org.teavm.model.Variable;
import org.teavm.model.instructions.EmptyInstruction;
import org.teavm.model.instructions.UnwrapArrayInstruction;
import org.teavm.model.util.DefinitionExtractor;
import org.teavm.optimization.MethodOptimization;

public class ArrayUnwrapMotion
implements MethodOptimization {
    @Override
    public void optimize(MethodReader method, Program program) {
        for (int i = 0; i < program.basicBlockCount(); ++i) {
            this.optimize(program.basicBlockAt(i));
        }
    }

    private void optimize(BasicBlock block) {
        ArrayList<UnwrapArrayInstruction> newInstructions = new ArrayList<UnwrapArrayInstruction>();
        List<Instruction> instructions = block.getInstructions();
        for (int i = 0; i < instructions.size(); ++i) {
            Instruction insn = instructions.get(i);
            if (!(insn instanceof UnwrapArrayInstruction)) continue;
            UnwrapArrayInstruction unwrap = (UnwrapArrayInstruction)insn;
            instructions.set(i, new EmptyInstruction());
            int def = this.whereDefined(instructions, i, unwrap.getArray());
            if (def < 0) {
                newInstructions.add(unwrap);
                continue;
            }
            instructions.add(def + 1, unwrap);
            ++i;
        }
        if (!newInstructions.isEmpty()) {
            instructions.addAll(0, newInstructions);
        }
    }

    private int whereDefined(List<Instruction> instructions, int index, Variable var) {
        DefinitionExtractor def = new DefinitionExtractor();
        while (index >= 0) {
            Instruction insn = instructions.get(index);
            insn.acceptVisitor(def);
            for (Variable defVar : def.getDefinedVariables()) {
                if (defVar != var) continue;
                return index;
            }
            --index;
        }
        return index;
    }
}

