/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model.util;

import java.util.ArrayList;
import org.teavm.model.AnnotationContainer;
import org.teavm.model.AnnotationContainerReader;
import org.teavm.model.AnnotationHolder;
import org.teavm.model.AnnotationReader;
import org.teavm.model.AnnotationValue;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassReader;
import org.teavm.model.FieldHolder;
import org.teavm.model.FieldReader;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReader;
import org.teavm.model.util.ProgramUtils;

public final class ModelUtils {
    private ModelUtils() {
    }

    public static ClassHolder copyClass(ClassReader original) {
        ClassHolder copy = new ClassHolder(original.getName());
        copy.setLevel(original.getLevel());
        copy.getModifiers().addAll(original.readModifiers());
        copy.setParent(original.getParent());
        copy.getInterfaces().addAll(original.getInterfaces());
        for (MethodReader methodReader : original.getMethods()) {
            copy.addMethod(ModelUtils.copyMethod(methodReader));
        }
        for (FieldReader fieldReader : original.getFields()) {
            copy.addField(ModelUtils.copyField(fieldReader));
        }
        copy.setOwnerName(original.getOwnerName());
        ModelUtils.copyAnnotations(original.getAnnotations(), copy.getAnnotations());
        return copy;
    }

    public static MethodHolder copyMethod(MethodReader method) {
        MethodHolder copy = new MethodHolder(method.getDescriptor());
        copy.setLevel(method.getLevel());
        copy.getModifiers().addAll(method.readModifiers());
        if (method.getProgram() != null) {
            copy.setProgram(ProgramUtils.copy(method.getProgram()));
        }
        ModelUtils.copyAnnotations(method.getAnnotations(), copy.getAnnotations());
        if (method.getAnnotationDefault() != null) {
            copy.setAnnotationDefault(ModelUtils.copyAnnotationValue(method.getAnnotationDefault()));
        }
        return copy;
    }

    public static FieldHolder copyField(FieldReader field) {
        FieldHolder copy = new FieldHolder(field.getName());
        copy.setLevel(field.getLevel());
        copy.getModifiers().addAll(field.readModifiers());
        copy.setType(field.getType());
        copy.setInitialValue(field.getInitialValue());
        ModelUtils.copyAnnotations(field.getAnnotations(), copy.getAnnotations());
        return copy;
    }

    public static void copyAnnotations(AnnotationContainerReader src, AnnotationContainer dst) {
        for (AnnotationReader annotationReader : src.all()) {
            dst.add(ModelUtils.copyAnnotation(annotationReader));
        }
    }

    private static AnnotationHolder copyAnnotation(AnnotationReader annot) {
        AnnotationHolder copy = new AnnotationHolder(annot.getType());
        for (String fieldName : annot.getAvailableFields()) {
            copy.getValues().put(fieldName, ModelUtils.copyAnnotationValue(annot.getValue(fieldName)));
        }
        return copy;
    }

    private static AnnotationValue copyAnnotationValue(AnnotationValue value) {
        switch (value.getType()) {
            case 9: {
                ArrayList<AnnotationValue> listCopy = new ArrayList<AnnotationValue>();
                for (AnnotationValue item : value.getList()) {
                    listCopy.add(ModelUtils.copyAnnotationValue(item));
                }
                return new AnnotationValue(listCopy);
            }
            case 11: {
                return new AnnotationValue(ModelUtils.copyAnnotation(value.getAnnotation()));
            }
        }
        return value;
    }
}

