/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model.util;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teavm.common.Graph;
import org.teavm.common.GraphSplittingBackend;
import org.teavm.common.GraphUtils;
import org.teavm.common.IntegerArray;
import org.teavm.model.BasicBlock;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.Instruction;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.Program;
import org.teavm.model.TryCatchBlock;
import org.teavm.model.Variable;
import org.teavm.model.instructions.InvokeInstruction;
import org.teavm.model.instructions.JumpInstruction;
import org.teavm.model.instructions.MonitorEnterInstruction;
import org.teavm.model.util.InstructionTransitionExtractor;
import org.teavm.model.util.ProgramNodeSplittingBackend;
import org.teavm.model.util.ProgramUtils;

public class AsyncProgramSplitter {
    private List<Part> parts = new ArrayList<Part>();
    private Map<Long, Integer> partMap = new HashMap<Long, Integer>();
    private ClassReaderSource classSource;
    private Set<MethodReference> asyncMethods = new HashSet<MethodReference>();
    private Program program;

    public AsyncProgramSplitter(ClassReaderSource classSource, Set<MethodReference> asyncMethods) {
        this.classSource = classSource;
        this.asyncMethods = asyncMethods;
    }

    public void split(Program program) {
        this.program = program;
        this.parts.clear();
        Program initialProgram = this.createStubCopy(program);
        Part initialPart = new Part(program.basicBlockCount());
        initialPart.program = initialProgram;
        this.parts.add(initialPart);
        this.partMap.put(0L, 0);
        Step initialStep = new Step();
        initialStep.source = 0;
        initialStep.targetPart = initialPart;
        ArrayDeque<Step> queue = new ArrayDeque<Step>();
        queue.add(initialStep);
        block0: while (!queue.isEmpty()) {
            Step step = (Step)queue.remove();
            BasicBlock targetBlock = step.targetPart.program.basicBlockAt(step.source);
            if (targetBlock.instructionCount() > 0) continue;
            BasicBlock sourceBlock = program.basicBlockAt(step.source);
            step.targetPart.originalBlocks[step.source] = step.source;
            int last = 0;
            for (int i = 0; i < sourceBlock.getInstructions().size(); ++i) {
                Object invoke;
                Instruction instruction = sourceBlock.getInstructions().get(i);
                if (instruction instanceof InvokeInstruction ? !this.asyncMethods.contains(this.findRealMethod(((InvokeInstruction)(invoke = (InvokeInstruction)instruction)).getMethod())) : !(instruction instanceof MonitorEnterInstruction)) continue;
                targetBlock.getInstructions().addAll(ProgramUtils.copyInstructions(sourceBlock, last, i, targetBlock.getProgram()));
                targetBlock.getTryCatchBlocks().addAll(ProgramUtils.copyTryCatches(sourceBlock, targetBlock.getProgram()));
                invoke = targetBlock.getTryCatchBlocks().iterator();
                while (invoke.hasNext()) {
                    TryCatchBlock tryCatch = (TryCatchBlock)invoke.next();
                    if (tryCatch.getHandler() == null) continue;
                    Step next = new Step();
                    next.source = tryCatch.getHandler().getIndex();
                    next.targetPart = step.targetPart;
                    queue.add(next);
                }
                last = i;
                step.targetPart.splitPoints[targetBlock.getIndex()] = i;
                long key = (long)step.source << 32 | (long)i;
                if (this.partMap.containsKey(key)) {
                    step.targetPart.blockSuccessors[targetBlock.getIndex()] = this.partMap.get(key);
                    continue block0;
                }
                Program nextProgram = this.createStubCopy(program);
                Part part = new Part(program.basicBlockCount() + 1);
                part.program = nextProgram;
                int partId = this.parts.size();
                this.parts.add(part);
                this.partMap.put(key, partId);
                step.targetPart.blockSuccessors[targetBlock.getIndex()] = partId;
                targetBlock = nextProgram.createBasicBlock();
                if (step.source > 0) {
                    JumpInstruction jumpToNextBlock = new JumpInstruction();
                    jumpToNextBlock.setTarget(targetBlock);
                    nextProgram.basicBlockAt(0).getInstructions().add(jumpToNextBlock);
                    nextProgram.basicBlockAt(0).getTryCatchBlocks().addAll(ProgramUtils.copyTryCatches(sourceBlock, nextProgram));
                }
                step.targetPart = part;
                part.originalBlocks[targetBlock.getIndex()] = step.source;
            }
            targetBlock.getInstructions().addAll(ProgramUtils.copyInstructions(sourceBlock, last, sourceBlock.getInstructions().size(), targetBlock.getProgram()));
            targetBlock.getTryCatchBlocks().addAll(ProgramUtils.copyTryCatches(sourceBlock, targetBlock.getProgram()));
            for (TryCatchBlock tryCatchBlock : targetBlock.getTryCatchBlocks()) {
                if (tryCatchBlock.getHandler() == null) continue;
                Step next = new Step();
                next.source = tryCatchBlock.getHandler().getIndex();
                next.targetPart = step.targetPart;
                queue.add(next);
            }
            InstructionTransitionExtractor successorExtractor = new InstructionTransitionExtractor();
            sourceBlock.getLastInstruction().acceptVisitor(successorExtractor);
            for (BasicBlock successor : successorExtractor.getTargets()) {
                BasicBlock targetSuccessor = targetBlock.getProgram().basicBlockAt(successor.getIndex());
                if (targetSuccessor.instructionCount() != 0) continue;
                Step next = new Step();
                next.source = successor.getIndex();
                next.targetPart = step.targetPart;
                queue.add(next);
            }
        }
        for (Part part : this.parts) {
            IntegerArray blockSuccessors = IntegerArray.of(part.blockSuccessors);
            IntegerArray originalBlocks = IntegerArray.of(part.originalBlocks);
            IntegerArray splitPoints = IntegerArray.of(part.splitPoints);
            AsyncProgramSplittingBackend asyncProgramSplittingBackend = new AsyncProgramSplittingBackend(new ProgramNodeSplittingBackend(part.program), blockSuccessors, originalBlocks, splitPoints);
            Graph graph = ProgramUtils.buildControlFlowGraphWithTryCatch(part.program);
            int[] weights = new int[graph.size()];
            for (int i = 0; i < part.program.basicBlockCount(); ++i) {
                weights[i] = part.program.basicBlockAt(i).getInstructions().size();
            }
            GraphUtils.splitIrreducibleGraph(graph, weights, asyncProgramSplittingBackend);
            part.blockSuccessors = asyncProgramSplittingBackend.blockSuccessors.getAll();
            part.originalBlocks = asyncProgramSplittingBackend.originalBlocks.getAll();
            part.splitPoints = asyncProgramSplittingBackend.splitPoints.getAll();
        }
        this.partMap.clear();
    }

    private MethodReference findRealMethod(MethodReference method) {
        ClassReader cls;
        String clsName = method.getClassName();
        while (clsName != null && (cls = this.classSource.get(clsName)) != null) {
            MethodReader methodReader = cls.getMethod(method.getDescriptor());
            if (methodReader != null) {
                return new MethodReference(clsName, method.getDescriptor());
            }
            clsName = cls.getParent();
            if (clsName == null || !clsName.equals(cls.getName())) continue;
            break;
        }
        return method;
    }

    private Program createStubCopy(Program program) {
        int i;
        Program copy = new Program();
        for (i = 0; i < program.basicBlockCount(); ++i) {
            copy.createBasicBlock();
        }
        for (i = 0; i < program.variableCount(); ++i) {
            Variable var = program.variableAt(i);
            copy.createVariable();
            Variable varCopy = copy.variableAt(i);
            varCopy.setRegister(var.getRegister());
            varCopy.getDebugNames().addAll(var.getDebugNames());
        }
        return copy;
    }

    public int size() {
        return this.parts.size();
    }

    public Program getOriginalProgram() {
        return this.program;
    }

    public Program getProgram(int index) {
        return this.parts.get((int)index).program;
    }

    public int[] getBlockSuccessors(int index) {
        int[] result = this.parts.get((int)index).blockSuccessors;
        return Arrays.copyOf(result, result.length);
    }

    public int getBlockSuccessor(int index, int blockIndex) {
        return this.parts.get((int)index).blockSuccessors[blockIndex];
    }

    public int[] getSplitPoints(int index) {
        return (int[])this.parts.get((int)index).splitPoints.clone();
    }

    public int[] getOriginalBlocks(int index) {
        return (int[])this.parts.get((int)index).originalBlocks.clone();
    }

    private static class AsyncProgramSplittingBackend
    implements GraphSplittingBackend {
        private GraphSplittingBackend inner;
        private IntegerArray blockSuccessors;
        private IntegerArray originalBlocks;
        private IntegerArray splitPoints;

        public AsyncProgramSplittingBackend(GraphSplittingBackend inner, IntegerArray blockSuccessors, IntegerArray originalBlocks, IntegerArray splitPoints) {
            this.inner = inner;
            this.blockSuccessors = blockSuccessors;
            this.originalBlocks = originalBlocks;
            this.splitPoints = splitPoints;
        }

        @Override
        public int[] split(int[] domain, int[] nodes) {
            int[] copies = this.inner.split(domain, nodes);
            for (int i = 0; i < copies.length; ++i) {
                int copy = copies[i];
                int node = nodes[i];
                if (this.blockSuccessors.size() <= copy) {
                    this.blockSuccessors.add(-1);
                    this.splitPoints.add(-1);
                    this.originalBlocks.add(-1);
                }
                this.blockSuccessors.set(copy, this.blockSuccessors.get(node));
                this.originalBlocks.set(copy, this.originalBlocks.get(node));
                this.splitPoints.set(copy, this.splitPoints.get(node));
            }
            return copies;
        }
    }

    private static class Step {
        Part targetPart;
        int source;

        private Step() {
        }
    }

    static class Part {
        Program program;
        int[] blockSuccessors;
        int[] splitPoints;
        int[] originalBlocks;

        public Part(int blockCount) {
            this.blockSuccessors = new int[blockCount];
            Arrays.fill(this.blockSuccessors, -1);
            this.splitPoints = new int[blockCount];
            Arrays.fill(this.splitPoints, -1);
            this.originalBlocks = new int[blockCount];
            Arrays.fill(this.originalBlocks, -1);
        }
    }
}

