/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.codegen;

import java.util.HashSet;
import java.util.Set;
import org.teavm.codegen.AliasProvider;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReference;

public class DefaultAliasProvider
implements AliasProvider {
    private int lastSuffix;
    private int lastVirtualSuffix;
    private Set<String> usedAliases = new HashSet<String>();

    @Override
    public String getAlias(String cls) {
        StringBuilder alias = new StringBuilder();
        int lastIndex = 0;
        while (true) {
            int index;
            if ((index = cls.indexOf(46, lastIndex)) == -1) {
                if (lastIndex > 0) {
                    alias.append("_");
                }
                break;
            }
            if (index > lastIndex) {
                alias.append(cls.charAt(lastIndex));
            }
            lastIndex = index + 1;
        }
        alias.append(cls.substring(lastIndex));
        alias.append(this.lastSuffix++);
        return alias.toString();
    }

    @Override
    public String getAlias(MethodDescriptor method) {
        String result;
        String alias = method.getName();
        if (alias.equals("<init>")) {
            alias = "$init";
        } else if (alias.equals("<clinit>")) {
            alias = "$clinit";
        }
        while (!this.usedAliases.add(result = alias + this.lastVirtualSuffix++)) {
        }
        return result;
    }

    @Override
    public String getAlias(MethodReference method) {
        String alias = method.getDescriptor().getName();
        if (alias.equals("<init>")) {
            alias = "$init";
        } else if (alias.equals("<clinit>")) {
            alias = "$clinit";
        }
        return alias + this.lastSuffix++;
    }

    @Override
    public String getAlias(FieldReference field) {
        String result;
        while (!this.usedAliases.add(result = field.getFieldName() + this.lastSuffix++)) {
        }
        return result;
    }

    @Override
    public String getFunctionAlias(String name) {
        return name;
    }
}

