/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.vm;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import org.teavm.codegen.AliasProvider;
import org.teavm.codegen.DefaultAliasProvider;
import org.teavm.codegen.DefaultNamingStrategy;
import org.teavm.codegen.MinifyingAliasProvider;
import org.teavm.codegen.SourceWriter;
import org.teavm.codegen.SourceWriterBuilder;
import org.teavm.common.ServiceRepository;
import org.teavm.debugging.information.DebugInformationEmitter;
import org.teavm.debugging.information.SourceLocation;
import org.teavm.dependency.DependencyChecker;
import org.teavm.dependency.DependencyCheckerInterruptor;
import org.teavm.dependency.DependencyInfo;
import org.teavm.dependency.DependencyListener;
import org.teavm.dependency.DependencyStack;
import org.teavm.dependency.DependencyViolations;
import org.teavm.dependency.Linker;
import org.teavm.dependency.MethodDependency;
import org.teavm.javascript.Decompiler;
import org.teavm.javascript.EmptyRegularMethodNodeCache;
import org.teavm.javascript.RegularMethodNodeCache;
import org.teavm.javascript.Renderer;
import org.teavm.javascript.RenderingException;
import org.teavm.javascript.ast.ClassNode;
import org.teavm.javascript.ni.Generator;
import org.teavm.javascript.ni.Injector;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderTransformer;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.ElementHolder;
import org.teavm.model.ElementModifier;
import org.teavm.model.InstructionLocation;
import org.teavm.model.ListableClassHolderSource;
import org.teavm.model.ListableClassReaderSource;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReference;
import org.teavm.model.MutableClassHolderSource;
import org.teavm.model.Program;
import org.teavm.model.ProgramCache;
import org.teavm.model.ValueType;
import org.teavm.model.util.ListingBuilder;
import org.teavm.model.util.ModelUtils;
import org.teavm.model.util.ProgramUtils;
import org.teavm.model.util.RegisterAllocator;
import org.teavm.optimization.ArrayUnwrapMotion;
import org.teavm.optimization.Devirtualization;
import org.teavm.optimization.GlobalValueNumbering;
import org.teavm.optimization.LoopInvariantMotion;
import org.teavm.optimization.MethodOptimization;
import org.teavm.optimization.UnusedVariableElimination;
import org.teavm.vm.BuildTarget;
import org.teavm.vm.DirectoryBuildTarget;
import org.teavm.vm.TeaVMEntryPoint;
import org.teavm.vm.TeaVMPhase;
import org.teavm.vm.TeaVMProgressFeedback;
import org.teavm.vm.TeaVMProgressListener;
import org.teavm.vm.spi.RendererListener;
import org.teavm.vm.spi.TeaVMHost;
import org.teavm.vm.spi.TeaVMPlugin;

public class TeaVM
implements TeaVMHost,
ServiceRepository {
    private ClassReaderSource classSource;
    private DependencyChecker dependencyChecker;
    private ClassLoader classLoader;
    private boolean minifying = true;
    private boolean bytecodeLogging;
    private OutputStream logStream = System.out;
    private Map<String, TeaVMEntryPoint> entryPoints = new HashMap<String, TeaVMEntryPoint>();
    private Map<String, String> exportedClasses = new HashMap<String, String>();
    private Map<MethodReference, Generator> methodGenerators = new HashMap<MethodReference, Generator>();
    private Map<MethodReference, Injector> methodInjectors = new HashMap<MethodReference, Injector>();
    private List<RendererListener> rendererListeners = new ArrayList<RendererListener>();
    private Map<Class<?>, Object> services = new HashMap();
    private Properties properties = new Properties();
    private DebugInformationEmitter debugEmitter;
    private ProgramCache programCache;
    private RegularMethodNodeCache astCache = new EmptyRegularMethodNodeCache();
    private boolean incremental;
    private TeaVMProgressListener progressListener;
    private boolean cancelled;
    private ListableClassHolderSource writtenClasses;

    TeaVM(ClassReaderSource classSource, ClassLoader classLoader) {
        this.classSource = classSource;
        this.classLoader = classLoader;
        this.dependencyChecker = new DependencyChecker(this.classSource, classLoader, this);
        this.progressListener = new TeaVMProgressListener(){

            @Override
            public TeaVMProgressFeedback progressReached(int progress) {
                return TeaVMProgressFeedback.CONTINUE;
            }

            @Override
            public TeaVMProgressFeedback phaseStarted(TeaVMPhase phase, int count) {
                return TeaVMProgressFeedback.CONTINUE;
            }
        };
    }

    @Override
    public void add(DependencyListener listener) {
        this.dependencyChecker.addDependencyListener(listener);
    }

    @Override
    public void add(ClassHolderTransformer transformer) {
        this.dependencyChecker.addClassTransformer(transformer);
    }

    @Override
    public void add(MethodReference methodRef, Generator generator) {
        this.methodGenerators.put(methodRef, generator);
    }

    @Override
    public void add(MethodReference methodRef, Injector injector) {
        this.methodInjectors.put(methodRef, injector);
    }

    @Override
    public void add(RendererListener listener) {
        this.rendererListeners.add(listener);
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public boolean isMinifying() {
        return this.minifying;
    }

    public void setMinifying(boolean minifying) {
        this.minifying = minifying;
    }

    public boolean isBytecodeLogging() {
        return this.bytecodeLogging;
    }

    public void setBytecodeLogging(boolean bytecodeLogging) {
        this.bytecodeLogging = bytecodeLogging;
    }

    public void setProperties(Properties properties) {
        this.properties.clear();
        if (properties != null) {
            this.properties.putAll((Map<?, ?>)properties);
        }
    }

    @Override
    public Properties getProperties() {
        return new Properties(this.properties);
    }

    public RegularMethodNodeCache getAstCache() {
        return this.astCache;
    }

    public void setAstCache(RegularMethodNodeCache methodAstCache) {
        this.astCache = methodAstCache;
    }

    public ProgramCache getProgramCache() {
        return this.programCache;
    }

    public void setProgramCache(ProgramCache programCache) {
        this.programCache = programCache;
    }

    public boolean isIncremental() {
        return this.incremental;
    }

    public void setIncremental(boolean incremental) {
        this.incremental = incremental;
    }

    public TeaVMProgressListener getProgressListener() {
        return this.progressListener;
    }

    public void setProgressListener(TeaVMProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    public boolean wasCancelled() {
        return this.cancelled;
    }

    public TeaVMEntryPoint entryPoint(String name, MethodReference ref) {
        if (name != null && this.entryPoints.containsKey(name)) {
            throw new IllegalArgumentException("Entry point with public name `" + name + "' already defined " + "for method " + ref);
        }
        TeaVMEntryPoint entryPoint = new TeaVMEntryPoint(name, ref, this.dependencyChecker.linkMethod(ref, DependencyStack.ROOT));
        this.dependencyChecker.linkClass(ref.getClassName(), DependencyStack.ROOT).initClass(DependencyStack.ROOT);
        if (name != null) {
            this.entryPoints.put(name, entryPoint);
        }
        return entryPoint;
    }

    public TeaVMEntryPoint entryPoint(MethodReference ref) {
        return this.entryPoint(null, ref);
    }

    public TeaVMEntryPoint linkMethod(MethodReference ref) {
        TeaVMEntryPoint entryPoint = new TeaVMEntryPoint("", ref, this.dependencyChecker.linkMethod(ref, DependencyStack.ROOT));
        this.dependencyChecker.linkClass(ref.getClassName(), DependencyStack.ROOT).initClass(DependencyStack.ROOT);
        return entryPoint;
    }

    public void exportType(String name, String className) {
        if (this.exportedClasses.containsKey(name)) {
            throw new IllegalArgumentException("Class with public name `" + name + "' already defined for class " + className);
        }
        this.dependencyChecker.linkClass(className, DependencyStack.ROOT).initClass(DependencyStack.ROOT);
        this.exportedClasses.put(name, className);
    }

    public void linkType(String className) {
        this.dependencyChecker.linkClass(className, DependencyStack.ROOT).initClass(DependencyStack.ROOT);
    }

    public ClassReaderSource getClassSource() {
        return this.classSource;
    }

    public boolean hasMissingItems() {
        return this.dependencyChecker.hasMissingItems();
    }

    public void showMissingItems(Appendable target) throws IOException {
        this.dependencyChecker.showMissingItems(target);
    }

    public DependencyViolations getDependencyViolations() {
        return this.dependencyChecker.getDependencyViolations();
    }

    public Collection<String> getClasses() {
        return this.dependencyChecker.getAchievableClasses();
    }

    public DependencyInfo getDependencyInfo() {
        return this.dependencyChecker;
    }

    public ListableClassReaderSource getWrittenClasses() {
        return this.writtenClasses;
    }

    public void checkForMissingItems() {
        this.dependencyChecker.checkForMissingItems();
    }

    public DebugInformationEmitter getDebugEmitter() {
        return this.debugEmitter;
    }

    public void setDebugEmitter(DebugInformationEmitter debugEmitter) {
        this.debugEmitter = debugEmitter;
    }

    public void build(Appendable writer, BuildTarget target) throws RenderingException {
        ListableClassHolderSource classSet;
        this.reportPhase(TeaVMPhase.DEPENDENCY_CHECKING, 1);
        if (this.wasCancelled()) {
            return;
        }
        AliasProvider aliasProvider = this.minifying ? new MinifyingAliasProvider() : new DefaultAliasProvider();
        this.dependencyChecker.setInterruptor(new DependencyCheckerInterruptor(){

            @Override
            public boolean shouldContinue() {
                return TeaVM.this.progressListener.progressReached(0) == TeaVMProgressFeedback.CONTINUE;
            }
        });
        this.dependencyChecker.linkMethod(new MethodReference(Class.class, "createNew", Class.class), DependencyStack.ROOT).use();
        this.dependencyChecker.linkMethod(new MethodReference(String.class, "<init>", char[].class, Void.TYPE), DependencyStack.ROOT).use();
        this.dependencyChecker.linkMethod(new MethodReference(String.class, "getChars", Integer.TYPE, Integer.TYPE, char[].class, Integer.TYPE, Void.TYPE), DependencyStack.ROOT).use();
        MethodDependency internDep = this.dependencyChecker.linkMethod(new MethodReference(String.class, "intern", String.class), DependencyStack.ROOT);
        internDep.getVariable(0).propagate(this.dependencyChecker.getType("java.lang.String"));
        internDep.use();
        this.dependencyChecker.linkMethod(new MethodReference(String.class, "length", Integer.TYPE), DependencyStack.ROOT).use();
        this.dependencyChecker.linkMethod(new MethodReference(Object.class, "clone", Object.class), DependencyStack.ROOT).use();
        this.dependencyChecker.processDependencies();
        if (this.wasCancelled() || this.hasMissingItems()) {
            return;
        }
        this.reportPhase(TeaVMPhase.LINKING, 1);
        if (this.wasCancelled()) {
            return;
        }
        this.writtenClasses = classSet = this.link(this.dependencyChecker);
        if (this.wasCancelled()) {
            return;
        }
        if (!this.incremental) {
            this.devirtualize(classSet, this.dependencyChecker);
            if (this.wasCancelled()) {
                return;
            }
        }
        List<ClassNode> clsNodes = this.modelToAst(classSet);
        this.reportPhase(TeaVMPhase.RENDERING, classSet.getClassNames().size());
        if (this.wasCancelled()) {
            return;
        }
        DefaultNamingStrategy naming = new DefaultNamingStrategy(aliasProvider, this.dependencyChecker.getClassSource());
        naming.setMinifying(this.minifying);
        SourceWriterBuilder builder = new SourceWriterBuilder(naming);
        builder.setMinified(this.minifying);
        SourceWriter sourceWriter = builder.build(writer);
        Renderer renderer = new Renderer(sourceWriter, classSet, this.classLoader, this);
        if (this.debugEmitter != null) {
            int classIndex = 0;
            for (String className : classSet.getClassNames()) {
                ClassHolder cls = classSet.get(className);
                for (MethodHolder method : cls.getMethods()) {
                    if (method.getProgram() == null) continue;
                    this.emitCFG(this.debugEmitter, method.getProgram());
                }
                this.reportProgress(++classIndex);
                if (!this.wasCancelled()) continue;
                return;
            }
            renderer.setDebugEmitter(this.debugEmitter);
        }
        renderer.getDebugEmitter().setLocationProvider(sourceWriter);
        for (Map.Entry<MethodReference, Injector> entry : this.methodInjectors.entrySet()) {
            renderer.addInjector(entry.getKey(), entry.getValue());
        }
        try {
            for (RendererListener rendererListener : this.rendererListeners) {
                rendererListener.begin(renderer, target);
            }
            sourceWriter.append("\"use strict\";").newLine();
            renderer.renderRuntime();
            for (ClassNode classNode : clsNodes) {
                ClassHolder cls = classSet.get(classNode.getName());
                for (RendererListener listener : this.rendererListeners) {
                    listener.beforeClass(cls);
                }
                renderer.render(classNode);
                for (RendererListener listener : this.rendererListeners) {
                    listener.afterClass(cls);
                }
            }
            renderer.renderStringPool();
            for (Map.Entry entry : this.entryPoints.entrySet()) {
                sourceWriter.append("var ").append((String)entry.getKey()).ws().append("=").ws().appendMethodBody(((TeaVMEntryPoint)entry.getValue()).reference).append(";").softNewLine();
            }
            for (Map.Entry entry : this.exportedClasses.entrySet()) {
                sourceWriter.append("var ").append((String)entry.getKey()).ws().append("=").ws().appendClass((String)entry.getValue()).append(";").softNewLine();
            }
            for (RendererListener rendererListener : this.rendererListeners) {
                rendererListener.complete();
            }
        }
        catch (IOException e) {
            throw new RenderingException("IO Error occured", e);
        }
    }

    public ListableClassHolderSource link(DependencyInfo dependency) {
        this.reportPhase(TeaVMPhase.LINKING, dependency.getAchievableClasses().size());
        Linker linker = new Linker();
        MutableClassHolderSource cutClasses = new MutableClassHolderSource();
        if (this.wasCancelled()) {
            return cutClasses;
        }
        int index = 0;
        for (String className : dependency.getAchievableClasses()) {
            ClassHolder cls = ModelUtils.copyClass(dependency.getClassSource().get(className));
            cutClasses.putClassHolder(cls);
            linker.link(dependency, cls);
            this.progressListener.progressReached(++index);
        }
        return cutClasses;
    }

    private void reportPhase(TeaVMPhase phase, int progressLimit) {
        if (this.progressListener.phaseStarted(phase, progressLimit) == TeaVMProgressFeedback.CANCEL) {
            this.cancelled = true;
        }
    }

    private void reportProgress(int progress) {
        if (this.progressListener.progressReached(progress) == TeaVMProgressFeedback.CANCEL) {
            this.cancelled = true;
        }
    }

    private void emitCFG(DebugInformationEmitter emitter, Program program) {
        Map<InstructionLocation, InstructionLocation[]> cfg = ProgramUtils.getLocationCFG(program);
        for (Map.Entry<InstructionLocation, InstructionLocation[]> entry : cfg.entrySet()) {
            SourceLocation location = TeaVM.map(entry.getKey());
            SourceLocation[] successors = new SourceLocation[entry.getValue().length];
            for (int i = 0; i < entry.getValue().length; ++i) {
                successors[i] = TeaVM.map(entry.getValue()[i]);
            }
            emitter.addSuccessors(location, successors);
        }
    }

    private static SourceLocation map(InstructionLocation location) {
        if (location == null) {
            return null;
        }
        return new SourceLocation(location.getFileName(), location.getLine());
    }

    private void devirtualize(ListableClassHolderSource classes, DependencyInfo dependency) {
        this.reportPhase(TeaVMPhase.DEVIRTUALIZATION, classes.getClassNames().size());
        if (this.wasCancelled()) {
            return;
        }
        Devirtualization devirtualization = new Devirtualization(dependency, classes);
        int index = 0;
        for (String className : classes.getClassNames()) {
            ClassHolder cls = classes.get(className);
            for (MethodHolder method : cls.getMethods()) {
                if (method.getProgram() == null) continue;
                devirtualization.apply(method);
            }
            this.reportProgress(++index);
            if (!this.wasCancelled()) continue;
            return;
        }
    }

    private List<ClassNode> modelToAst(ListableClassHolderSource classes) {
        this.progressListener.phaseStarted(TeaVMPhase.DECOMPILATION, classes.getClassNames().size());
        Decompiler decompiler = new Decompiler(classes, this.classLoader);
        decompiler.setRegularMethodCache(this.incremental ? this.astCache : null);
        for (Map.Entry<MethodReference, Generator> entry : this.methodGenerators.entrySet()) {
            decompiler.addGenerator(entry.getKey(), entry.getValue());
        }
        for (MethodReference injectedMethod : this.methodInjectors.keySet()) {
            decompiler.addMethodToPass(injectedMethod);
        }
        List<String> classOrder = decompiler.getClassOrdering(classes.getClassNames());
        ArrayList<ClassNode> classNodes = new ArrayList<ClassNode>();
        int index = 0;
        try (PrintWriter bytecodeLogger = this.bytecodeLogging ? new PrintWriter(new OutputStreamWriter(this.logStream, "UTF-8")) : null;){
            for (String className : classOrder) {
                ClassHolder cls = classes.get(className);
                for (MethodHolder method : cls.getMethods()) {
                    this.processMethod(method);
                    if (!this.bytecodeLogging) continue;
                    this.logMethodBytecode(bytecodeLogger, method);
                }
                classNodes.add(decompiler.decompile(cls));
                this.progressListener.progressReached(++index);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)"UTF-8 is expected to be supported");
        }
        return classNodes;
    }

    private void processMethod(MethodHolder method) {
        Program optimizedProgram;
        if (method.getProgram() == null) {
            return;
        }
        Program program = optimizedProgram = this.incremental && this.programCache != null ? this.programCache.get(method.getReference()) : null;
        if (optimizedProgram == null) {
            optimizedProgram = ProgramUtils.copy(method.getProgram());
            if (optimizedProgram.basicBlockCount() > 0) {
                for (MethodOptimization optimization : this.getOptimizations()) {
                    optimization.optimize(method, optimizedProgram);
                }
                RegisterAllocator allocator = new RegisterAllocator();
                allocator.allocateRegisters(method, optimizedProgram);
            }
            if (this.incremental && this.programCache != null) {
                this.programCache.store(method.getReference(), optimizedProgram);
            }
        }
        method.setProgram(optimizedProgram);
    }

    private List<MethodOptimization> getOptimizations() {
        return Arrays.asList(new ArrayUnwrapMotion(), new LoopInvariantMotion(), new GlobalValueNumbering(), new UnusedVariableElimination());
    }

    private void logMethodBytecode(PrintWriter writer, MethodHolder method) {
        writer.print("    ");
        this.printModifiers(writer, method);
        writer.print(method.getName() + "(");
        ValueType[] parameterTypes = method.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (i > 0) {
                writer.print(", ");
            }
            this.printType(writer, parameterTypes[i]);
        }
        writer.println(")");
        Program program = method.getProgram();
        if (program != null && program.basicBlockCount() > 0) {
            ListingBuilder builder = new ListingBuilder();
            writer.print(builder.buildListing(program, "        "));
            writer.print("        Register allocation:");
            for (int i = 0; i < program.variableCount(); ++i) {
                writer.print(i + ":" + program.variableAt(i).getRegister() + " ");
            }
            writer.println();
            writer.println();
            writer.flush();
        } else {
            writer.println();
        }
    }

    private void printType(PrintWriter writer, ValueType type) {
        if (type instanceof ValueType.Object) {
            writer.print(((ValueType.Object)type).getClassName());
        } else if (type instanceof ValueType.Array) {
            this.printType(writer, ((ValueType.Array)type).getItemType());
            writer.print("[]");
        } else if (type instanceof ValueType.Primitive) {
            switch (((ValueType.Primitive)type).getKind()) {
                case BOOLEAN: {
                    writer.print("boolean");
                    break;
                }
                case SHORT: {
                    writer.print("short");
                    break;
                }
                case BYTE: {
                    writer.print("byte");
                    break;
                }
                case CHARACTER: {
                    writer.print("char");
                    break;
                }
                case DOUBLE: {
                    writer.print("double");
                    break;
                }
                case FLOAT: {
                    writer.print("float");
                    break;
                }
                case INTEGER: {
                    writer.print("int");
                    break;
                }
                case LONG: {
                    writer.print("long");
                }
            }
        }
    }

    private void printModifiers(PrintWriter writer, ElementHolder element) {
        switch (element.getLevel()) {
            case PRIVATE: {
                writer.print("private ");
                break;
            }
            case PUBLIC: {
                writer.print("public ");
                break;
            }
            case PROTECTED: {
                writer.print("protected ");
                break;
            }
        }
        EnumSet<ElementModifier> modifiers = element.getModifiers();
        if (modifiers.contains((Object)ElementModifier.ABSTRACT)) {
            writer.print("abstract ");
        }
        if (modifiers.contains((Object)ElementModifier.FINAL)) {
            writer.print("final ");
        }
        if (modifiers.contains((Object)ElementModifier.STATIC)) {
            writer.print("static ");
        }
        if (modifiers.contains((Object)ElementModifier.NATIVE)) {
            writer.print("native ");
        }
    }

    public void build(File dir, String fileName) throws RenderingException {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(dir, fileName)), "UTF-8");){
            this.build(writer, new DirectoryBuildTarget(dir));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Platform does not support UTF-8", e);
        }
        catch (IOException e) {
            throw new RenderingException("IO error occured", e);
        }
    }

    public void installPlugins() {
        for (TeaVMPlugin plugin : ServiceLoader.load(TeaVMPlugin.class, this.classLoader)) {
            plugin.install(this);
        }
    }

    @Override
    public <T> T getService(Class<T> type) {
        Object service = this.services.get(type);
        if (service == null) {
            throw new IllegalArgumentException("Service not registered: " + type.getName());
        }
        return type.cast(service);
    }

    @Override
    public <T> void registerService(Class<T> type, T instance) {
        this.services.put(type, instance);
    }
}

