/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.tooling;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.teavm.tooling.SourceFileProvider;

public class JarSourceFileProvider
implements SourceFileProvider {
    private File file;
    private ZipFile zipFile;
    private Set<String> sourceFiles = new HashSet<String>();

    public JarSourceFileProvider(File file) {
        this.file = file;
    }

    @Override
    public void open() throws IOException {
        this.zipFile = new ZipFile(this.file);
        Enumeration<? extends ZipEntry> enumeration = this.zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry entry = enumeration.nextElement();
            this.sourceFiles.add(entry.getName());
        }
    }

    @Override
    public void close() throws IOException {
        if (this.zipFile == null) {
            return;
        }
        ZipFile zipFile = this.zipFile;
        this.zipFile = null;
        this.sourceFiles.clear();
        zipFile.close();
    }

    @Override
    public InputStream openSourceFile(String fullPath) throws IOException {
        if (this.zipFile == null || !this.sourceFiles.contains(fullPath)) {
            return null;
        }
        ZipEntry entry = this.zipFile.getEntry(fullPath);
        return entry != null ? this.zipFile.getInputStream(entry) : null;
    }
}

