/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.teavm.model.BasicBlockReader;
import org.teavm.model.Instruction;
import org.teavm.model.InstructionLocation;
import org.teavm.model.InstructionReadVisitor;
import org.teavm.model.Phi;
import org.teavm.model.PhiReader;
import org.teavm.model.Program;
import org.teavm.model.TryCatchBlock;
import org.teavm.model.instructions.InstructionReader;

public class BasicBlock
implements BasicBlockReader {
    private Program program;
    private int index;
    private List<Phi> phis = new ArrayList<Phi>();
    private List<Instruction> instructions = new ArrayList<Instruction>();
    List<TryCatchBlock> tryCatchBlocks = new ArrayList<TryCatchBlock>();
    private List<Instruction> safeInstructions = new AbstractList<Instruction>(){

        @Override
        public Instruction get(int index) {
            return (Instruction)BasicBlock.this.instructions.get(index);
        }

        @Override
        public int size() {
            return BasicBlock.this.instructions.size();
        }

        @Override
        public void add(int index, Instruction e) {
            if (e.getBasicBlock() != null) {
                throw new IllegalArgumentException("This instruction is in some basic block");
            }
            e.setBasicBlock(BasicBlock.this);
            BasicBlock.this.instructions.add(index, e);
        }

        @Override
        public Instruction set(int index, Instruction element) {
            if (element.getBasicBlock() != null) {
                throw new IllegalArgumentException("This instruction is in some basic block");
            }
            Instruction oldInsn = (Instruction)BasicBlock.this.instructions.get(index);
            oldInsn.setBasicBlock(null);
            element.setBasicBlock(BasicBlock.this);
            return BasicBlock.this.instructions.set(index, element);
        }

        @Override
        public Instruction remove(int index) {
            Instruction insn = (Instruction)BasicBlock.this.instructions.remove(index);
            insn.setBasicBlock(null);
            return insn;
        }

        @Override
        public void clear() {
            for (Instruction insn : BasicBlock.this.instructions) {
                insn.setBasicBlock(null);
            }
            BasicBlock.this.instructions.clear();
        }
    };
    private List<Phi> safePhis = new AbstractList<Phi>(){

        @Override
        public Phi get(int index) {
            return (Phi)BasicBlock.this.phis.get(index);
        }

        @Override
        public int size() {
            return BasicBlock.this.phis.size();
        }

        @Override
        public void add(int index, Phi e) {
            if (e.getBasicBlock() != null) {
                throw new IllegalArgumentException("This phi is already in some basic block");
            }
            e.setBasicBlock(BasicBlock.this);
            BasicBlock.this.phis.add(index, e);
        }

        @Override
        public Phi set(int index, Phi element) {
            if (element.getBasicBlock() != null) {
                throw new IllegalArgumentException("This phi is already in some basic block");
            }
            Phi oldPhi = (Phi)BasicBlock.this.phis.get(index);
            oldPhi.setBasicBlock(null);
            element.setBasicBlock(BasicBlock.this);
            return BasicBlock.this.phis.set(index, element);
        }

        @Override
        public Phi remove(int index) {
            Phi phi = (Phi)BasicBlock.this.phis.remove(index);
            phi.setBasicBlock(null);
            return phi;
        }

        @Override
        public void clear() {
            for (Phi phi : BasicBlock.this.phis) {
                phi.setBasicBlock(null);
            }
            BasicBlock.this.phis.clear();
        }
    };
    private List<Phi> immutablePhis = Collections.unmodifiableList(this.phis);
    private List<TryCatchBlock> immutableTryCatchBlocks = Collections.unmodifiableList(this.tryCatchBlocks);
    private List<TryCatchBlock> safeTryCatchBlocks = new AbstractList<TryCatchBlock>(){

        @Override
        public TryCatchBlock get(int index) {
            return BasicBlock.this.tryCatchBlocks.get(index);
        }

        @Override
        public int size() {
            return BasicBlock.this.tryCatchBlocks.size();
        }

        @Override
        public void add(int index, TryCatchBlock element) {
            if (element.protectedBlock == BasicBlock.this) {
                throw new IllegalStateException("This try/catch block is already added to basic block");
            }
            element.protectedBlock = BasicBlock.this;
            BasicBlock.this.tryCatchBlocks.add(index, element);
        }

        @Override
        public TryCatchBlock remove(int index) {
            TryCatchBlock tryCatch = BasicBlock.this.tryCatchBlocks.remove(index);
            tryCatch.protectedBlock = null;
            return tryCatch;
        }

        @Override
        public TryCatchBlock set(int index, TryCatchBlock element) {
            TryCatchBlock oldTryCatch = BasicBlock.this.tryCatchBlocks.get(index);
            if (oldTryCatch == element) {
                return oldTryCatch;
            }
            if (element.protectedBlock == BasicBlock.this) {
                throw new IllegalStateException("This try/catch block is already added to basic block");
            }
            oldTryCatch.protectedBlock = null;
            element.protectedBlock = BasicBlock.this;
            BasicBlock.this.tryCatchBlocks.set(index, element);
            return oldTryCatch;
        }

        @Override
        public void clear() {
            for (TryCatchBlock tryCatch : BasicBlock.this.tryCatchBlocks) {
                tryCatch.protectedBlock = null;
            }
            BasicBlock.this.tryCatchBlocks.clear();
        }
    };

    BasicBlock(Program program, int index) {
        this.program = program;
        this.index = index;
    }

    @Override
    public Program getProgram() {
        return this.program;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    void setIndex(int index) {
        this.index = index;
    }

    void setProgram(Program program) {
        this.program = program;
    }

    public List<Instruction> getInstructions() {
        return this.safeInstructions;
    }

    public Instruction getLastInstruction() {
        return !this.instructions.isEmpty() ? this.instructions.get(this.instructions.size() - 1) : null;
    }

    public List<Phi> getPhis() {
        return this.safePhis;
    }

    @Override
    public List<? extends PhiReader> readPhis() {
        return this.immutablePhis;
    }

    @Override
    public int instructionCount() {
        return this.instructions.size();
    }

    @Override
    public void readInstruction(int index, InstructionReader reader) {
        Instruction insn = this.instructions.get(index);
        reader.location(insn.getLocation());
        insn.acceptVisitor(new InstructionReadVisitor(reader));
    }

    @Override
    public void readAllInstructions(InstructionReader reader) {
        InstructionReadVisitor visitor = new InstructionReadVisitor(reader);
        InstructionLocation location = null;
        for (Instruction insn : this.instructions) {
            if (!Objects.equals(location, insn.getLocation())) {
                location = insn.getLocation();
                reader.location(location);
            }
            insn.acceptVisitor(visitor);
        }
    }

    public List<TryCatchBlock> readTryCatchBlocks() {
        return this.immutableTryCatchBlocks;
    }

    public List<TryCatchBlock> getTryCatchBlocks() {
        return this.safeTryCatchBlocks;
    }
}

