/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.javascript;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.teavm.javascript.ast.AssignmentStatement;
import org.teavm.javascript.ast.BlockStatement;
import org.teavm.javascript.ast.BreakStatement;
import org.teavm.javascript.ast.ConditionalStatement;
import org.teavm.javascript.ast.ContinueStatement;
import org.teavm.javascript.ast.IdentifiedStatement;
import org.teavm.javascript.ast.InitClassStatement;
import org.teavm.javascript.ast.ReturnStatement;
import org.teavm.javascript.ast.SequentialStatement;
import org.teavm.javascript.ast.Statement;
import org.teavm.javascript.ast.StatementVisitor;
import org.teavm.javascript.ast.SwitchClause;
import org.teavm.javascript.ast.SwitchStatement;
import org.teavm.javascript.ast.ThrowStatement;
import org.teavm.javascript.ast.TryCatchStatement;
import org.teavm.javascript.ast.WhileStatement;

class RedundantLabelEliminator
implements StatementVisitor {
    private IdentifiedStatement currentBlock;
    private Set<IdentifiedStatement> hasRefs = new HashSet<IdentifiedStatement>();

    RedundantLabelEliminator() {
    }

    void visitSequence(List<Statement> statements) {
        for (Statement statement : statements) {
            statement.acceptVisitor(this);
        }
    }

    @Override
    public void visit(AssignmentStatement statement) {
    }

    @Override
    public void visit(SequentialStatement statement) {
        this.visitSequence(statement.getSequence());
    }

    @Override
    public void visit(ConditionalStatement statement) {
        this.visitSequence(statement.getConsequent());
        this.visitSequence(statement.getAlternative());
    }

    @Override
    public void visit(SwitchStatement statement) {
        IdentifiedStatement currentBlockBackup = this.currentBlock;
        this.currentBlock = statement;
        for (SwitchClause clause : statement.getClauses()) {
            this.visitSequence(clause.getBody());
        }
        this.visitSequence(statement.getDefaultClause());
        if (!this.hasRefs.contains(this.currentBlock)) {
            this.currentBlock.setId(null);
        }
        this.currentBlock = currentBlockBackup;
    }

    @Override
    public void visit(WhileStatement statement) {
        IdentifiedStatement currentBlockBackup = this.currentBlock;
        this.currentBlock = statement;
        this.visitSequence(statement.getBody());
        if (!this.hasRefs.contains(this.currentBlock)) {
            this.currentBlock.setId(null);
        }
        this.currentBlock = currentBlockBackup;
    }

    @Override
    public void visit(BlockStatement statement) {
        IdentifiedStatement currentBlockBackup = this.currentBlock;
        this.currentBlock = null;
        this.visitSequence(statement.getBody());
        this.currentBlock = currentBlockBackup;
    }

    @Override
    public void visit(BreakStatement statement) {
        if (statement.getTarget() == this.currentBlock) {
            statement.setTarget(null);
        } else {
            this.hasRefs.add(statement.getTarget());
        }
    }

    @Override
    public void visit(ContinueStatement statement) {
        if (statement.getTarget() == this.currentBlock) {
            statement.setTarget(null);
        } else {
            this.hasRefs.add(statement.getTarget());
        }
    }

    @Override
    public void visit(ReturnStatement statement) {
    }

    @Override
    public void visit(ThrowStatement statement) {
    }

    @Override
    public void visit(InitClassStatement statement) {
    }

    @Override
    public void visit(TryCatchStatement statement) {
        this.visitSequence(statement.getProtectedBody());
        this.visitSequence(statement.getHandler());
    }
}

