/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.dependency;

import java.util.Arrays;
import org.teavm.dependency.DependencyAgent;
import org.teavm.dependency.DependencyChecker;
import org.teavm.dependency.DependencyNode;
import org.teavm.dependency.DependencyStack;
import org.teavm.dependency.MethodDependencyInfo;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;

public class MethodDependency
implements MethodDependencyInfo {
    private DependencyChecker dependencyChecker;
    private DependencyNode[] variableNodes;
    private int parameterCount;
    private DependencyNode resultNode;
    private DependencyNode thrown;
    private DependencyStack stack;
    private MethodReader method;
    private MethodReference reference;
    private boolean used;

    MethodDependency(DependencyChecker dependencyChecker, DependencyNode[] variableNodes, int parameterCount, DependencyNode resultNode, DependencyNode thrown, DependencyStack stack, MethodReader method, MethodReference reference) {
        this.dependencyChecker = dependencyChecker;
        this.variableNodes = Arrays.copyOf(variableNodes, variableNodes.length);
        this.parameterCount = parameterCount;
        this.thrown = thrown;
        this.resultNode = resultNode;
        this.stack = stack;
        this.method = method;
        this.reference = reference;
    }

    public DependencyAgent getDependencyAgent() {
        return this.dependencyChecker;
    }

    public DependencyNode[] getVariables() {
        return Arrays.copyOf(this.variableNodes, this.variableNodes.length);
    }

    @Override
    public int getVariableCount() {
        return this.variableNodes.length;
    }

    @Override
    public DependencyNode getVariable(int index) {
        return this.variableNodes[index];
    }

    @Override
    public int getParameterCount() {
        return this.parameterCount;
    }

    @Override
    public DependencyNode getResult() {
        return this.resultNode;
    }

    @Override
    public DependencyNode getThrown() {
        return this.thrown;
    }

    @Override
    public DependencyStack getStack() {
        return this.stack;
    }

    @Override
    public MethodReference getReference() {
        return this.reference;
    }

    public MethodReader getMethod() {
        return this.method;
    }

    @Override
    public boolean isMissing() {
        return this.method == null;
    }

    @Override
    public boolean isUsed() {
        return this.used;
    }

    public void use() {
        if (!this.used) {
            this.used = true;
            if (!this.isMissing()) {
                this.dependencyChecker.scheduleMethodAnalysis(this);
            }
        }
    }
}

