/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.tooling;

import org.teavm.dependency.DependencyAgent;
import org.teavm.dependency.DependencyListener;
import org.teavm.dependency.DependencyNode;
import org.teavm.dependency.FieldDependency;
import org.teavm.dependency.MethodDependency;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.MethodReference;
import org.teavm.tooling.ExceptionHelper;

class TestExceptionDependency
implements DependencyListener {
    private MethodReference getMessageRef = new MethodReference(ExceptionHelper.class, "showException", Throwable.class, String.class);
    private DependencyNode allClasses;

    TestExceptionDependency() {
    }

    @Override
    public void started(DependencyAgent agent) {
        this.allClasses = agent.createNode();
    }

    @Override
    public void classAchieved(DependencyAgent agent, String className) {
        if (this.isException(agent.getClassSource(), className)) {
            this.allClasses.propagate(agent.getType(className));
        }
    }

    private boolean isException(ClassReaderSource classSource, String className) {
        while (className != null) {
            if (className.equals("java.lang.Throwable")) {
                return true;
            }
            ClassReader cls = classSource.get(className);
            if (cls == null) {
                return false;
            }
            className = cls.getParent();
        }
        return false;
    }

    @Override
    public void methodAchieved(DependencyAgent agent, MethodDependency method) {
        if (method.getReference().equals(this.getMessageRef)) {
            this.allClasses.connect(method.getVariable(1));
        }
    }

    @Override
    public void fieldAchieved(DependencyAgent agent, FieldDependency field) {
    }
}

