/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.optimization;

import java.util.Arrays;
import java.util.List;
import org.teavm.model.ClassHolder;
import org.teavm.model.ListableClassHolderSource;
import org.teavm.model.MethodHolder;
import org.teavm.model.Program;
import org.teavm.model.util.ProgramUtils;
import org.teavm.optimization.ArrayUnwrapMotion;
import org.teavm.optimization.GlobalValueNumbering;
import org.teavm.optimization.LoopInvariantMotion;
import org.teavm.optimization.MethodOptimization;
import org.teavm.optimization.UnusedVariableElimination;

public class ClassSetOptimizer {
    private List<MethodOptimization> getOptimizations() {
        return Arrays.asList(new ArrayUnwrapMotion(), new LoopInvariantMotion(), new GlobalValueNumbering(), new UnusedVariableElimination());
    }

    public void optimizeAll(ListableClassHolderSource classSource) {
        for (String className : classSource.getClassNames()) {
            ClassHolder cls = classSource.get(className);
            for (MethodHolder method : cls.getMethods()) {
                if (method.getProgram() == null || method.getProgram().basicBlockCount() <= 0) continue;
                Program program = ProgramUtils.copy(method.getProgram());
                for (MethodOptimization optimization : this.getOptimizations()) {
                    optimization.optimize(method, program);
                }
                method.setProgram(program);
            }
        }
    }
}

