/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model.util;

import java.util.List;
import java.util.Objects;
import org.teavm.model.BasicBlockReader;
import org.teavm.model.IncomingReader;
import org.teavm.model.InstructionLocation;
import org.teavm.model.PhiReader;
import org.teavm.model.ProgramReader;
import org.teavm.model.TryCatchBlockReader;
import org.teavm.model.VariableReader;
import org.teavm.model.util.InstructionStringifier;

public class ListingBuilder {
    /*
     * WARNING - void declaration
     */
    public String buildListing(ProgramReader program, String prefix) {
        int i;
        StringBuilder sb = new StringBuilder();
        StringBuilder insnSb = new StringBuilder();
        InstructionStringifier stringifier = new InstructionStringifier(insnSb);
        for (i = 0; i < program.variableCount(); ++i) {
            sb.append(prefix).append("var @").append(i);
            VariableReader var = program.variableAt(i);
            if (!var.readDebugNames().isEmpty()) {
                sb.append(" as ");
                boolean first = true;
                for (String string : var.readDebugNames()) {
                    if (!first) {
                        sb.append(", ");
                    }
                    first = false;
                    sb.append(string);
                }
            }
            sb.append('\n');
        }
        for (i = 0; i < program.basicBlockCount(); ++i) {
            void var9_16;
            BasicBlockReader block = program.basicBlockAt(i);
            sb.append(prefix).append("$").append(i).append(":\n");
            for (PhiReader phiReader : block.readPhis()) {
                sb.append(prefix).append("    ");
                sb.append("@").append(phiReader.getReceiver().getIndex()).append(" := ");
                List<? extends IncomingReader> list = phiReader.readIncomings();
                for (int j = 0; j < list.size(); ++j) {
                    if (j > 0) {
                        sb.append(", ");
                    }
                    IncomingReader incoming = list.get(j);
                    sb.append("@").append(incoming.getValue().getIndex()).append(" from ").append("$").append(incoming.getSource().getIndex());
                }
                sb.append("\n");
            }
            InstructionLocation location = null;
            boolean bl = false;
            while (var9_16 < block.instructionCount()) {
                insnSb.setLength(0);
                block.readInstruction((int)var9_16, stringifier);
                if (!Objects.equals(location, stringifier.getLocation())) {
                    location = stringifier.getLocation();
                    sb.append(prefix).append("  at ").append(location != null ? location.toString() : "unknown location").append('\n');
                }
                sb.append(prefix).append("    ").append((CharSequence)insnSb).append("\n");
                ++var9_16;
            }
            for (TryCatchBlockReader tryCatchBlockReader : block.readTryCatchBlocks()) {
                sb.append(prefix).append("    catch ").append(tryCatchBlockReader.getExceptionType()).append(" @").append(tryCatchBlockReader.getExceptionVariable().getIndex()).append(" -> $").append(tryCatchBlockReader.getHandler().getIndex()).append("\n");
            }
        }
        return sb.toString();
    }
}

