/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model.util;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import org.teavm.common.MutableGraphNode;
import org.teavm.model.BasicBlock;
import org.teavm.model.Incoming;
import org.teavm.model.Instruction;
import org.teavm.model.Phi;
import org.teavm.model.Program;
import org.teavm.model.TryCatchBlock;
import org.teavm.model.Variable;
import org.teavm.model.util.DefinitionExtractor;
import org.teavm.model.util.InstructionTransitionExtractor;
import org.teavm.model.util.LivenessAnalyzer;
import org.teavm.model.util.UsageExtractor;

class InterferenceGraphBuilder {
    InterferenceGraphBuilder() {
    }

    public List<MutableGraphNode> build(Program program, int paramCount, LivenessAnalyzer liveness) {
        ArrayList<MutableGraphNode> nodes = new ArrayList<MutableGraphNode>();
        for (int i = 0; i < program.variableCount(); ++i) {
            nodes.add(new MutableGraphNode(i));
        }
        UsageExtractor useExtractor = new UsageExtractor();
        DefinitionExtractor defExtractor = new DefinitionExtractor();
        InstructionTransitionExtractor succExtractor = new InstructionTransitionExtractor();
        List<List<Incoming>> outgoings = this.getOutgoings(program);
        HashSet<MutableGraphNode> live = new HashSet<MutableGraphNode>(128);
        for (int i = 0; i < program.basicBlockCount(); ++i) {
            int j;
            BasicBlock block = program.basicBlockAt(i);
            block.getLastInstruction().acceptVisitor(succExtractor);
            BitSet liveOut = new BitSet(program.variableCount());
            for (BasicBlock succ : succExtractor.getTargets()) {
                liveOut.or(liveness.liveIn(succ.getIndex()));
            }
            live.clear();
            for (int j2 = 0; j2 < liveOut.length(); ++j2) {
                if (!liveOut.get(j2)) continue;
                live.add((MutableGraphNode)nodes.get(j2));
            }
            for (Incoming outgoing : outgoings.get(i)) {
                live.add((MutableGraphNode)nodes.get(outgoing.getValue().getIndex()));
            }
            for (TryCatchBlock tryCatch : block.getTryCatchBlocks()) {
                if (tryCatch.getExceptionVariable() == null) continue;
                ((MutableGraphNode)nodes.get(tryCatch.getExceptionVariable().getIndex())).connectAll(live);
            }
            for (TryCatchBlock tryCatch : block.getTryCatchBlocks()) {
                if (tryCatch.getExceptionVariable() == null) continue;
                live.remove(tryCatch.getExceptionVariable());
            }
            for (j = block.getInstructions().size() - 1; j >= 0; --j) {
                Instruction insn = block.getInstructions().get(j);
                insn.acceptVisitor(useExtractor);
                insn.acceptVisitor(defExtractor);
                for (Variable var : defExtractor.getDefinedVariables()) {
                    ((MutableGraphNode)nodes.get(var.getIndex())).connectAll(live);
                }
                for (Variable var : defExtractor.getDefinedVariables()) {
                    live.remove(nodes.get(var.getIndex()));
                }
                for (Variable var : useExtractor.getUsedVariables()) {
                    live.add((MutableGraphNode)nodes.get(var.getIndex()));
                }
            }
            if (block.getIndex() == 0) {
                for (j = 0; j <= paramCount; ++j) {
                    ((MutableGraphNode)nodes.get(j)).connectAll(live);
                }
            }
            BitSet liveIn = liveness.liveIn(i);
            live.clear();
            for (int j3 = 0; j3 < liveOut.length(); ++j3) {
                if (!liveIn.get(j3)) continue;
                live.add((MutableGraphNode)nodes.get(j3));
            }
            for (Phi phi : block.getPhis()) {
                live.add((MutableGraphNode)nodes.get(phi.getReceiver().getIndex()));
            }
            for (Phi phi : block.getPhis()) {
                ((MutableGraphNode)nodes.get(phi.getReceiver().getIndex())).connectAll(live);
            }
        }
        return nodes;
    }

    private List<List<Incoming>> getOutgoings(Program program) {
        int i;
        ArrayList<List<Incoming>> outgoings = new ArrayList<List<Incoming>>(program.basicBlockCount());
        for (i = 0; i < program.basicBlockCount(); ++i) {
            outgoings.add(new ArrayList());
        }
        for (i = 0; i < program.basicBlockCount(); ++i) {
            BasicBlock block = program.basicBlockAt(i);
            for (Phi phi : block.getPhis()) {
                for (Incoming incoming : phi.getIncomings()) {
                    ((List)outgoings.get(incoming.getSource().getIndex())).add(incoming);
                }
            }
        }
        return outgoings;
    }
}

