/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model.util;

import java.util.List;
import org.teavm.model.BasicBlockReader;
import org.teavm.model.FieldReference;
import org.teavm.model.InstructionLocation;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;
import org.teavm.model.VariableReader;
import org.teavm.model.instructions.ArrayElementType;
import org.teavm.model.instructions.BinaryBranchingCondition;
import org.teavm.model.instructions.BinaryOperation;
import org.teavm.model.instructions.BranchingCondition;
import org.teavm.model.instructions.CastIntegerDirection;
import org.teavm.model.instructions.InstructionReader;
import org.teavm.model.instructions.IntegerSubtype;
import org.teavm.model.instructions.InvocationType;
import org.teavm.model.instructions.NumericOperandType;
import org.teavm.model.instructions.SwitchTableEntryReader;

public class InstructionStringifier
implements InstructionReader {
    private InstructionLocation location;
    private StringBuilder sb;

    public InstructionStringifier(StringBuilder sb) {
        this.sb = sb;
    }

    public InstructionLocation getLocation() {
        return this.location;
    }

    @Override
    public void location(InstructionLocation location) {
        this.location = location;
    }

    @Override
    public void nop() {
        this.sb.append("nop");
    }

    @Override
    public void classConstant(VariableReader receiver, ValueType cst) {
        this.sb.append("@").append(receiver.getIndex()).append(" := classOf ").append(cst);
    }

    @Override
    public void nullConstant(VariableReader receiver) {
        this.sb.append("@").append(receiver.getIndex()).append(" := null");
    }

    @Override
    public void integerConstant(VariableReader receiver, int cst) {
        this.sb.append("@").append(receiver.getIndex()).append(" := ").append(cst);
    }

    @Override
    public void longConstant(VariableReader receiver, long cst) {
        this.sb.append("@").append(receiver.getIndex()).append(" := ").append(cst);
    }

    @Override
    public void floatConstant(VariableReader receiver, float cst) {
        this.sb.append("@").append(receiver.getIndex()).append(" := ").append(cst);
    }

    @Override
    public void doubleConstant(VariableReader receiver, double cst) {
        this.sb.append("@").append(receiver.getIndex()).append(" := ").append(cst);
    }

    @Override
    public void stringConstant(VariableReader receiver, String cst) {
        this.sb.append("@").append(receiver.getIndex()).append(" := '").append(cst).append("'");
    }

    @Override
    public void binary(BinaryOperation op, VariableReader receiver, VariableReader first, VariableReader second, NumericOperandType type) {
        this.sb.append("@").append(receiver.getIndex()).append(" := @").append(first.getIndex()).append(" ");
        switch (op) {
            case ADD: {
                this.sb.append("+");
                break;
            }
            case AND: {
                this.sb.append("&");
                break;
            }
            case COMPARE: {
                this.sb.append("compareTo");
                break;
            }
            case DIVIDE: {
                this.sb.append("/");
                break;
            }
            case MODULO: {
                this.sb.append("%");
                break;
            }
            case MULTIPLY: {
                this.sb.append("*");
                break;
            }
            case OR: {
                this.sb.append("|");
                break;
            }
            case SHIFT_LEFT: {
                this.sb.append("<<");
                break;
            }
            case SHIFT_RIGHT: {
                this.sb.append(">>");
                break;
            }
            case SHIFT_RIGHT_UNSIGNED: {
                this.sb.append(">>>");
                break;
            }
            case SUBTRACT: {
                this.sb.append("-");
                break;
            }
            case XOR: {
                this.sb.append("^");
            }
        }
        this.sb.append(" @").append(second.getIndex());
    }

    @Override
    public void negate(VariableReader receiver, VariableReader operand, NumericOperandType type) {
        this.sb.append("@").append(receiver.getIndex()).append(" := -").append(" @").append(operand.getIndex());
    }

    @Override
    public void assign(VariableReader receiver, VariableReader assignee) {
        this.sb.append("@").append(receiver.getIndex()).append(" := @").append(assignee.getIndex());
    }

    @Override
    public void cast(VariableReader receiver, VariableReader value, ValueType targetType) {
        this.sb.append("@").append(receiver.getIndex()).append(" := cast @").append(value.getIndex()).append(" to ").append(targetType);
    }

    @Override
    public void cast(VariableReader receiver, VariableReader value, NumericOperandType sourceType, NumericOperandType targetType) {
        this.sb.append("@").append(receiver.getIndex()).append(" := cast @").append(value.getIndex()).append(" from ").append((Object)sourceType).append(" to ").append((Object)targetType);
    }

    @Override
    public void cast(VariableReader receiver, VariableReader value, IntegerSubtype type, CastIntegerDirection direction) {
        this.sb.append("@").append(receiver.getIndex()).append(" := cast @").append(value.getIndex());
        switch (direction) {
            case FROM_INTEGER: {
                this.sb.append(" from INT to ").append((Object)type);
                break;
            }
            case TO_INTEGER: {
                this.sb.append(" from ").append((Object)type).append(" to INT");
            }
        }
    }

    @Override
    public void jumpIf(BranchingCondition cond, VariableReader operand, BasicBlockReader consequent, BasicBlockReader alternative) {
        this.sb.append("if @").append(operand.getIndex()).append(" ");
        switch (cond) {
            case EQUAL: {
                this.sb.append("== 0");
                break;
            }
            case NOT_EQUAL: {
                this.sb.append("!= 0");
                break;
            }
            case GREATER: {
                this.sb.append("> 0");
                break;
            }
            case GREATER_OR_EQUAL: {
                this.sb.append(">= 0");
                break;
            }
            case LESS: {
                this.sb.append("<= 0");
                break;
            }
            case LESS_OR_EQUAL: {
                this.sb.append("< 0");
                break;
            }
            case NOT_NULL: {
                this.sb.append("!= null");
                break;
            }
            case NULL: {
                this.sb.append("== null");
            }
        }
        this.sb.append(" then goto $").append(consequent.getIndex()).append(" else goto $").append(alternative.getIndex());
    }

    @Override
    public void jumpIf(BinaryBranchingCondition cond, VariableReader first, VariableReader second, BasicBlockReader consequent, BasicBlockReader alternative) {
        this.sb.append("if @").append(first.getIndex()).append(" ");
        switch (cond) {
            case EQUAL: 
            case REFERENCE_EQUAL: {
                this.sb.append("==");
                break;
            }
            case NOT_EQUAL: 
            case REFERENCE_NOT_EQUAL: {
                this.sb.append("!=");
            }
        }
        this.sb.append("@").append(second.getIndex()).append(" then goto $").append(consequent.getIndex()).append(" else goto $").append(alternative.getIndex());
    }

    @Override
    public void jump(BasicBlockReader target) {
        this.sb.append("goto $").append(target.getIndex());
    }

    @Override
    public void choose(VariableReader condition, List<? extends SwitchTableEntryReader> table, BasicBlockReader defaultTarget) {
        this.sb.append("switch @").append(condition.getIndex()).append(" ");
        for (int i = 0; i < table.size(); ++i) {
            if (i > 0) {
                this.sb.append("; ");
            }
            SwitchTableEntryReader entry = table.get(i);
            this.sb.append("case ").append(entry.getCondition()).append(": goto $").append(entry.getTarget());
        }
        this.sb.append(", default: goto $").append(defaultTarget.getIndex());
    }

    @Override
    public void exit(VariableReader valueToReturn) {
        this.sb.append("return");
        if (valueToReturn != null) {
            this.sb.append(" @").append(valueToReturn.getIndex());
        }
    }

    @Override
    public void raise(VariableReader exception) {
        this.sb.append("throw @").append(exception.getIndex());
    }

    @Override
    public void createArray(VariableReader receiver, ValueType itemType, VariableReader size) {
        this.sb.append("@").append(receiver.getIndex()).append(" = new ").append(itemType).append("[@").append(size.getIndex()).append(']');
    }

    @Override
    public void createArray(VariableReader receiver, ValueType itemType, List<? extends VariableReader> dimensions) {
        this.sb.append("@").append(receiver.getIndex()).append(" = new ").append(itemType).append("[");
        for (int i = 0; i < dimensions.size(); ++i) {
            if (i > 0) {
                this.sb.append(", ");
            }
            this.sb.append("@").append(dimensions.get(i).getIndex());
        }
        this.sb.append("]");
    }

    @Override
    public void create(VariableReader receiver, String type) {
        this.sb.append("@").append(receiver.getIndex()).append(" = new ").append(type).append("()");
    }

    @Override
    public void getField(VariableReader receiver, VariableReader instance, FieldReference field, ValueType fieldType) {
        this.sb.append("@").append(receiver.getIndex()).append(" := ");
        if (instance != null) {
            this.sb.append("@").append(instance.getIndex());
        } else {
            this.sb.append(field.getClassName());
        }
        this.sb.append(".").append(field.getFieldName());
    }

    @Override
    public void putField(VariableReader instance, FieldReference field, VariableReader value) {
        if (instance != null) {
            this.sb.append("@").append(instance.getIndex());
        } else {
            this.sb.append(field.getClassName());
        }
        this.sb.append(".").append(field.getFieldName()).append(" := @").append(value.getIndex());
    }

    @Override
    public void arrayLength(VariableReader receiver, VariableReader array) {
        this.sb.append("@").append(receiver.getIndex()).append(" := @").append(array.getIndex()).append(".length");
    }

    @Override
    public void cloneArray(VariableReader receiver, VariableReader array) {
        this.sb.append("@").append(receiver.getIndex()).append(" := @").append(array.getIndex()).append(".clone()");
    }

    @Override
    public void unwrapArray(VariableReader receiver, VariableReader array, ArrayElementType elementType) {
        this.sb.append("@").append(receiver.getIndex()).append(" := @").append(array.getIndex()).append(".data");
    }

    @Override
    public void getElement(VariableReader receiver, VariableReader array, VariableReader index) {
        this.sb.append("@").append(receiver.getIndex()).append(" := @").append(array.getIndex()).append("[@").append(index.getIndex()).append("]");
    }

    @Override
    public void putElement(VariableReader array, VariableReader index, VariableReader value) {
        this.sb.append("@").append(array.getIndex()).append("[@").append(index.getIndex()).append("] := @").append(value.getIndex());
    }

    @Override
    public void invoke(VariableReader receiver, VariableReader instance, MethodReference method, List<? extends VariableReader> arguments, InvocationType type) {
        if (receiver != null) {
            this.sb.append("@").append(receiver.getIndex()).append(" := ");
        }
        if (instance != null) {
            this.sb.append("@").append(instance.getIndex());
        } else {
            this.sb.append(method.getClassName());
        }
        this.sb.append(".").append(method.getName()).append("(");
        for (int i = 0; i < arguments.size(); ++i) {
            if (i > 0) {
                this.sb.append(", ");
            }
            this.sb.append("@").append(arguments.get(i).getIndex());
        }
        this.sb.append(")");
    }

    @Override
    public void isInstance(VariableReader receiver, VariableReader value, ValueType type) {
        this.sb.append("@").append(receiver.getIndex()).append(" := @").append(value.getIndex()).append(" instanceof ").append(type);
    }

    @Override
    public void initClass(String className) {
        this.sb.append("initclass ").append(className);
    }

    @Override
    public void nullCheck(VariableReader receiver, VariableReader value) {
        this.sb.append("@").append(receiver.getIndex()).append(" := nullCheck @").append(value.getIndex());
    }
}

