/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model;

import org.teavm.model.MethodDescriptor;
import org.teavm.model.ValueType;

public class MethodReference {
    private String className;
    private MethodDescriptor descriptor;

    public MethodReference(String className, MethodDescriptor descriptor) {
        this.className = className;
        this.descriptor = descriptor;
    }

    public MethodReference(String className, String name, ValueType ... signature) {
        this(className, new MethodDescriptor(name, signature));
    }

    public MethodReference(Class<?> cls, String name, Class<?> ... signature) {
        this(cls.getName(), new MethodDescriptor(name, signature));
    }

    public String getClassName() {
        return this.className;
    }

    public MethodDescriptor getDescriptor() {
        return this.descriptor;
    }

    public int parameterCount() {
        return this.descriptor.parameterCount();
    }

    public ValueType[] getParameterTypes() {
        return this.descriptor.getParameterTypes();
    }

    public ValueType[] getSignature() {
        return this.descriptor.getSignature();
    }

    public String getName() {
        return this.descriptor.getName();
    }

    public int hashCode() {
        return this.className.hashCode() ^ this.descriptor.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return false;
        }
        if (!(obj instanceof MethodReference)) {
            return false;
        }
        MethodReference other = (MethodReference)obj;
        return this.className.equals(other.className) && this.descriptor.equals(other.descriptor);
    }

    public String toString() {
        return this.className + "." + this.descriptor;
    }
}

