/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.javascript;

import org.teavm.model.BasicBlock;
import org.teavm.model.Incoming;
import org.teavm.model.Instruction;
import org.teavm.model.Phi;
import org.teavm.model.Program;
import org.teavm.model.TryCatchBlock;
import org.teavm.model.Variable;
import org.teavm.model.util.DefinitionExtractor;
import org.teavm.model.util.UsageExtractor;

class ReadWriteStatsBuilder {
    public int[] reads;
    public int[] writes;

    public ReadWriteStatsBuilder(int variableCount) {
        this.reads = new int[variableCount];
        this.writes = new int[variableCount];
    }

    public void analyze(Program program) {
        DefinitionExtractor defExtractor = new DefinitionExtractor();
        UsageExtractor useExtractor = new UsageExtractor();
        for (int i = 0; i < program.basicBlockCount(); ++i) {
            BasicBlock block = program.basicBlockAt(i);
            for (Instruction insn : block.getInstructions()) {
                insn.acceptVisitor(defExtractor);
                insn.acceptVisitor(useExtractor);
                for (Variable var : defExtractor.getDefinedVariables()) {
                    int n = var.getIndex();
                    this.writes[n] = this.writes[n] + 1;
                }
                for (Variable var : useExtractor.getUsedVariables()) {
                    int n = var.getIndex();
                    this.reads[n] = this.reads[n] + 1;
                }
            }
            for (Phi phi : block.getPhis()) {
                int n = phi.getReceiver().getIndex();
                this.writes[n] = this.writes[n] + phi.getIncomings().size();
                for (Incoming incoming : phi.getIncomings()) {
                    int n2 = incoming.getValue().getIndex();
                    this.reads[n2] = this.reads[n2] + 1;
                }
            }
            for (TryCatchBlock tryCatch : block.getTryCatchBlocks()) {
                int n = tryCatch.getExceptionVariable().getIndex();
                this.writes[n] = this.writes[n] + 1;
                int n3 = tryCatch.getExceptionVariable().getIndex();
                this.reads[n3] = this.reads[n3] + 1;
            }
        }
    }
}

