/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.javascript;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.teavm.javascript.BreakToContinueReplacer;
import org.teavm.javascript.CertainBlockCountVisitor;
import org.teavm.javascript.ExprOptimizer;
import org.teavm.javascript.ReadWriteStatsBuilder;
import org.teavm.javascript.ast.AssignmentStatement;
import org.teavm.javascript.ast.BinaryExpr;
import org.teavm.javascript.ast.BinaryOperation;
import org.teavm.javascript.ast.BlockStatement;
import org.teavm.javascript.ast.BreakStatement;
import org.teavm.javascript.ast.ConditionalExpr;
import org.teavm.javascript.ast.ConditionalStatement;
import org.teavm.javascript.ast.ConstantExpr;
import org.teavm.javascript.ast.ContinueStatement;
import org.teavm.javascript.ast.Expr;
import org.teavm.javascript.ast.ExprVisitor;
import org.teavm.javascript.ast.IdentifiedStatement;
import org.teavm.javascript.ast.InitClassStatement;
import org.teavm.javascript.ast.InstanceOfExpr;
import org.teavm.javascript.ast.InvocationExpr;
import org.teavm.javascript.ast.NewArrayExpr;
import org.teavm.javascript.ast.NewExpr;
import org.teavm.javascript.ast.NewMultiArrayExpr;
import org.teavm.javascript.ast.QualificationExpr;
import org.teavm.javascript.ast.ReturnStatement;
import org.teavm.javascript.ast.SequentialStatement;
import org.teavm.javascript.ast.Statement;
import org.teavm.javascript.ast.StatementVisitor;
import org.teavm.javascript.ast.StaticClassExpr;
import org.teavm.javascript.ast.SubscriptExpr;
import org.teavm.javascript.ast.SwitchClause;
import org.teavm.javascript.ast.SwitchStatement;
import org.teavm.javascript.ast.ThrowStatement;
import org.teavm.javascript.ast.TryCatchStatement;
import org.teavm.javascript.ast.UnaryExpr;
import org.teavm.javascript.ast.UnwrapArrayExpr;
import org.teavm.javascript.ast.VariableExpr;
import org.teavm.javascript.ast.WhileStatement;

class OptimizingVisitor
implements StatementVisitor,
ExprVisitor {
    public Expr resultExpr;
    public Statement resultStmt;
    private ReadWriteStatsBuilder stats;
    private List<Statement> resultSequence;

    public OptimizingVisitor(ReadWriteStatsBuilder stats) {
        this.stats = stats;
    }

    private static boolean isZero(Expr expr) {
        return expr instanceof ConstantExpr && Integer.valueOf(0).equals(((ConstantExpr)expr).getValue());
    }

    private static boolean isComparison(Expr expr) {
        return expr instanceof BinaryExpr && ((BinaryExpr)expr).getOperation() == BinaryOperation.COMPARE;
    }

    @Override
    public void visit(BinaryExpr expr) {
        Expr a;
        switch (expr.getOperation()) {
            case AND: 
            case OR: {
                this.resultExpr = expr;
                return;
            }
        }
        expr.getSecondOperand().acceptVisitor(this);
        Expr b = this.resultExpr;
        expr.getFirstOperand().acceptVisitor(this);
        Expr p = a = this.resultExpr;
        Expr q = b;
        boolean invert = false;
        if (OptimizingVisitor.isZero(p)) {
            Expr tmp = p;
            p = q;
            q = tmp;
            invert = true;
        }
        if (OptimizingVisitor.isComparison(p) && OptimizingVisitor.isZero(q)) {
            switch (expr.getOperation()) {
                case EQUALS: 
                case NOT_EQUALS: 
                case LESS: 
                case LESS_OR_EQUALS: 
                case GREATER: 
                case GREATER_OR_EQUALS: {
                    BinaryExpr comparison = (BinaryExpr)p;
                    Expr result = BinaryExpr.binary(expr.getOperation(), comparison.getFirstOperand(), comparison.getSecondOperand());
                    result.setLocation(comparison.getLocation());
                    if (invert) {
                        result = ExprOptimizer.invert(result);
                    }
                    this.resultExpr = result;
                    return;
                }
            }
        }
        expr.setFirstOperand(a);
        expr.setSecondOperand(b);
        this.resultExpr = expr;
    }

    @Override
    public void visit(UnaryExpr expr) {
        expr.getOperand().acceptVisitor(this);
        Expr operand = this.resultExpr;
        expr.setOperand(operand);
        this.resultExpr = expr;
    }

    @Override
    public void visit(ConditionalExpr expr) {
        expr.getCondition().acceptVisitor(this);
        Expr cond = this.resultExpr;
        expr.getConsequent().acceptVisitor(this);
        Expr consequent = this.resultExpr;
        expr.getAlternative().acceptVisitor(this);
        Expr alternative = this.resultExpr;
        expr.setCondition(cond);
        expr.setConsequent(consequent);
        expr.setAlternative(alternative);
        this.resultExpr = expr;
    }

    @Override
    public void visit(ConstantExpr expr) {
        this.resultExpr = expr;
    }

    @Override
    public void visit(VariableExpr expr) {
        int index = expr.getIndex();
        this.resultExpr = expr;
        if (this.stats.reads[index] != 1 || this.stats.writes[index] != 1) {
            return;
        }
        if (this.resultSequence.isEmpty()) {
            return;
        }
        Statement last = this.resultSequence.get(this.resultSequence.size() - 1);
        if (!(last instanceof AssignmentStatement)) {
            return;
        }
        AssignmentStatement assignment = (AssignmentStatement)last;
        if (!(assignment.getLeftValue() instanceof VariableExpr)) {
            return;
        }
        VariableExpr var = (VariableExpr)assignment.getLeftValue();
        if (var.getLocation() != null && assignment.getLocation() != null && !assignment.getLocation().equals(var.getLocation())) {
            return;
        }
        if (var.getIndex() == index) {
            this.resultSequence.remove(this.resultSequence.size() - 1);
            assignment.getRightValue().setLocation(assignment.getLocation());
            assignment.getRightValue().acceptVisitor(this);
        }
    }

    @Override
    public void visit(SubscriptExpr expr) {
        expr.getIndex().acceptVisitor(this);
        Expr index = this.resultExpr;
        expr.getArray().acceptVisitor(this);
        Expr array = this.resultExpr;
        expr.setArray(array);
        expr.setIndex(index);
        this.resultExpr = expr;
    }

    @Override
    public void visit(UnwrapArrayExpr expr) {
        expr.getArray().acceptVisitor(this);
        Expr arrayExpr = this.resultExpr;
        expr.setArray(arrayExpr);
        this.resultExpr = expr;
    }

    @Override
    public void visit(InvocationExpr expr) {
        int i;
        Expr[] args = new Expr[expr.getArguments().size()];
        for (i = expr.getArguments().size() - 1; i >= 0; --i) {
            expr.getArguments().get(i).acceptVisitor(this);
            args[i] = this.resultExpr;
        }
        for (i = 0; i < args.length; ++i) {
            expr.getArguments().set(i, args[i]);
        }
        this.resultExpr = expr;
    }

    private boolean tryApplyConstructor(InvocationExpr expr) {
        if (!expr.getMethod().getName().equals("<init>")) {
            return false;
        }
        if (this.resultSequence == null || this.resultSequence.isEmpty()) {
            return false;
        }
        Statement last = this.resultSequence.get(this.resultSequence.size() - 1);
        if (!(last instanceof AssignmentStatement)) {
            return false;
        }
        AssignmentStatement assignment = (AssignmentStatement)last;
        if (!(assignment.getLeftValue() instanceof VariableExpr)) {
            return false;
        }
        VariableExpr var = (VariableExpr)assignment.getLeftValue();
        if (!(expr.getArguments().get(0) instanceof VariableExpr)) {
            return false;
        }
        VariableExpr target = (VariableExpr)expr.getArguments().get(0);
        if (target.getIndex() != var.getIndex()) {
            return false;
        }
        if (!(assignment.getRightValue() instanceof NewExpr)) {
            return false;
        }
        NewExpr constructed = (NewExpr)assignment.getRightValue();
        if (!constructed.getConstructedClass().equals(expr.getMethod().getClassName())) {
            return false;
        }
        Expr[] args = expr.getArguments().toArray(new Expr[0]);
        args = Arrays.copyOfRange(args, 1, args.length);
        Expr constructrExpr = Expr.constructObject(expr.getMethod(), args);
        constructrExpr.setLocation(expr.getLocation());
        assignment.setRightValue(constructrExpr);
        int n = var.getIndex();
        this.stats.reads[n] = this.stats.reads[n] - 1;
        return true;
    }

    @Override
    public void visit(QualificationExpr expr) {
        expr.getQualified().acceptVisitor(this);
        Expr qualified = this.resultExpr;
        expr.setQualified(qualified);
        this.resultExpr = expr;
    }

    @Override
    public void visit(NewExpr expr) {
        this.resultExpr = expr;
    }

    @Override
    public void visit(NewArrayExpr expr) {
        expr.getLength().acceptVisitor(this);
        Expr length = this.resultExpr;
        expr.setLength(length);
        this.resultExpr = expr;
    }

    @Override
    public void visit(NewMultiArrayExpr expr) {
        for (int i = 0; i < expr.getDimensions().size(); ++i) {
            Expr dimension = expr.getDimensions().get(i);
            dimension.acceptVisitor(this);
            expr.getDimensions().set(i, this.resultExpr);
        }
        this.resultExpr = expr;
    }

    @Override
    public void visit(InstanceOfExpr expr) {
        expr.getExpr().acceptVisitor(this);
        expr.setExpr(this.resultExpr);
        this.resultExpr = expr;
    }

    @Override
    public void visit(StaticClassExpr expr) {
        this.resultExpr = expr;
    }

    @Override
    public void visit(AssignmentStatement statement) {
        if (statement.getLeftValue() == null) {
            statement.getRightValue().acceptVisitor(this);
            if (this.resultExpr instanceof InvocationExpr && this.tryApplyConstructor((InvocationExpr)this.resultExpr)) {
                this.resultStmt = new SequentialStatement();
            } else {
                statement.setRightValue(this.resultExpr);
                this.resultStmt = statement;
            }
        } else {
            statement.getRightValue().acceptVisitor(this);
            Expr right = this.resultExpr;
            Expr left = statement.getLeftValue();
            if (!(statement.getLeftValue() instanceof VariableExpr)) {
                statement.getLeftValue().acceptVisitor(this);
                left = this.resultExpr;
            }
            statement.setLeftValue(left);
            statement.setRightValue(right);
            this.resultStmt = statement;
        }
    }

    private List<Statement> processSequence(List<Statement> statements) {
        List<Statement> backup = this.resultSequence;
        this.resultSequence = new ArrayList<Statement>();
        this.processSequenceImpl(statements);
        ArrayList<Statement> result = new ArrayList<Statement>();
        for (Statement part : this.resultSequence) {
            if (part == null) continue;
            result.add(part);
        }
        this.resultSequence = backup;
        return result;
    }

    private boolean processSequenceImpl(List<Statement> statements) {
        for (int i = 0; i < statements.size(); ++i) {
            Statement part = statements.get(i);
            if (part instanceof SequentialStatement) {
                if (this.processSequenceImpl(((SequentialStatement)part).getSequence())) continue;
                return false;
            }
            part.acceptVisitor(this);
            part = this.resultStmt;
            if (part instanceof SequentialStatement) {
                if (this.processSequenceImpl(((SequentialStatement)part).getSequence())) continue;
                return false;
            }
            this.resultSequence.add(part);
            if (!(part instanceof BreakStatement)) continue;
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private void eliminateRedundantBreaks(List<Statement> statements, IdentifiedStatement exit) {
        if (statements.isEmpty()) {
            return;
        }
        last = statements.get(statements.size() - 1);
        if (last instanceof BreakStatement && exit != null && exit == (target = ((BreakStatement)last).getTarget())) {
            statements.remove(statements.size() - 1);
        }
        if (statements.isEmpty()) {
            return;
        }
        for (i = 0; i < statements.size(); ++i) {
            block13: {
                stmt = statements.get(i);
                if (!(stmt instanceof ConditionalStatement)) break block13;
                cond = (ConditionalStatement)stmt;
                v0 = last = cond.getConsequent().isEmpty() != false ? null : cond.getConsequent().get(cond.getConsequent().size() - 1);
                if (!(last instanceof BreakStatement)) ** GOTO lbl-1000
                breakStmt = (BreakStatement)last;
                if (exit != null && exit == breakStmt.getTarget()) {
                    cond.getConsequent().remove(cond.getConsequent().size() - 1);
                    remaining = statements.subList(i + 1, statements.size());
                    cond.getAlternative().addAll(remaining);
                    remaining.clear();
                } else lbl-1000:
                // 2 sources

                {
                    v1 = last = cond.getAlternative().isEmpty() != false ? null : cond.getAlternative().get(cond.getAlternative().size() - 1);
                    if (last instanceof BreakStatement) {
                        breakStmt = (BreakStatement)last;
                        if (exit != null && exit == breakStmt.getTarget()) {
                            cond.getAlternative().remove(cond.getConsequent().size() - 1);
                            remaining = statements.subList(i + 1, statements.size());
                            cond.getConsequent().addAll(remaining);
                            remaining.clear();
                        }
                    }
                }
                if (i == statements.size() - 1) {
                    this.eliminateRedundantBreaks(cond.getConsequent(), exit);
                    this.eliminateRedundantBreaks(cond.getAlternative(), exit);
                }
                this.normalizeConditional(cond);
                if (cond.getConsequent().size() != 1 || !(cond.getConsequent().get(0) instanceof ConditionalStatement) || !(innerCond = (ConditionalStatement)cond.getConsequent().get(0)).getAlternative().isEmpty()) continue;
                if (cond.getAlternative().isEmpty()) {
                    cond.getConsequent().clear();
                    cond.getConsequent().addAll(innerCond.getConsequent());
                    cond.setCondition(Expr.binary(BinaryOperation.AND, cond.getCondition(), innerCond.getCondition(), cond.getCondition().getLocation()));
                    --i;
                    continue;
                }
                if (cond.getAlternative().size() == 1 && cond.getAlternative().get(0) instanceof ConditionalStatement) continue;
                cond.setCondition(ExprOptimizer.invert(cond.getCondition()));
                cond.getConsequent().clear();
                cond.getConsequent().addAll(cond.getAlternative());
                cond.getAlternative().clear();
                cond.getAlternative().add(innerCond);
                --i;
                continue;
            }
            if (stmt instanceof BlockStatement) {
                nestedBlock = (BlockStatement)stmt;
                this.eliminateRedundantBreaks(nestedBlock.getBody(), nestedBlock);
                continue;
            }
            if (stmt instanceof WhileStatement) {
                whileStmt = (WhileStatement)stmt;
                this.eliminateRedundantBreaks(whileStmt.getBody(), null);
                continue;
            }
            if (!(stmt instanceof SwitchStatement)) continue;
            switchStmt = (SwitchStatement)stmt;
            for (SwitchClause clause : switchStmt.getClauses()) {
                this.eliminateRedundantBreaks(clause.getBody(), null);
            }
            this.eliminateRedundantBreaks(switchStmt.getDefaultClause(), null);
        }
    }

    private void normalizeConditional(ConditionalStatement stmt) {
        if (stmt.getConsequent().isEmpty()) {
            stmt.getConsequent().addAll(stmt.getAlternative());
            stmt.getAlternative().clear();
            stmt.setCondition(ExprOptimizer.invert(stmt.getCondition()));
        }
    }

    @Override
    public void visit(SequentialStatement statement) {
        List<Statement> statements = this.processSequence(statement.getSequence());
        if (statements.size() == 1) {
            this.resultStmt = statements.get(0);
        } else {
            statement.getSequence().clear();
            statement.getSequence().addAll(statements);
            this.resultStmt = statement;
        }
    }

    @Override
    public void visit(ConditionalStatement statement) {
        statement.getCondition().acceptVisitor(this);
        statement.setCondition(this.resultExpr);
        List<Statement> consequent = this.processSequence(statement.getConsequent());
        List<Statement> alternative = this.processSequence(statement.getAlternative());
        if (consequent.isEmpty()) {
            consequent.addAll(alternative);
            alternative.clear();
            statement.setCondition(ExprOptimizer.invert(statement.getCondition()));
        }
        if (consequent.isEmpty()) {
            this.resultStmt = Statement.empty();
            return;
        }
        statement.getConsequent().clear();
        statement.getConsequent().addAll(consequent);
        statement.getAlternative().clear();
        statement.getAlternative().addAll(alternative);
        this.resultStmt = statement;
    }

    @Override
    public void visit(SwitchStatement statement) {
        statement.getValue().acceptVisitor(this);
        statement.setValue(this.resultExpr);
        for (SwitchClause clause : statement.getClauses()) {
            List<Statement> newBody = this.processSequence(clause.getBody());
            clause.getBody().clear();
            clause.getBody().addAll(newBody);
        }
        List<Statement> newDefault = this.processSequence(statement.getDefaultClause());
        statement.getDefaultClause().clear();
        statement.getDefaultClause().addAll(newDefault);
        this.resultStmt = statement;
    }

    @Override
    public void visit(WhileStatement statement) {
        BreakStatement breakStmt;
        ConditionalStatement cond;
        if (statement.getBody().size() == 1 && statement.getBody().get(0) instanceof WhileStatement) {
            WhileStatement innerLoop = (WhileStatement)statement.getBody().get(0);
            BreakToContinueReplacer replacer = new BreakToContinueReplacer(innerLoop, statement);
            replacer.visitSequence(innerLoop.getBody());
            statement.getBody().clear();
            statement.getBody().addAll(innerLoop.getBody());
        }
        List<Statement> statements = this.processSequence(statement.getBody());
        for (int i = 0; i < statements.size(); ++i) {
            ContinueStatement continueStmt;
            if (!(statements.get(i) instanceof ContinueStatement) || (continueStmt = (ContinueStatement)statements.get(i)).getTarget() != statement) continue;
            statements.subList(i, statements.size()).clear();
            break;
        }
        statement.getBody().clear();
        statement.getBody().addAll(statements);
        if (statement.getCondition() != null) {
            List<Statement> sequenceBackup = this.resultSequence;
            this.resultSequence = new ArrayList<Statement>();
            statement.getCondition().acceptVisitor(this);
            statement.setCondition(this.resultExpr);
            this.resultSequence = sequenceBackup;
        }
        while (!statement.getBody().isEmpty() && statement.getBody().get(0) instanceof ConditionalStatement && (cond = (ConditionalStatement)statement.getBody().get(0)).getConsequent().size() == 1 && cond.getConsequent().get(0) instanceof BreakStatement && (breakStmt = (BreakStatement)cond.getConsequent().get(0)).getTarget() == statement) {
            statement.getBody().remove(0);
            if (statement.getCondition() != null) {
                Expr newCondition = Expr.binary(BinaryOperation.AND, statement.getCondition(), ExprOptimizer.invert(cond.getCondition()));
                newCondition.setLocation(statement.getCondition().getLocation());
                statement.setCondition(newCondition);
                continue;
            }
            statement.setCondition(ExprOptimizer.invert(cond.getCondition()));
        }
        this.resultStmt = statement;
    }

    @Override
    public void visit(BlockStatement statement) {
        List<Statement> statements = this.processSequence(statement.getBody());
        this.eliminateRedundantBreaks(statements, statement);
        CertainBlockCountVisitor usageCounter = new CertainBlockCountVisitor(statement);
        usageCounter.visit(statements);
        if (usageCounter.getCount() == 0) {
            SequentialStatement result = new SequentialStatement();
            result.getSequence().addAll(statements);
            this.resultStmt = result;
        } else {
            statement.getBody().clear();
            statement.getBody().addAll(statements);
            this.resultStmt = statement;
        }
    }

    @Override
    public void visit(BreakStatement statement) {
        this.resultStmt = statement;
    }

    @Override
    public void visit(ContinueStatement statement) {
        this.resultStmt = statement;
    }

    @Override
    public void visit(ReturnStatement statement) {
        if (statement.getResult() != null) {
            statement.getResult().acceptVisitor(this);
            statement.setResult(this.resultExpr);
        }
        this.resultStmt = statement;
    }

    @Override
    public void visit(ThrowStatement statement) {
        statement.getException().acceptVisitor(this);
        statement.setException(this.resultExpr);
        this.resultStmt = statement;
    }

    @Override
    public void visit(InitClassStatement statement) {
        this.resultStmt = statement;
    }

    @Override
    public void visit(TryCatchStatement statement) {
        List<Statement> statements = this.processSequence(statement.getProtectedBody());
        statement.getProtectedBody().clear();
        statement.getProtectedBody().addAll(statements);
        statements = this.processSequence(statement.getHandler());
        statement.getHandler().clear();
        statement.getHandler().addAll(statements);
        this.resultStmt = statement;
    }
}

