/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.javascript;

import org.teavm.javascript.OptimizingVisitor;
import org.teavm.javascript.ReadWriteStatsBuilder;
import org.teavm.javascript.RedundantLabelEliminator;
import org.teavm.javascript.UnusedVariableEliminator;
import org.teavm.javascript.ast.RegularMethodNode;
import org.teavm.model.Program;

public class Optimizer {
    public void optimize(RegularMethodNode method, Program program) {
        ReadWriteStatsBuilder stats = new ReadWriteStatsBuilder(method.getVariables().size());
        stats.analyze(program);
        OptimizingVisitor optimizer = new OptimizingVisitor(stats);
        method.getBody().acceptVisitor(optimizer);
        method.setBody(optimizer.resultStmt);
        int paramCount = method.getReference().parameterCount();
        UnusedVariableEliminator unusedEliminator = new UnusedVariableEliminator(paramCount, method.getVariables());
        method.getBody().acceptVisitor(unusedEliminator);
        method.getVariables().subList(unusedEliminator.lastIndex, method.getVariables().size()).clear();
        RedundantLabelEliminator labelEliminator = new RedundantLabelEliminator();
        method.getBody().acceptVisitor(labelEliminator);
        for (int i = 0; i < method.getVariables().size(); ++i) {
            method.getVariables().set(i, i);
        }
    }
}

